/*
 * Decompiled with CFR 0.152.
 */
package com.sonicmetrics.core.shared.util;

public class SharedIndexedDay {
    public static final long MINUTES_PER_DAY = 1440L;
    public static final long MILLIS_PER_MINUTE = 60000L;
    public static final long MILLIS_PER_DAY = 86400000L;

    protected static void assertAfterBigBang(long timeUtc, long bigBang) {
        if (timeUtc < bigBang) {
            throw new IllegalArgumentException("not a valid timeStamp - must be after " + bigBang + ", was on " + timeUtc);
        }
    }

    public static int toIndexedDay(long timeUtc, long bigBang) {
        SharedIndexedDay.assertAfterBigBang(timeUtc, bigBang);
        long millisSinceBigBang = timeUtc - bigBang;
        double index = (double)millisSinceBigBang / 8.64E7;
        return (int)Math.floor(index);
    }

    public static int toUpperIndexedDay(long timeUtc, long bigBang) {
        SharedIndexedDay.assertAfterBigBang(timeUtc, bigBang);
        long millisSinceBigBang = timeUtc - bigBang;
        double index = (double)millisSinceBigBang / 8.64E7;
        return (int)Math.ceil(index);
    }

    public static long toTimeOnIndexedDay(long timeUtc, long bigBang) {
        SharedIndexedDay.assertAfterBigBang(timeUtc, bigBang);
        long millisSinceBigBang = timeUtc - bigBang;
        long millisOnDay = millisSinceBigBang % 86400000L;
        return millisOnDay;
    }

    public static long toUpperUtc(int indexedDay, long bigBang) {
        return ((long)indexedDay + 1L) * 86400000L + bigBang;
    }

    public static long toUtc(int indexedDay, long bigBang) {
        return (long)indexedDay * 86400000L + bigBang;
    }
}

