/*
 * Decompiled with CFR 0.152.
 */
package com.sonicmetrics.core.shared.util;

public class JsonUtils {
    static char[] hex = "0123456789ABCDEF".toCharArray();

    public static StringBuilder string(String raw) {
        StringBuilder b = new StringBuilder();
        if (raw == null) {
            b.append("null");
            return b;
        }
        b.append('\"');
        for (int i = 0; i < raw.length(); ++i) {
            char c = raw.charAt(i);
            if (c == '\"') {
                b.append("\\\"");
                continue;
            }
            if (c == '\\') {
                b.append("\\\\");
                continue;
            }
            if (c == '/') {
                b.append("\\/");
                continue;
            }
            if (c == '\b') {
                b.append("\\b");
                continue;
            }
            if (c == '\f') {
                b.append("\\f");
                continue;
            }
            if (c == '\n') {
                b.append("\\n");
                continue;
            }
            if (c == '\r') {
                b.append("\\r");
                continue;
            }
            if (c == '\t') {
                b.append("\\t");
                continue;
            }
            if (JsonUtils.isISOControl(c)) {
                b.append((CharSequence)JsonUtils.unicode(c));
                continue;
            }
            b.append(c);
        }
        b.append('\"');
        return b;
    }

    public static boolean isISOControl(char c) {
        return '\u0000' <= c && c <= '\u001f' || '\u007f' <= c && c <= '\u009f';
    }

    protected static StringBuilder unicode(char c) {
        StringBuilder b = new StringBuilder();
        b.append("\\u");
        int n = c;
        for (int i = 0; i < 4; ++i) {
            int digit = (n & 0xF000) >> 12;
            b.append(hex[digit]);
            n <<= 4;
        }
        return b;
    }

    public static void appendKeyValue(StringBuilder b, String key, String value) {
        b.append(JsonUtils.string(key).toString()).append(": ").append(JsonUtils.string(value).toString());
    }

    public static void appendKeyValue(StringBuilder b, String key, long value) {
        b.append(JsonUtils.string(key).toString()).append(": ").append(value);
    }
}

