/*
 * Decompiled with CFR 0.152.
 */
package com.sonicmetrics.core.shared.query;

import com.sonicmetrics.core.shared.ISonicPotentialEvent;
import com.sonicmetrics.core.shared.impl.memory.SonicUtils;
import com.sonicmetrics.core.shared.query.ISonicFilter;
import com.sonicmetrics.core.shared.query.KeyValueConstraint;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

public class SonicFilter
implements ISonicFilter,
Serializable {
    private static final long serialVersionUID = 1L;
    protected final Map<String, KeyValueConstraint> keyValueConstraints = new HashMap<String, KeyValueConstraint>();

    public SonicFilter(KeyValueConstraint ... keyValueConstraints) {
        for (KeyValueConstraint a : Arrays.asList(keyValueConstraints)) {
            this.keyValueConstraints.put(a.getKey(), a);
        }
    }

    @Override
    public Collection<KeyValueConstraint> getKeyValueConstraints() {
        return this.keyValueConstraints.values();
    }

    public static Builder create() {
        return new Builder();
    }

    @Override
    public String getSubject() {
        return SonicFilter.valueOf(this.keyValueConstraints.get(ISonicPotentialEvent.FilterProperty.Subject.name()));
    }

    private static String valueOf(KeyValueConstraint keyValueConstraint) {
        if (keyValueConstraint == null) {
            return null;
        }
        return keyValueConstraint.getValue();
    }

    @Override
    public String getCategory() {
        return SonicFilter.valueOf(this.keyValueConstraints.get(ISonicPotentialEvent.FilterProperty.Category.name()));
    }

    @Override
    public String getAction() {
        return SonicFilter.valueOf(this.keyValueConstraints.get(ISonicPotentialEvent.FilterProperty.Action.name()));
    }

    @Override
    public String getLabel() {
        return SonicFilter.valueOf(this.keyValueConstraints.get(ISonicPotentialEvent.FilterProperty.Label.name()));
    }

    @Override
    public String getSource() {
        return SonicFilter.valueOf(this.keyValueConstraints.get(ISonicPotentialEvent.FilterProperty.Source.name()));
    }

    @Override
    public String getDotString() {
        return SonicUtils.toDoStringWithWildcards(this.getCategory(), this.getAction(), this.getLabel());
    }

    public static boolean equals(ISonicFilter a, ISonicFilter b) {
        if (!SonicUtils.bothNullOrEqual(a.getSubject(), b.getSubject())) {
            return false;
        }
        if (!SonicUtils.bothNullOrEqual(a.getCategory(), b.getCategory())) {
            return false;
        }
        if (!SonicUtils.bothNullOrEqual(a.getAction(), b.getAction())) {
            return false;
        }
        if (!SonicUtils.bothNullOrEqual(a.getLabel(), b.getLabel())) {
            return false;
        }
        return SonicUtils.bothNullOrEqual(a.getSource(), b.getSource());
    }

    public boolean equals(Object other) {
        if (!(other instanceof ISonicFilter)) {
            return false;
        }
        ISonicFilter o = (ISonicFilter)other;
        return SonicFilter.equals(this, o);
    }

    public boolean includes(ISonicFilter other) {
        if (!SonicUtils.moreGeneralThanOrEqualTo(this.getSubject(), other.getSubject())) {
            return false;
        }
        if (!SonicUtils.moreGeneralThanOrEqualTo(this.getCategory(), other.getCategory())) {
            return false;
        }
        if (!SonicUtils.moreGeneralThanOrEqualTo(this.getAction(), other.getAction())) {
            return false;
        }
        if (!SonicUtils.moreGeneralThanOrEqualTo(this.getLabel(), other.getLabel())) {
            return false;
        }
        return SonicUtils.moreGeneralThanOrEqualTo(this.getSource(), other.getSource());
    }

    public int hashCode() {
        return SonicUtils.hashCode(this.getSubject()) + SonicUtils.hashCode(this.getSource()) + SonicUtils.hashCode(this.getCategory()) + SonicUtils.hashCode(this.getAction()) + SonicUtils.hashCode(this.getLabel());
    }

    public String toString() {
        return "cat.act.lab.sou.sub=" + this.getCategory() + "." + this.getAction() + "." + this.getLabel() + "." + this.getSource() + "." + this.getSubject();
    }

    public static class Builder
    extends AbstractBuilder<SonicFilter, Builder> {
        public Builder() {
            this.b = this;
        }

        public SonicFilter done() {
            return new SonicFilter(this.keyValueConstraints.toArray(new KeyValueConstraint[this.keyValueConstraints.size()]));
        }
    }

    public static abstract class AbstractBuilder<T, B extends AbstractBuilder<T, B>> {
        protected final ArrayList<KeyValueConstraint> keyValueConstraints = new ArrayList();
        protected B b;

        public B where(KeyValueConstraint keyValueConstraint) {
            if (keyValueConstraint.getValue() == null || keyValueConstraint.getValue().equals("") || keyValueConstraint.getValue().equals("*")) {
                return this.b;
            }
            this.keyValueConstraints.add(keyValueConstraint);
            return this.b;
        }

        public B whereProperty(ISonicPotentialEvent.FilterProperty key, String value) {
            return this.where(KeyValueConstraint.keyValue(key.name(), value));
        }

        public B categoryActionLabelSubjectSource(String category, String action, String label, String subject, String source) {
            this.whereProperty(ISonicPotentialEvent.FilterProperty.Category, category);
            this.whereProperty(ISonicPotentialEvent.FilterProperty.Action, action);
            this.whereProperty(ISonicPotentialEvent.FilterProperty.Label, label);
            this.whereProperty(ISonicPotentialEvent.FilterProperty.Subject, subject);
            this.whereProperty(ISonicPotentialEvent.FilterProperty.Source, source);
            return this.b;
        }
    }
}

