/*
 * Decompiled with CFR 0.152.
 */
package de.xam.md5;

import de.xam.md5.MD5;
import de.xam.md5.MD5InputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;

public class MD5File {
    public static byte[] getHash(File f) throws IOException {
        if (!f.exists()) {
            throw new FileNotFoundException(f.toString());
        }
        InputStream close_me = null;
        try {
            long buf_size = f.length();
            if (buf_size < 512L) {
                buf_size = 512L;
            }
            if (buf_size > 65536L) {
                buf_size = 65536L;
            }
            byte[] buf = new byte[(int)buf_size];
            MD5InputStream in = new MD5InputStream(new FileInputStream(f));
            close_me = in;
            while (in.read(buf) != -1) {
            }
            in.close();
            return in.hash();
        }
        catch (IOException e) {
            if (close_me != null) {
                try {
                    close_me.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            throw e;
        }
    }

    public static String getHashAsHexString(File f) throws IOException {
        assert (!f.isDirectory());
        byte[] hash = MD5File.getHash(f);
        String hashString = MD5.asHex(hash);
        return hashString;
    }

    public static byte[] getHash(InputStream in, long bodyLength) throws IOException {
        InputStream close_me = null;
        try {
            long buf_size = bodyLength;
            if (buf_size < 512L) {
                buf_size = 512L;
            }
            if (buf_size > 65536L) {
                buf_size = 65536L;
            }
            byte[] buf = new byte[(int)buf_size];
            MD5InputStream md5in = new MD5InputStream(in);
            close_me = md5in;
            while (md5in.read(buf) != -1) {
            }
            md5in.close();
            return md5in.hash();
        }
        catch (IOException e) {
            close_me.close();
            throw e;
        }
    }
}

