/*
 * Decompiled with CFR 0.152.
 */
package org.xydra.jetty;

import com.google.common.collect.Sets;
import java.io.IOException;
import java.security.Principal;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Collections;
import java.util.Locale;
import java.util.TimeZone;
import javax.security.auth.Subject;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpServletResponseWrapper;
import org.eclipse.jetty.security.IdentityService;
import org.eclipse.jetty.security.LoginService;
import org.eclipse.jetty.server.UserIdentity;
import org.xydra.log.api.Logger;
import org.xydra.log.api.LoggerFactory;
import org.xydra.restless.utils.Delay;

public class JettyUtils {
    private static final Logger log = LoggerFactory.getLogger(JettyUtils.class);

    public static LoginService createInsecureTestLoginService() {
        return new LoginService(){
            private String name;
            private IdentityService service;

            public boolean validate(UserIdentity user) {
                return user.getUserPrincipal().getName().equalsIgnoreCase("admin");
            }

            public void setIdentityService(IdentityService service) {
                this.service = service;
            }

            public void logout(UserIdentity user) {
            }

            public UserIdentity login(final String username, Object credentials) {
                this.name = username;
                return new UserIdentity(){

                    public Subject getSubject() {
                        return new Subject(true, Sets.newHashSet((Object[])new Principal[]{this.getUserPrincipal()}), Collections.EMPTY_SET, Collections.EMPTY_SET);
                    }

                    public Principal getUserPrincipal() {
                        return new Principal(){

                            @Override
                            public String getName() {
                                return username;
                            }
                        };
                    }

                    public boolean isUserInRole(String role, UserIdentity.Scope scope) {
                        return username.equalsIgnoreCase("admin");
                    }
                };
            }

            public String getName() {
                return this.name;
            }

            public IdentityService getIdentityService() {
                return this.service;
            }
        };
    }

    public static Filter createOneYearCachingFilter() {
        return new Filter(){

            public void destroy() {
            }

            public void doFilter(ServletRequest request, ServletResponse response, FilterChain filterChain) throws IOException, ServletException {
                log.debug("JETTY Image GET " + ((HttpServletRequest)request).getRequestURI());
                HttpServletResponseWrapper responseWrapper = new HttpServletResponseWrapper((HttpServletResponse)response);
                Calendar cal = Calendar.getInstance();
                cal.set(1, cal.get(1) + 1);
                SimpleDateFormat dateFormatter = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss z", Locale.US);
                TimeZone tz = TimeZone.getTimeZone("GMT");
                dateFormatter.setTimeZone(tz);
                String rfc1123 = dateFormatter.format(cal.getTime());
                ((HttpServletResponse)response).addHeader("Expires", rfc1123);
                ((HttpServletResponse)response).addHeader("Cache-Control", "public; max-age=31536000");
                filterChain.doFilter(request, (ServletResponse)responseWrapper);
            }

            public void init(FilterConfig filterConfig) {
            }
        };
    }

    public static Filter createNoCacheFilter() {
        return new Filter(){

            public void destroy() {
            }

            public void doFilter(ServletRequest request, ServletResponse response, FilterChain filterChain) throws IOException, ServletException {
                log.debug("Don't cache " + ((HttpServletRequest)request).getRequestURI());
                HttpServletResponseWrapper responseWrapper = new HttpServletResponseWrapper((HttpServletResponse)response);
                Calendar cal = Calendar.getInstance();
                cal.set(1, cal.get(1) - 1);
                SimpleDateFormat dateFormatter = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss z", Locale.US);
                TimeZone tz = TimeZone.getTimeZone("GMT");
                dateFormatter.setTimeZone(tz);
                String rfc1123 = dateFormatter.format(cal.getTime());
                ((HttpServletResponse)response).addHeader("Expires", rfc1123);
                log.debug("Set expire to " + rfc1123);
                ((HttpServletResponse)response).addHeader("Cache-Control", "no-cache, must-revalidate");
                HttpServletRequestWrapper requestWrapper = new HttpServletRequestWrapper((HttpServletRequest)request){

                    public String getHeader(String name) {
                        if (name.equals("If-Modified-Since")) {
                            return null;
                        }
                        return super.getHeader(name);
                    }

                    public long getDateHeader(String name) {
                        if (name.equals("If-Modified-Since")) {
                            return -1L;
                        }
                        return super.getDateHeader(name);
                    }
                };
                filterChain.doFilter((ServletRequest)requestWrapper, (ServletResponse)responseWrapper);
            }

            public void init(FilterConfig filterConfig) {
            }
        };
    }

    public static long timeSinceStart(long startTime) {
        return System.currentTimeMillis() - startTime;
    }

    public static Filter createRequestCountingFilter() {
        return new Filter(){
            private int requests = 0;
            private final long startTime = System.currentTimeMillis();

            public void destroy() {
            }

            public void doFilter(ServletRequest req, ServletResponse response, FilterChain filterChain) throws IOException, ServletException {
                ++this.requests;
                if (req instanceof HttpServletRequest) {
                    HttpServletRequest hreq = (HttpServletRequest)req;
                    log.info("_____JETTY #" + this.requests + " " + hreq.getMethod() + " " + hreq.getRequestURL() + " @" + JettyUtils.timeSinceStart(this.startTime));
                } else {
                    log.info("_____JETTY Request Nr. " + this.requests + " @" + JettyUtils.timeSinceStart(this.startTime));
                }
                filterChain.doFilter(req, response);
            }

            public void init(FilterConfig filterConfig) {
            }
        };
    }

    public static Filter createSimulateNetworkDelaysFilter() {
        return new Filter(){

            public void destroy() {
            }

            public void doFilter(ServletRequest req, ServletResponse response, FilterChain filterChain) throws IOException, ServletException {
                Delay.servePage();
                filterChain.doFilter(req, response);
            }

            public void init(FilterConfig filterConfig) {
            }
        };
    }
}

