/*
 * Decompiled with CFR 0.152.
 */
package org.xydra.restless.utils;

import org.xydra.common.NanoClock;

public class Progress {
    private final NanoClock clock = new NanoClock();
    private long count = 0L;

    public void startTime() {
        this.clock.start();
    }

    public void makeProgress(long howMuch) {
        this.count += howMuch;
    }

    public double getMsPerProgress() {
        return (double)this.clock.getDurationSinceStart() / (double)this.count;
    }

    public long willTakeMsUntilProgressIs(long howMuchTotal) {
        return (long)((double)howMuchTotal * this.getMsPerProgress()) - this.getMsSinceStart();
    }

    public long getProgress() {
        return this.count;
    }

    public long getMsSinceStart() {
        return this.clock.getDurationSinceStart();
    }

    public String toString() {
        return "Running for " + this.getMsSinceStart() + "ms and made " + this.count + " progress; that's " + this.getMsPerProgress() + "ms for each.";
    }

    public String info(long totalCount) {
        return "Running for " + this.getMsSinceStart() + "ms. " + this.getMsPerProgress() + "ms for each. " + this.willTakeMsUntilProgressIs(totalCount) + " ms (" + this.willTakeMsUntilProgressIs(totalCount) / 60000L + "min) until finished.";
    }
}

