/*
 * Decompiled with CFR 0.152.
 */
package com.sonicmetrics.gaeserver.impl;

import com.google.appengine.api.datastore.Entity;
import com.google.appengine.api.datastore.Key;
import com.google.apphosting.api.ApiProxy;
import com.sonicmetrics.core.shared.ISonicEvent;
import com.sonicmetrics.core.shared.query.ISonicListener;
import com.sonicmetrics.gaeserver.impl.SonicEventCodec;
import java.util.LinkedList;
import org.xydra.log.api.Logger;
import org.xydra.log.api.LoggerFactory;
import org.xydra.xgae.XGae;
import org.xydra.xgae.datastore.api.SEntity;
import org.xydra.xgae.datastore.api.SKey;

public class SonicStoringListener
implements ISonicListener {
    private static final Logger log = LoggerFactory.getLogger(SonicStoringListener.class);

    public void receiveEvent(ISonicEvent se) {
        SonicStoringListener.receiveEvent(se, false);
    }

    private static void receiveEvent(ISonicEvent se, boolean async) {
        log.debug("Storing event " + se);
        SEntity e = SonicStoringListener.toEntity(se);
        try {
            if (async) {
                XGae.get().datastore().async().putEntity(e);
            } else {
                XGae.get().datastore().sync().putEntity(e);
            }
        }
        catch (ApiProxy.CapabilityDisabledException err) {
            log.warn("Could not write " + se.toString(), (Throwable)err);
        }
    }

    private static SEntity toEntity(ISonicEvent se) {
        SonicStoringListener.ensureEventHasKey(se);
        assert (se.getKey() != null);
        SKey key = XGae.get().datastore().createKey("SEV", se.getKey());
        SEntity e = SonicEventCodec.INSTANCE.toEntity(key, se);
        return e;
    }

    private static void ensureEventHasKey(ISonicEvent se) {
        if (se.getKey() == null) {
            Entity entity;
            if (se.hasUniqueId() && (entity = SonicEventCodec.getEntityWithUniqueId(se.getWhen(), se.getUniqueId())) != null) {
                Key previousKey = entity.getKey();
                se.setKey(previousKey.getName());
            }
            if (se.getKey() == null) {
                se.setKey(SonicEventCodec.generateKey(se).getName());
            }
        }
    }

    public void setKey(ISonicEvent sonicEvent) {
        sonicEvent.setKey(SonicEventCodec.generateKeyName(sonicEvent.getWhen()));
    }

    public void receiveEventAsync(ISonicEvent sonicEvent) {
        SonicStoringListener.receiveEvent(sonicEvent, true);
    }

    public void receiveEventsAsync(Iterable<? extends ISonicEvent> it) {
        log.debug("Storing many events async ");
        LinkedList<SEntity> list = new LinkedList<SEntity>();
        for (ISonicEvent iSonicEvent : it) {
            list.add(SonicStoringListener.toEntity(iSonicEvent));
        }
        SonicStoringListener.receiveEvents(list, true);
    }

    public void receiveEvents(Iterable<? extends ISonicEvent> it) {
        log.debug("Storing many events sync ");
        LinkedList<SEntity> list = new LinkedList<SEntity>();
        for (ISonicEvent iSonicEvent : it) {
            list.add(SonicStoringListener.toEntity(iSonicEvent));
        }
        SonicStoringListener.receiveEvents(list, false);
    }

    private static void receiveEvents(Iterable<SEntity> list, boolean async) {
        try {
            if (async) {
                XGae.get().datastore().async().putEntities(list);
            } else {
                XGae.get().datastore().sync().putEntities(list);
            }
        }
        catch (ApiProxy.CapabilityDisabledException err) {
            log.warn("Could not write entities", (Throwable)err);
        }
    }
}

