/*
 * Decompiled with CFR 0.152.
 */
package com.sonicmetrics.gaeserver.impl;

import com.google.appengine.api.datastore.Entity;
import com.google.appengine.api.datastore.FetchOptions;
import com.google.appengine.api.datastore.Key;
import com.google.appengine.api.datastore.KeyFactory;
import com.google.appengine.api.datastore.PreparedQuery;
import com.google.appengine.api.datastore.PropertyContainer;
import com.google.appengine.api.datastore.PropertyProjection;
import com.google.appengine.api.datastore.Query;
import com.sonicmetrics.core.shared.ISonicEvent;
import com.sonicmetrics.core.shared.ISonicPotentialEvent;
import com.sonicmetrics.core.shared.LimitReachedException;
import com.sonicmetrics.core.shared.impl.memory.SonicEvent;
import com.sonicmetrics.core.shared.query.ISonicQuery;
import com.sonicmetrics.core.shared.query.KeyValueConstraint;
import com.sonicmetrics.core.shared.query.SonicMetadataResult;
import com.sonicmetrics.core.shared.query.TimeConstraint;
import com.sonicmetrics.gaeserver.impl.GaeUtils;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.xydra.base.id.UUID;
import org.xydra.index.iterator.ITransformer;
import org.xydra.index.iterator.TransformingIterator;
import org.xydra.store.impl.gae.UniCache;
import org.xydra.xgae.datastore.api.SEntity;
import org.xydra.xgae.datastore.api.SKey;
import org.xydra.xgae.datastore.impl.gae.GEntity;

public class SonicEventCodec
implements UniCache.CacheEntryHandler<ISonicEvent> {
    public static final String KIND_SONICEVENT = "SEV";
    public static final String PROP_KEY_SUBJECT = "!sub";
    public static final String PROP_KEY_CATEGORY = "!cat";
    public static final String PROP_KEY_ACTION = "!act";
    public static final String PROP_KEY_LABEL = "!lab";
    public static final String PROP_KEY_VALUE = "!val";
    public static final String PROP_KEY_SOURCE = "!src";
    public static final String PROP_KEY_UNIQUEID = "!uid";
    private static final String TIME_UUID_SEP = "-";
    public static final SonicEventCodec INSTANCE = new SonicEventCodec();
    public static final String KEY = "__key__";

    private static ITransformer<Entity, ISonicEvent> createEventTransformer(final long limit) throws LimitReachedException {
        return new ITransformer<Entity, ISonicEvent>(){
            long count = 0L;

            public ISonicEvent transform(Entity in) {
                ++this.count;
                if (limit > 0L && this.count >= limit) {
                    throw new LimitReachedException(limit);
                }
                return INSTANCE.fromEntity((SEntity)GEntity.wrap((Entity)in));
            }
        };
    }

    public static Iterator<ISonicEvent> convert(Iterator<Entity> it, long limit) {
        return new TransformingIterator(it, SonicEventCodec.createEventTransformer(limit));
    }

    @Deprecated
    public static Iterator<ISonicEvent> convert(Iterator<Entity> it) {
        return new TransformingIterator(it, SonicEventCodec.createEventTransformer(-1L));
    }

    public static void addToSonicMetadataResult(Entity entity, SonicMetadataResult result) {
        for (Map.Entry prop : entity.getProperties().entrySet()) {
            String key = (String)prop.getKey();
            String s = GaeUtils.fromGaePropertyValue(prop.getValue());
            if (s == null) continue;
            if (key.equals(PROP_KEY_ACTION)) {
                result.action.add((Object)s);
                continue;
            }
            if (key.equals(PROP_KEY_CATEGORY)) {
                result.category.add((Object)s);
                continue;
            }
            if (key.equals(PROP_KEY_LABEL)) {
                result.label.add((Object)s);
                continue;
            }
            if (key.equals(PROP_KEY_SOURCE)) {
                result.source.add((Object)s);
                continue;
            }
            if (!key.equals(PROP_KEY_SUBJECT)) continue;
            result.subject.add((Object)s);
        }
    }

    public static Key generateKey(ISonicEvent se) {
        String keyname = null;
        if (se.getKey() != null) {
            keyname = se.getKey();
            assert (se.getWhen() == SonicEventCodec.getWhenFromKeyName(keyname));
        } else {
            long utcTimestamp = se.getWhen();
            keyname = SonicEventCodec.generateKeyName(utcTimestamp);
        }
        return KeyFactory.createKey((String)KIND_SONICEVENT, (String)keyname);
    }

    public static String generateKeyName(long utcTimestamp) {
        String name = utcTimestamp + TIME_UUID_SEP + UUID.uuid((int)8);
        return name;
    }

    public static long getWhenFromKey(Key key) {
        assert (key.getKind().equals(KIND_SONICEVENT));
        return SonicEventCodec.getWhenFromKeyName(key.getName());
    }

    public static long getWhenFromKeyName(String keyname) {
        String[] parts = keyname.split(TIME_UUID_SEP);
        assert (parts.length == 2);
        Long l = Long.parseLong(parts[0]);
        return l;
    }

    public static Entity getEntityWithUniqueId(long utcTime, String uniqueId) {
        Query query = new Query(KIND_SONICEVENT);
        query.setKeysOnly();
        query.setFilter((Query.Filter)Query.CompositeFilterOperator.and((Query.Filter[])new Query.Filter[]{new Query.FilterPredicate(KEY, Query.FilterOperator.GREATER_THAN_OR_EQUAL, (Object)KeyFactory.createKey((String)KIND_SONICEVENT, (String)("" + utcTime))), new Query.FilterPredicate(KEY, Query.FilterOperator.LESS_THAN_OR_EQUAL, (Object)KeyFactory.createKey((String)KIND_SONICEVENT, (String)("" + utcTime + "\uffff"))), new Query.FilterPredicate(PROP_KEY_UNIQUEID, Query.FilterOperator.EQUAL, (Object)uniqueId)}));
        PreparedQuery eQuery = GaeUtils.toExecutableQuery(query);
        List list = eQuery.asList(FetchOptions.Builder.withLimit((int)2));
        assert (list.size() < 2);
        return list.isEmpty() ? null : (Entity)list.get(0);
    }

    public SEntity toEntity(SKey datastoreKey, ISonicEvent se) {
        return SonicEventCodec.toEntity_static(datastoreKey, se);
    }

    public static SEntity toEntity_static(SKey datastoreKey, ISonicEvent se) {
        Entity e = new Entity((Key)datastoreKey.raw());
        assert (SonicEventCodec.getWhenFromKey((Key)datastoreKey.raw()) == se.getWhen());
        SonicEventCodec.addGaeProperties((PropertyContainer)e, se);
        return GEntity.wrap((Entity)e);
    }

    public static void addGaeProperties(PropertyContainer pc, ISonicEvent se) {
        pc.setProperty(PROP_KEY_CATEGORY, (Object)se.getCategory());
        pc.setProperty(PROP_KEY_ACTION, (Object)se.getAction());
        if (se.getLabel() != null) {
            pc.setProperty(PROP_KEY_LABEL, (Object)se.getLabel());
        }
        if (se.getValue() != null) {
            pc.setUnindexedProperty(PROP_KEY_VALUE, (Object)se.getValue());
        }
        pc.setProperty(PROP_KEY_SOURCE, (Object)se.getSource());
        pc.setProperty(PROP_KEY_SUBJECT, (Object)se.getSubject());
        if (se.getUniqueId() != null) {
            pc.setProperty(PROP_KEY_UNIQUEID, (Object)se.getUniqueId());
        }
        for (Map.Entry pair : se.getExtensionData().entrySet()) {
            String key = (String)pair.getKey();
            String s = (String)pair.getValue();
            if (s == null) continue;
            pc.setUnindexedProperty(key, GaeUtils.toPropertyValue(s));
        }
    }

    public SonicEvent fromEntity(SEntity entity) {
        return SonicEventCodec.fromEntity_static(entity);
    }

    public static SonicEvent.SeBuilder fromPropertyContainer(long utcTimestamp, PropertyContainer pc) {
        SonicEvent.SeBuilder b = SonicEvent.create((long)utcTimestamp);
        for (Map.Entry prop : pc.getProperties().entrySet()) {
            String key = (String)prop.getKey();
            Object value = prop.getValue();
            if (key.equals(PROP_KEY_CATEGORY)) {
                b.category((String)value);
                continue;
            }
            if (key.equals(PROP_KEY_ACTION)) {
                b.action((String)value);
                continue;
            }
            if (key.equals(PROP_KEY_LABEL)) {
                if (value == null) continue;
                b.label((String)value);
                continue;
            }
            if (key.equals(PROP_KEY_VALUE)) {
                if (value == null) continue;
                b.value((String)value);
                continue;
            }
            if (key.equals(PROP_KEY_SOURCE)) {
                b.source((String)value);
                continue;
            }
            if (key.equals(PROP_KEY_SUBJECT)) {
                b.subject((String)value);
                continue;
            }
            if (key.equals(PROP_KEY_UNIQUEID)) {
                if (value == null) continue;
                b.uniqueId((String)value);
                continue;
            }
            if (value == null) continue;
            String s = GaeUtils.fromGaePropertyValue(value);
            b.withParam(key, s);
        }
        return b;
    }

    public static SonicEvent fromEntity_static(SEntity entity) {
        long utcTimestamp = SonicEventCodec.getWhenFromKey((Key)entity.getKey().raw());
        SonicEvent.SeBuilder b = SonicEventCodec.fromPropertyContainer(utcTimestamp, (PropertyContainer)((Entity)entity.raw()));
        SonicEvent se = (SonicEvent)b.build();
        String gaeKey = entity.getKey().getName();
        se.setKey(gaeKey);
        return se;
    }

    public Serializable toSerializable(ISonicEvent entry) {
        if (entry instanceof SonicEvent) {
            return (SonicEvent)entry;
        }
        throw new IllegalArgumentException("Could not serialise type " + entry.getClass().getCanonicalName());
    }

    public ISonicEvent fromSerializable(Serializable s) {
        if (s instanceof SonicEvent) {
            return (SonicEvent)s;
        }
        throw new IllegalArgumentException("Could not serialise type " + s.getClass().getCanonicalName());
    }

    static void addProjections(Query query, String ... propertyNames) {
        if (propertyNames == null) {
            return;
        }
        for (String propName : propertyNames) {
            query.getProjections().add(new PropertyProjection(propName, String.class));
        }
    }

    static Query createIntervalQuery_key(long start, long end, List<Query.Filter> subFilters) {
        Query query = new Query(KIND_SONICEVENT).addSort(KEY);
        if (start > 0L) {
            subFilters.add((Query.Filter)new Query.FilterPredicate(KEY, Query.FilterOperator.GREATER_THAN_OR_EQUAL, (Object)KeyFactory.createKey((String)KIND_SONICEVENT, (String)("" + start))));
        }
        if (end < Long.MAX_VALUE) {
            subFilters.add((Query.Filter)new Query.FilterPredicate(KEY, Query.FilterOperator.LESS_THAN_OR_EQUAL, (Object)KeyFactory.createKey((String)KIND_SONICEVENT, (String)("" + end + "\uffff"))));
        }
        if (subFilters.size() != 0) {
            if (subFilters.size() == 1) {
                query.setFilter(subFilters.get(0));
            } else {
                query.setFilter((Query.Filter)Query.CompositeFilterOperator.and(subFilters));
            }
        }
        return query;
    }

    static Query createKeyQuery(String key) {
        Query query = new Query(KIND_SONICEVENT).setFilter((Query.Filter)new Query.FilterPredicate(KEY, Query.FilterOperator.EQUAL, (Object)KeyFactory.createKey((String)KIND_SONICEVENT, (String)("" + key))));
        return query;
    }

    static Query createQueryFromLastKey(String lastKey, long end, List<Query.Filter> subFilters) {
        Query query = new Query(KIND_SONICEVENT).addSort(KEY);
        subFilters.add((Query.Filter)new Query.FilterPredicate(KEY, Query.FilterOperator.GREATER_THAN, (Object)KeyFactory.createKey((String)KIND_SONICEVENT, (String)("" + lastKey))));
        if (end < Long.MAX_VALUE) {
            subFilters.add((Query.Filter)new Query.FilterPredicate(KEY, Query.FilterOperator.LESS_THAN_OR_EQUAL, (Object)KeyFactory.createKey((String)KIND_SONICEVENT, (String)("" + end + "\uffff"))));
        }
        if (subFilters.size() == 1) {
            query.setFilter(subFilters.get(0));
        } else {
            query.setFilter((Query.Filter)Query.CompositeFilterOperator.and(subFilters));
        }
        return query;
    }

    public static Query toGaeQuery(ISonicQuery sq) {
        Query query = null;
        TimeConstraint tc = sq.getTimeConstraint();
        ArrayList<Query.Filter> subfilters = new ArrayList<Query.Filter>();
        for (KeyValueConstraint c : sq.getKeyValueConstraints()) {
            String dbkey = null;
            if (c.getKey().equals(ISonicPotentialEvent.FilterProperty.Action.name())) {
                dbkey = PROP_KEY_ACTION;
            } else if (c.getKey().equals(ISonicPotentialEvent.FilterProperty.Category.name())) {
                dbkey = PROP_KEY_CATEGORY;
            } else if (c.getKey().equals(ISonicPotentialEvent.FilterProperty.Label.name())) {
                dbkey = PROP_KEY_LABEL;
            } else if (c.getKey().equals(ISonicPotentialEvent.FilterProperty.Source.name())) {
                dbkey = PROP_KEY_SOURCE;
            } else if (c.getKey().equals(ISonicPotentialEvent.FilterProperty.Subject.name())) {
                dbkey = PROP_KEY_SUBJECT;
            } else if (c.getKey().equals(ISonicPotentialEvent.FilterProperty.Value.name())) {
                // empty if block
            }
            if (dbkey == null) continue;
            subfilters.add((Query.Filter)new Query.FilterPredicate(dbkey, Query.FilterOperator.EQUAL, (Object)c.getValue().toLowerCase()));
        }
        long end = tc.end;
        query = tc.lastKey != null ? SonicEventCodec.createQueryFromLastKey(tc.lastKey, end, subfilters) : SonicEventCodec.createIntervalQuery_key(tc.start, end, subfilters);
        return query;
    }

    public static ISonicEvent getEventByKey(String key) {
        Query query = SonicEventCodec.createKeyQuery(key);
        PreparedQuery eQuery = GaeUtils.toExecutableQuery(query);
        Iterator<Entity> it = eQuery.asIterable().iterator();
        return SonicEventCodec.convert(it, 2L).next();
    }

    public static Query toGaeQueryForSingleEventByKey(String key) {
        Query query = new Query(KIND_SONICEVENT).setFilter((Query.Filter)new Query.FilterPredicate(KEY, Query.FilterOperator.EQUAL, (Object)KeyFactory.createKey((String)KIND_SONICEVENT, (String)("" + key))));
        return query;
    }
}

