/*
 * Decompiled with CFR 0.152.
 */
package de.xam.files.impl.serviceloader;

import de.xam.files.type.IFileAndFolderTypeHandlerProvider;
import de.xam.files.type.IFileTypeHandler;
import de.xam.files.type.impl.DefaultFileTypeHandler;
import de.xam.files.type.impl.FileTypeImpl;
import java.util.HashMap;
import java.util.Map;

public class DefaultFileAndFolderMetaDataProvider
implements IFileAndFolderTypeHandlerProvider {
    private static Map<String, IFileTypeHandler> ext2fileTypeHandler = new HashMap<String, IFileTypeHandler>();

    @Override
    public IFileTypeHandler getFileTypeHandlerByExtension(String ext) {
        IFileTypeHandler handler = ext2fileTypeHandler.get(ext);
        if (handler == null) {
            handler = DefaultFileTypeHandler.createWithExtension(ext);
            ext2fileTypeHandler.put(ext, handler);
        }
        return handler;
    }

    static {
        ext2fileTypeHandler.put("zip", new DefaultFileTypeHandler(new FileTypeImpl("Zip Archive", null).addExtension("zip").setCanContainFiles(true)).setPrecision(0.2));
        ext2fileTypeHandler.put("rar", new DefaultFileTypeHandler(new FileTypeImpl("RAR Archive", null).addExtension("rar").setCanContainFiles(true)).setPrecision(0.2));
        ext2fileTypeHandler.put("jar", new DefaultFileTypeHandler(new FileTypeImpl("Java Archive (JAR)", null).addExtension("jar").setCanContainFiles(true)).setPrecision(0.2));
        ext2fileTypeHandler.put("war", new DefaultFileTypeHandler(new FileTypeImpl("Web Application Archive (WAR)", null).addExtension("war").setCanContainFiles(true)).setPrecision(0.2));
    }
}

