/*
 * Decompiled with CFR 0.152.
 */
package de.xam.files;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.StandardOpenOption;

public class ReadersAndWriters {
    public static final Charset UTF8 = Charset.forName("UTF-8");

    public static Writer wrapInUtf8(OutputStream out) {
        OutputStreamWriter w = new OutputStreamWriter(out, UTF8);
        return w;
    }

    public static Writer getUtf8Writer(File f) throws IOException {
        BufferedWriter writer = Files.newBufferedWriter(f.toPath(), UTF8, StandardOpenOption.SYNC, StandardOpenOption.CREATE);
        return writer;
    }

    public static Writer getUtf8Writer(File f, boolean append) throws IOException {
        if (append) {
            return Files.newBufferedWriter(f.toPath(), UTF8, StandardOpenOption.SYNC, StandardOpenOption.CREATE, StandardOpenOption.APPEND);
        }
        return ReadersAndWriters.getUtf8Writer(f);
    }

    public static Reader getUtf8Reader(File f) throws FileNotFoundException {
        FileInputStream fin = new FileInputStream(f);
        return ReadersAndWriters.wrapInUtf8(fin);
    }

    public static Reader wrapInUtf8(InputStream in) {
        InputStreamReader r = new InputStreamReader(in, UTF8);
        return r;
    }
}

