/*
 * Decompiled with CFR 0.152.
 */
package de.xam.files;

import java.io.File;
import java.io.FileFilter;

public class FileChangeWatcher
extends Thread {
    private long latestChange = 0L;
    private final File srcDir;
    private final FileFilter suffixFilter;
    private final Runnable runWhenChangesDetected;
    private boolean shouldStop = false;

    public void stopWatching() {
        this.shouldStop = true;
    }

    private static FileFilter toSuffixFileFilter(final String suffix) {
        return new FileFilter(){

            @Override
            public boolean accept(File pathname) {
                return suffix == null || pathname.toString().endsWith(suffix);
            }
        };
    }

    public FileChangeWatcher(String dirToWatch, String suffix, Runnable runWhenChangesDetected) {
        this(new File(dirToWatch), FileChangeWatcher.toSuffixFileFilter(suffix), runWhenChangesDetected);
    }

    public FileChangeWatcher(File dirToWatch, FileFilter suffixFilter, Runnable runWhenChangesDetected) {
        this.suffixFilter = suffixFilter;
        this.srcDir = dirToWatch;
        assert (this.srcDir.exists()) : "not found " + this.srcDir.getAbsolutePath();
        assert (this.srcDir.isDirectory());
        this.runWhenChangesDetected = runWhenChangesDetected;
    }

    @Override
    public void run() {
        boolean running = true;
        while (running && !this.shouldStop) {
            try {
                if (this.thingsChanged()) {
                    this.runWhenChangesDetected.run();
                }
                FileChangeWatcher.sleep(500L);
            }
            catch (InterruptedException e) {
                running = false;
            }
        }
    }

    public static FileChangeWatcher startWatching(String dirToWatch, String suffix, Runnable runWhenChangesDetected) {
        FileChangeWatcher watcher = new FileChangeWatcher(dirToWatch, suffix, runWhenChangesDetected);
        watcher.start();
        return watcher;
    }

    public static FileChangeWatcher startWatching(File dirToWatch, FileFilter suffixFilter, Runnable runWhenChangesDetected) {
        FileChangeWatcher watcher = new FileChangeWatcher(dirToWatch, suffixFilter, runWhenChangesDetected);
        watcher.start();
        return watcher;
    }

    protected boolean thingsChanged() {
        assert (this.srcDir != null);
        long maxAge = FileChangeWatcher.dirChangesSince(this.srcDir, this.suffixFilter, 0L);
        if (maxAge > this.latestChange) {
            boolean realChanges = this.latestChange > 0L;
            this.latestChange = maxAge;
            return realChanges;
        }
        return false;
    }

    public static long changesSince(File file, long since) {
        return Math.max(since, file.lastModified());
    }

    public static long dirChangesSince(File dir, String suffix, long since) {
        return FileChangeWatcher.dirChangesSince(dir, FileChangeWatcher.toSuffixFileFilter(suffix), since);
    }

    public static long dirChangesSince(File dir, FileFilter suffixFilter, long since) {
        assert (dir != null);
        long max = FileChangeWatcher.changesSince(dir, since);
        File[] files = dir.listFiles(suffixFilter);
        if (files != null) {
            for (File f : files) {
                max = FileChangeWatcher.changesSince(f, max);
            }
        }
        if ((files = dir.listFiles(new FileFilter(){

            @Override
            public boolean accept(File f) {
                return f.isDirectory();
            }
        })) != null) {
            for (File f : files) {
                max = FileChangeWatcher.dirChangesSince(f, suffixFilter, max);
            }
        }
        return max;
    }
}

