/*
 * Decompiled with CFR 0.152.
 */
package de.xam.desktop;

import de.xam.texthtml.text.EncTool;
import java.awt.Desktop;
import java.awt.HeadlessException;
import java.io.File;
import java.io.IOException;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import org.xydra.conf.IConfig;
import org.xydra.conf.impl.ConfigFiles;
import org.xydra.log.api.Logger;
import org.xydra.log.api.LoggerFactory;

public class Desktop {
    private static final Logger log = LoggerFactory.getLogger(Desktop.class);
    private static final String USER_CONF_FILE = "config.properties";
    private static final String DATA_DIR = "data";
    private static final String LOG_DIR = "logs";
    private static final String SYSTEM_PROPERTY_APP_ROOT = "app.root";
    private static ArrayList<String> macaddresses;

    public static void configureSystemProperties(String appName) {
        System.setProperty(SYSTEM_PROPERTY_APP_ROOT, Desktop.getAppRootDir(appName).getAbsolutePath());
    }

    public static void main(String[] args) {
        System.out.println(System.getProperty("os.arch"));
        System.out.println(System.getProperty("os.name"));
        System.out.println(System.getProperty("os.version"));
        System.out.println(System.getProperty("java.class.path"));
        System.out.println(System.getProperty("user.dir"));
        System.out.println(System.getProperty("user.home"));
        System.out.println(System.getProperty("user.name"));
        System.out.println("Temp: " + Desktop.getTempDir("myapp").getAbsolutePath());
        log.setLevel(Logger.Level.Trace);
        System.out.println(Desktop.getClasspathLibFolder());
    }

    public static Platform getCurrentPlatform() {
        String osName = System.getProperty("os.name");
        if (osName.contains("Mac")) {
            return Platform.Mac;
        }
        if (osName.contains("Windows")) {
            return Platform.Windows;
        }
        return Platform.LinuxUnknownOther;
    }

    public static File getWorkingDirectory() {
        File f = new File(System.getProperty("user.dir"));
        assert (f.exists());
        return f;
    }

    public static File getUserHome() {
        File f = new File(System.getProperty("user.home"));
        assert (f.exists());
        return f;
    }

    public static String getUserName() {
        return System.getProperty("user.name");
    }

    public static File getClasspathLibFolder() {
        Platform platform = Desktop.getCurrentPlatform();
        if (log.isTraceEnabled()) {
            log.trace("os.arch=" + System.getProperty("os.arch") + "  os.name=" + System.getProperty("os.name") + "  os.version=" + System.getProperty("os.version"));
        }
        log.trace("Platform identified as '" + (Object)((Object)platform) + "'");
        log.trace("Working directory (user.dir)= " + Desktop.getWorkingDirectory().getAbsolutePath());
        switch (platform) {
            case Mac: {
                File lib = new File(Desktop.getWorkingDirectory(), "/../lib");
                assert (lib.exists()) : "lib folder does not exist: " + lib.getAbsolutePath();
                return lib;
            }
        }
        throw new AssertionError((Object)"not yet implemented");
    }

    public static void openUrlInDefaultBrowser(String url) throws IOException, URISyntaxException {
        java.awt.Desktop javaDesktop = java.awt.Desktop.getDesktop();
        boolean canLaunchBrowser = javaDesktop.isSupported(Desktop.Action.BROWSE);
        if (canLaunchBrowser) {
            try {
                javaDesktop.browse(new URI(url));
            }
            catch (HeadlessException e) {
                log.warn("The JVM said we can open a browser, but we failed", (Throwable)e);
                canLaunchBrowser = false;
            }
        }
        if (!canLaunchBrowser) {
            System.out.println("Cannot open default browser on this platform.\nMost likely we are on Linux here and you know better than I do how to open this URL:\n    " + url);
        }
    }

    public static File writeUserConf(String appName, IConfig conf) throws IOException {
        File userConfFile = Desktop.getUserConfigFile(appName);
        ConfigFiles.write((IConfig)conf, (File)userConfFile);
        return userConfFile;
    }

    public static File getAppRootDir(String appName) {
        assert (!appName.contains(" "));
        assert (!appName.contains("\n"));
        File f = new File(Desktop.getUserHome(), "." + appName);
        f.mkdirs();
        return f;
    }

    public static File getLogDir(String appName) {
        return Desktop.getAppDir(appName, LOG_DIR);
    }

    public static File getDataDir(String appName) {
        return Desktop.getAppDir(appName, DATA_DIR);
    }

    public static File getAppDir(String appName, String dirName) {
        File f = new File(Desktop.getAppRootDir(appName), dirName);
        f.mkdirs();
        return f;
    }

    public static File readUserConf(String appName, IConfig conf) throws IOException {
        File userConfFile = Desktop.getUserConfigFile(appName);
        if (!userConfFile.exists()) {
            log.warn("No user config file found at " + userConfFile.getAbsolutePath());
            return null;
        }
        ConfigFiles.read((File)userConfFile, (IConfig)conf);
        return userConfFile;
    }

    private static File getUserConfigFile(String appName) {
        return new File(Desktop.getAppRootDir(appName), USER_CONF_FILE);
    }

    public static void clearUserConf(String appName) {
        File f = Desktop.getUserConfigFile(appName);
        if (f.exists()) {
            File backupFile = new File(f.getAbsolutePath() + ".backup");
            if (backupFile.exists()) {
                // empty if block
            }
            f.renameTo(backupFile);
            log.info("Deleted user config file. Backup is at " + backupFile.getAbsolutePath());
        }
    }

    public static void deleteUserConf(String appname) {
        File f = Desktop.getUserConfigFile(appname);
        if (f.exists()) {
            f.delete();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void exit(final int status, long maxDelayMillis) {
        try {
            Timer timer = new Timer();
            timer.schedule(new TimerTask(){

                @Override
                public void run() {
                    Runtime.getRuntime().halt(status);
                }
            }, maxDelayMillis);
            System.exit(status);
        }
        catch (Throwable ex) {
            Runtime.getRuntime().halt(status);
        }
        finally {
            Runtime.getRuntime().halt(status);
        }
    }

    public static File getTempDir(String appname) {
        String tempDirPath = System.getProperty("java.io.tmpdir");
        File osTempDir = new File(tempDirPath);
        File appTempDir = new File(osTempDir, appname);
        appTempDir.mkdirs();
        return appTempDir;
    }

    public static synchronized List<String> getLocalMacAddresses() {
        if (macaddresses == null) {
            macaddresses = new ArrayList();
            try {
                Enumeration<NetworkInterface> en = NetworkInterface.getNetworkInterfaces();
                while (en.hasMoreElements()) {
                    NetworkInterface networkInterface = en.nextElement();
                    byte[] macBytes = networkInterface.getHardwareAddress();
                    if (macBytes == null) continue;
                    String hex = EncTool.bytesToHex((byte[])macBytes);
                    macaddresses.add(hex);
                }
            }
            catch (SocketException e) {
                log.warn("Problem", (Throwable)e);
            }
        }
        return macaddresses;
    }

    static enum Platform {
        Mac,
        Windows,
        LinuxUnknownOther;

    }
}

