/*
 * Decompiled with CFR 0.152.
 */
package de.xam.dwzmodel.state;

import com.calpano.kgif.io.FileFormat;
import com.calpano.kgif.io.common.IStreamSink;
import com.calpano.kgif.io.common.IStreamSource;
import com.calpano.kgif.io.common.impl.InputStreamSource;
import com.google.web.bindery.event.shared.EventBus;
import de.xam.cmodel.service.ServiceState;
import de.xam.desktop.Desktop;
import de.xam.dwzmodel.api.FileUpload;
import de.xam.dwzmodel.io.ImportResult;
import de.xam.dwzmodel.io.export_to_x.ExportManager;
import de.xam.dwzmodel.io.import_kgif_110.Kgif1_1_0Manager;
import de.xam.dwzmodel.state.CacheManager;
import de.xam.dwzmodel.state.DirStore;
import de.xam.dwzmodel.state.FileManager;
import de.xam.dwzmodel.state.FileMeta;
import de.xam.dwzmodel.state.FileVersion;
import de.xam.dwzmodel.state.HistoryManager;
import de.xam.dwzmodel.state.KgifContentTypes;
import de.xam.dwzmodel.state.KnowledgeModelState;
import de.xam.dwzmodel.state.ModuleManager;
import de.xam.dwzmodel.state.ProjectProperties;
import de.xam.dwzmodel.state.StateManager_Load;
import de.xam.files.FileTools;
import de.xam.itemset.index.IItemSetManagedIndex;
import de.xam.itemset.index.IndexManager;
import de.xam.itemset.index.IndexState;
import de.xam.kfacet.impl.wiki.WikiTextIndex;
import de.xam.mybase.model.IoProgressReporter;
import de.xam.mybase.model.MyBases;
import de.xam.mybase.model.api.IMyBase;
import de.xam.mybase.model.api.MyBaseComponent;
import de.xam.mybase.model.api.MyBaseImpl;
import de.xam.resourceloader.ResourceLoaderTool;
import de.xam.texthtml.text.EncTool;
import de.xam.textsearch.text.TextIndex;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import org.xydra.conf.IConfig;
import org.xydra.conf.annotations.RequireConf;
import org.xydra.conf.annotations.RequireConfInstance;
import org.xydra.core.model.XChangeLog;
import org.xydra.core.model.XModel;
import org.xydra.env.Env;
import org.xydra.index.iterator.ITransformer;
import org.xydra.index.iterator.Iterators;
import org.xydra.log.api.Logger;
import org.xydra.log.api.LoggerFactory;

public class StateManager {
    private static final Logger log = LoggerFactory.getLogger(StateManager.class);
    public static final String PREFIX_UNNAMED = "Unnamed-";
    private KnowledgeModelState activeKnowledgeModelState;
    private final File publicDirRoot;
    private final File shadowDirRoot;
    private ServiceState serviceState = ServiceState.running;

    public static IMyBase createMyBase(IoProgressReporter iop) {
        log.info("Creating event bus");
        IConfig conf = Env.get().conf();
        EventBus eventBus = (EventBus)conf.getResolver(EventBus.class).resolve();
        iop.getClock().stopAndStart("stateManager-eventbus");
        MyBaseImpl myBase = new MyBaseImpl(eventBus, iop);
        iop.getClock().stopAndStart("stateManager-myBase");
        return myBase;
    }

    private static FileMeta getFileMeta(DirStore dirStore, ProjectProperties projectProperties) {
        long lastModified;
        long rev = projectProperties == null ? -20L : projectProperties.getStoredRevision();
        long created = -1L;
        try {
            created = FileTools.creationDateMin((File)dirStore.getPublicLocalDir(), (FileFilter)FileTools.ALL_FILES_AND_DIRS_FILTER).getAge();
        }
        catch (IOException e) {
            // empty catch block
        }
        if (created == 0L) {
            created = -1L;
        }
        if ((lastModified = FileTools.lastModifiedMax((File)dirStore.getPublicLocalDir(), (FileFilter)FileTools.ALL_FILES_AND_DIRS_FILTER).getAge()) == 0L) {
            lastModified = -1L;
        }
        long size = dirStore.getSize();
        String metaStr = dirStore.getMetaString();
        String filenameNotEncoded = dirStore.getFileName();
        FileMeta fileMeta = new FileMeta(filenameNotEncoded, lastModified, created, size, metaStr, rev);
        return fileMeta;
    }

    private static String getNewUnnamedName(StateManager stateManager, IoProgressReporter iop) {
        String unnamedName;
        List<String> names = stateManager.getUsedLocalNames();
        int i = 1;
        do {
            unnamedName = PREFIX_UNNAMED + i;
            ++i;
        } while (names.contains(unnamedName));
        return unnamedName;
    }

    private static InputStream openBuiltinLocalResource(String localName) {
        String resourceName = "builtins/" + localName;
        InputStream in = ResourceLoaderTool.inputStreamFromClassLoader((String)resourceName);
        return in;
    }

    private static void writeActiveFileToConf(String localName) {
        IConfig conf = Env.get().conf();
        conf.set("files-activeName", (Object)localName);
        try {
            String appName = conf.getString("appName");
            Desktop.writeUserConf((String)appName, (IConfig)conf);
        }
        catch (IOException e) {
            throw new RuntimeException("Error", e);
        }
    }

    @RequireConf(value={"knowledgeFileRootDir"})
    public StateManager() {
        IConfig conf = Env.get().conf();
        String publicDirName = conf.getString("knowledgeFileRootDir");
        this.publicDirRoot = new File(publicDirName);
        assert (this.publicDirRoot != null) : "Config contains no directory for knowledge files";
        String appName = conf.getString("appName");
        this.shadowDirRoot = Desktop.getDataDir((String)appName);
        assert (this.shadowDirRoot != null);
        assert (this.publicDirRoot != null) : "Config contains no directory for knowledge file cache files";
        log.info("Using " + this.publicDirRoot.getAbsolutePath() + " as storage directory");
        this.publicDirRoot.getParentFile().mkdirs();
        this.shadowDirRoot.getParentFile().mkdirs();
    }

    private void closeActiveStore() {
        this.activeKnowledgeModelState.close();
        this.activeKnowledgeModelState = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void doBoot(IoProgressReporter iop) throws IOException {
        block8: {
            ModuleManager.get().locks(MyBaseComponent.MyBase).writeLock().lock();
            try {
                assert (ModuleManager.get().getMyBase() == null) : "we are not booting, but found an existing myBase - wrong state";
                assert (!this.isKnowledgeFileOpen()) : "during boot no file should be open";
                this.step_000_CreateAndSetMyBase(iop);
                iop.getClock().stopAndStart("statemanager-createAndSetMyBase");
                IMyBase myBase = ModuleManager.get().getMyBase();
                assert (myBase != null) : "mybase should have been created by now";
                IConfig conf = Env.get().conf();
                String lastOpenedlocalName = (String)conf.tryToGetAs("files-activeName", String.class);
                if (lastOpenedlocalName == null) {
                    this.step_100_StartUnnamed(myBase, iop);
                    break block8;
                }
                iop.reportProgress("Opening last used file '" + lastOpenedlocalName + "'");
                try {
                    this.step_100_Open(myBase, lastOpenedlocalName, iop);
                }
                catch (Exception e) {
                    iop.reportException((Throwable)e);
                }
            }
            catch (Throwable throwable) {
                ModuleManager.get().locks(MyBaseComponent.MyBase).writeLock().unlock();
                throw throwable;
            }
        }
        ModuleManager.get().locks(MyBaseComponent.MyBase).writeLock().unlock();
    }

    void doCancel(IoProgressReporter iop) {
        assert (this.serviceState.isRunning() || this.serviceState.isStarting());
        this.serviceState = this.serviceState.goTo(ServiceState.stopping);
    }

    void doClose(IMyBase myBase, IoProgressReporter iop) throws IOException {
        assert (myBase != null);
        assert (this.isKnowledgeFileOpen());
        this.step_500_Close(myBase, iop);
        assert (!this.isKnowledgeFileOpen());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    FileManager.CopyResult doCopyTo(long targetRev, String targetFilename, FileFormat fileFormat, IoProgressReporter iop) throws IOException {
        FileManager.CopyResult copyResult;
        iop.reportProgress("Copying " + this.getActiveFileName() + " to " + targetFilename + " ...");
        IMyBase myBase = ModuleManager.get().getMyBase();
        assert (myBase != null);
        assert (this.isKnowledgeFileOpen());
        ModuleManager.get().locks(MyBaseComponent.ItemSet).readLock().lock();
        try {
            String baseName;
            log.info("Creating a new knowledge file name");
            long copyRev = targetRev;
            if (copyRev == -30L) {
                copyRev = myBase.getXModel().getRevisionNumber();
            }
            String targetName = baseName = targetFilename;
            int i = 1;
            DirStore dirStore = null;
            while (dirStore == null) {
                try {
                    dirStore = DirStore.open(this.publicDirRoot, this.shadowDirRoot, targetName, iop, true, true, true);
                }
                catch (IllegalStateException e) {
                    targetName = baseName + "--" + ++i;
                }
            }
            iop.reportProgress("Starting new file '" + targetName + "'");
            ProjectProperties pp = ProjectProperties.create(copyRev, copyRev);
            CacheManager cm = CacheManager.create();
            HistoryManager.write(dirStore, pp, myBase, cm, copyRev);
            iop.reportProgressSuccess("Copied");
            copyResult = new FileManager.CopyResult(targetName, copyRev);
        }
        catch (Exception e) {
            FileManager.CopyResult copyResult2;
            try {
                copyResult2 = null;
            }
            catch (Throwable throwable) {
                ModuleManager.get().locks(MyBaseComponent.ItemSet).readLock().unlock();
                throw throwable;
            }
            ModuleManager.get().locks(MyBaseComponent.ItemSet).readLock().unlock();
            return copyResult2;
        }
        ModuleManager.get().locks(MyBaseComponent.ItemSet).readLock().unlock();
        return copyResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void doCreateNew(IoProgressReporter iop) throws IOException {
        IMyBase myBase;
        block5: {
            ModuleManager.get().locks(MyBaseComponent.MyBase).writeLock().lock();
            try {
                myBase = ModuleManager.get().getMyBase();
                assert (myBase != null);
                if (this.isKnowledgeFileOpen()) {
                    this.step_500_Close(myBase, iop);
                }
                if (!iop.isFaillure()) break block5;
            }
            catch (Throwable throwable) {
                ModuleManager.get().locks(MyBaseComponent.MyBase).writeLock().unlock();
                throw throwable;
            }
            ModuleManager.get().locks(MyBaseComponent.MyBase).writeLock().unlock();
            return;
        }
        this.step_100_StartUnnamed(myBase, iop);
        ModuleManager.get().locks(MyBaseComponent.MyBase).writeLock().unlock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void doExportTo(IStreamSink sink, FileFormat ff, IoProgressReporter iop) throws IOException {
        assert (this.isKnowledgeFileOpen());
        IMyBase myBase = ModuleManager.get().getMyBase();
        assert (myBase != null);
        ModuleManager.get().locks(MyBaseComponent.ItemSet).readLock().lock();
        try {
            ExportManager.doExportToStream(myBase, sink, ff, iop);
        }
        catch (Throwable throwable) {
            ModuleManager.get().locks(MyBaseComponent.ItemSet).readLock().unlock();
            throw throwable;
        }
        ModuleManager.get().locks(MyBaseComponent.ItemSet).readLock().unlock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void doImportBuiltin(String localName, IoProgressReporter iop) throws IOException {
        InputStream in;
        block7: {
            assert (ModuleManager.get().getMyBase() != null);
            assert (localName != null);
            ModuleManager.get().locks(MyBaseComponent.MyBase).writeLock().lock();
            in = StateManager.openBuiltinLocalResource(localName);
            if (in != null) break block7;
            iop.reportProgressFailed("Built-in resource not found '" + localName + "'");
            ModuleManager.get().locks(MyBaseComponent.MyBase).writeLock().unlock();
            return;
        }
        try {
            InputStreamSource inputStreamSource = new InputStreamSource(localName, in);
            IMyBase myBase = ModuleManager.get().getMyBase();
            ImportResult importResult = Kgif1_1_0Manager.readValidSortedKgif1_1_0fromSourceIntoMyBase((IStreamSource)inputStreamSource, myBase, iop);
            inputStreamSource.close();
            iop.reportProgress("Done importing built-in resource '" + localName + "'");
            iop.reportProgressDone(importResult.success);
        }
        catch (Exception e) {
            try {
                iop.reportException((Throwable)e);
            }
            catch (Throwable throwable) {
                ModuleManager.get().locks(MyBaseComponent.MyBase).writeLock().unlock();
                throw throwable;
            }
            ModuleManager.get().locks(MyBaseComponent.MyBase).writeLock().unlock();
        }
        ModuleManager.get().locks(MyBaseComponent.MyBase).writeLock().unlock();
    }

    /*
     * Exception decompiling
     */
    void doImportUpload(FileUpload upload, IoProgressReporter iop) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean doOpen(String localName, IoProgressReporter iop) throws IOException {
        IMyBase myBase = ModuleManager.get().getMyBase();
        assert (myBase != null);
        assert (localName != null);
        ModuleManager.get().locks(MyBaseComponent.MyBase).writeLock().lock();
        if (this.isKnowledgeFileOpen()) {
            this.step_500_Close(myBase, iop);
        }
        try {
            this.step_100_Open(myBase, localName, iop);
            StateManager.writeActiveFileToConf(localName);
        }
        catch (Throwable t) {
            try {
                log.warn("Encountered problem", t);
                iop.reportException(t);
            }
            catch (Throwable throwable) {
                ModuleManager.get().locks(MyBaseComponent.MyBase).writeLock().unlock();
                throw throwable;
            }
            ModuleManager.get().locks(MyBaseComponent.MyBase).writeLock().unlock();
        }
        ModuleManager.get().locks(MyBaseComponent.MyBase).writeLock().unlock();
        return iop.isSuccess();
    }

    public String getActiveFileName() {
        if (this.activeKnowledgeModelState == null) {
            return null;
        }
        return this.activeKnowledgeModelState.dirStore().getFileName();
    }

    List<FileMeta> getLocalFileMetas(IoProgressReporter iop) throws IOException {
        ArrayList<FileMeta> fileMetas = new ArrayList<FileMeta>();
        for (String name : this.getUsedLocalNames()) {
            DirStore dirStore = DirStore.open(this.publicDirRoot, this.shadowDirRoot, name, iop, false, false, false);
            if (dirStore == null) {
                iop.reportProgress("Could not read metadata of '" + name + "'");
                continue;
            }
            ProjectProperties projectProperties = dirStore.readProjectProperties();
            FileMeta fileMeta = StateManager.getFileMeta(dirStore, projectProperties);
            fileMetas.add(fileMeta);
        }
        Collections.sort(fileMetas, new Comparator<FileMeta>(){

            @Override
            public int compare(FileMeta a, FileMeta b) {
                if (a.getFilename().startsWith(StateManager.PREFIX_UNNAMED) && b.getFilename().startsWith(StateManager.PREFIX_UNNAMED)) {
                    try {
                        String aNum = a.getFilename().substring(StateManager.PREFIX_UNNAMED.length());
                        String bNum = b.getFilename().substring(StateManager.PREFIX_UNNAMED.length());
                        int aInt = Integer.parseInt(aNum);
                        int bInt = Integer.parseInt(bNum);
                        return -1 * (bInt - aInt);
                    }
                    catch (Throwable t) {
                        log.warn("Could not compare Unnamed files " + a.getFilename() + " and " + b.getFilename(), t);
                    }
                }
                return a.compareTo(b);
            }
        });
        return fileMetas;
    }

    List<FileVersion> getLocalFileVersions(long maxGapBetweenVersions, int maxEventsPerVersion, IoProgressReporter iop) throws IOException {
        IMyBase myBase = ModuleManager.get().getMyBase();
        XModel xmodel = myBase.getXModel();
        XChangeLog changeLog = xmodel.getChangeLog();
        List<FileVersion> fileVersions = HistoryManager.getFileVersions(changeLog, myBase, 0L, Long.MAX_VALUE, maxGapBetweenVersions, maxEventsPerVersion);
        Collections.reverse(fileVersions);
        return fileVersions;
    }

    public File getPublicDir() {
        return this.publicDirRoot;
    }

    public List<String> getUsedLocalNames() {
        File[] files = this.publicDirRoot.listFiles(FileTools.NO_FILES_ALL_DIRS_FILTER);
        ArrayList<String> knames = new ArrayList<String>();
        if (files != null) {
            Iterators.addAll((Iterator)Iterators.transform(Arrays.asList(files).iterator(), (ITransformer)new ITransformer<File, String>(){

                public String transform(File f) {
                    String filename = f.getName();
                    String name = EncTool.unescapeFilename((String)filename);
                    return name;
                }
            }), knames);
        }
        return knames;
    }

    private boolean isKnowledgeFileOpen() {
        return this.activeKnowledgeModelState != null;
    }

    @RequireConfInstance(value={EventBus.class})
    private void step_000_CreateAndSetMyBase(IoProgressReporter iop) {
        assert (ModuleManager.get().getMyBase() == null);
        assert (!this.isKnowledgeFileOpen());
        assert (iop != null);
        iop.reportProgress("Preparing knowledge model");
        IMyBase myBase = StateManager.createMyBase(iop);
        iop.getClock().stopAndStart("stateManager-mybase");
        TextIndex bucketWikiText = myBase.searchEngine().getOrCreateBucket("wikiText");
        WikiTextIndex wikiTextIndex = new WikiTextIndex(myBase.indexManager(), bucketWikiText);
        iop.getClock().stopAndStart("stateManager-wikiTextIndex");
        KgifContentTypes.registerContentTypes();
        iop.getClock().stopAndStart("stateManager-kgifContentTypes");
        ModuleManager.get().setMyBase(myBase);
        iop.getClock().stopAndStart("stateManager-step000-done");
        myBase.indexManager().assertIndexesAre_computed_updating(null, Boolean.valueOf(false));
        IndexState nameIndexState = myBase.indexManager().getIndexState((IItemSetManagedIndex)myBase.nameIndex());
        myBase.indexManager().setUpdating((IItemSetManagedIndex)myBase.nameIndex(), true);
        nameIndexState.ensureIsComputed((IndexManager.IIndexProgress)iop);
        assert (myBase.itemSet().isEmpty());
        assert (myBase.infModel().isEmpty());
    }

    private void step_100_Open(IMyBase myBase, String localName, IoProgressReporter iop) throws IOException {
        assert (!this.isKnowledgeFileOpen());
        DirStore dirStore = DirStore.open(this.publicDirRoot, this.shadowDirRoot, localName, iop, true, false, false);
        if (dirStore == null) {
            iop.reportProgressFailed("Could not open '" + localName + "'");
            return;
        }
        this.step_200_LoadState(dirStore, myBase, iop);
        assert (this.activeKnowledgeModelState != null);
    }

    private void step_100_StartUnnamed(IMyBase myBase, IoProgressReporter iop) throws IOException {
        KnowledgeModelState kms;
        assert (myBase != null);
        assert (myBase.itemSet().isEmpty());
        assert (myBase.infModel().isEmpty()) : "infModel=" + myBase.infModel().dump();
        assert (!this.isKnowledgeFileOpen());
        log.info("Creating a new knowledge file name");
        String unnamedName = StateManager.getNewUnnamedName(this, iop);
        DirStore dirStore = null;
        while (dirStore == null) {
            dirStore = DirStore.open(this.publicDirRoot, this.shadowDirRoot, unnamedName, iop, true, true, false);
            if (dirStore != null) continue;
            log.warn("An unlikely race condition happened. Name: '" + unnamedName + "'");
        }
        iop.reportProgress("Starting new file '" + unnamedName + "'");
        ProjectProperties projectProperties = ProjectProperties.create(0L, 0L);
        CacheManager cacheManager = CacheManager.create();
        HistoryManager historyManager = HistoryManager.open(dirStore, projectProperties, cacheManager, myBase, iop, false);
        log.info("Adding built-ins");
        assert (ModuleManager.get().getMyBase() != null);
        MyBases.addBuiltins((IMyBase)myBase, (IoProgressReporter)iop);
        assert (!myBase.itemSet().isEmpty());
        historyManager.startRecordingChangesOn(dirStore, myBase.getXModel(), iop);
        this.activeKnowledgeModelState = kms = new KnowledgeModelState(dirStore, projectProperties, historyManager);
        assert (this.isKnowledgeFileOpen());
        cacheManager.finishCaches(dirStore, myBase, iop);
        HistoryManager.write(dirStore, projectProperties, myBase, cacheManager, -30L);
        StateManager.writeActiveFileToConf(unnamedName);
        assert (!myBase.itemSet().isEmpty());
    }

    private void step_200_LoadState(DirStore dirStore, IMyBase myBase, IoProgressReporter iop) throws IOException {
        assert (myBase != null);
        assert (myBase.eventBus() != null);
        KnowledgeModelState kms = StateManager_Load.doLoadState(dirStore, myBase, iop);
        assert (kms != null);
        assert (kms.dirStore().exists());
        assert (kms.projectProperties().getStoredRevision() != -1L);
        this.activeKnowledgeModelState = kms;
    }

    private void step_500_Close(IMyBase myBase, IoProgressReporter iop) {
        assert (myBase != null);
        assert (this.isKnowledgeFileOpen());
        iop.reportProgress("Stopping current Knowledge File ...");
        myBase.indexManager().setUpdating(false);
        this.closeActiveStore();
        iop.reportProgress("Clear");
        myBase.clear();
        myBase.indexManager().assertIndexesAre_computed_updating(null, Boolean.valueOf(false));
        assert (!this.isKnowledgeFileOpen());
    }
}

