/*
 * Decompiled with CFR 0.152.
 */
package de.xam.dwzmodel.state;

import com.google.common.collect.Sets;
import de.xam.datafiles.util.JavaProperties;
import de.xam.dwzmodel.io.util.PropertiesUtils;
import de.xam.files.FileTools;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Properties;
import java.util.Set;
import org.xydra.base.change.impl.memory.RevisionConstants;
import org.xydra.index.iterator.IFilter;
import org.xydra.index.iterator.ITransformer;
import org.xydra.index.iterator.Iterators;

public class ProjectProperties {
    private static final String NUMBER_OF_STEPS = "numberOfSteps";
    public static final String PROCESS = "process";
    public static final String PROCESS_IMPORT = "import";
    public static final Set<String> PROCESS_DEPRECATED = Sets.newHashSet((Object[])new String[]{"ImportToKgif", "TransformKgif", "SortKgif", "ValidateKgif"});
    private static final String PROPERTY_KEY__HISTORY_MAX_REV = "historyMaxRev";
    private static final String PROPERTY_KEY__STORED_REV = "storedRev";
    public static final String REVISION = "revision";
    public static final String SOURCE_FILE_FORMAT_NAME = "sourceFileFormatName";
    public static final String SOURCE_FILENAME = "sourceFilename";
    public static final String SOURCE_KGIF_VERSION = "sourceKgifVersion";
    public static final String SOURCE_LAST_MODIFIED = "sourceLastModified";
    private static final String PREFIX_STEP = "step";
    public static final String TARGET_FILENAME = "targetFilename";
    public static final String TARGET_KGIF_VERSION = "targetKgifVersion";
    public static final String TARGET_LAST_MODIFIED = "targetLastModified";
    private int numberOfSteps = 0;
    private final Properties props;

    public static ProjectProperties create(long storedRev, long historyMax) throws IOException {
        Properties props = new Properties();
        ProjectProperties pp = new ProjectProperties(props);
        pp.setHistoryMaxRevisionTo(historyMax);
        pp.setStoredRevisionTo(storedRev);
        return pp;
    }

    public static ProjectProperties readFrom(File file) throws IOException {
        if (file.exists()) {
            Properties props = FileTools.readPropertiesFromUtf8File((File)file);
            if (props == null) {
                return null;
            }
            return new ProjectProperties(props);
        }
        return null;
    }

    private static String stepKey(int stepNo) {
        return "step." + stepNo;
    }

    private ProjectProperties(Properties props) {
        this.props = props;
        this.numberOfSteps = this.getNumberOfSteps();
    }

    public int getNumberOfSteps() {
        return PropertiesUtils.getPropertyAsInt(this.props, NUMBER_OF_STEPS, 0);
    }

    public Step createStep(int stepNo) {
        Step step = this.getStep(stepNo);
        if (step != null) {
            throw new IllegalStateException("Step " + stepNo + " exists already");
        }
        this.props.setProperty(ProjectProperties.stepKey(stepNo), "");
        ++this.numberOfSteps;
        this.props.setProperty(NUMBER_OF_STEPS, "" + this.numberOfSteps);
        return this.getStep(stepNo);
    }

    public long getHistoryMaxRevision() {
        long defaultHistoryRev = 0L;
        return PropertiesUtils.getPropertyAsLong(this.props, PROPERTY_KEY__HISTORY_MAX_REV, 0L);
    }

    public String getProp(String key) {
        return this.props.getProperty(key);
    }

    public Step getStep(int stepNo) {
        if (this.props.containsKey(ProjectProperties.stepKey(stepNo))) {
            return new Step(stepNo);
        }
        return null;
    }

    public long getStoredRevision() {
        long defaultCurrentRev = -30L;
        return PropertiesUtils.getPropertyAsLong(this.props, PROPERTY_KEY__STORED_REV, -30L);
    }

    public void setHistoryMaxRevisionTo(long rev) {
        if (rev == -21L) {
            return;
        }
        this.setProp(PROPERTY_KEY__HISTORY_MAX_REV, "" + rev);
    }

    public void setProp(String key, String value) {
        this.props.setProperty(key, value);
    }

    public void setStoredRevisionTo(long rev) {
        if (rev == -21L) {
            return;
        }
        if (rev != -30L && rev < 0L) {
            throw new IllegalArgumentException("Revision number illegal " + rev + " (='" + RevisionConstants.getName((long)rev) + "')");
        }
        if (rev != -30L && rev > this.getHistoryMaxRevision()) {
            throw new IllegalArgumentException("Revision number larger than possible (" + this.getHistoryMaxRevision() + "): " + rev);
        }
        this.setProp(PROPERTY_KEY__STORED_REV, "" + rev);
    }

    public void deleteAllSteps() {
        HashSet<String> toDelete = new HashSet<String>();
        for (Object keyO : this.props.keySet()) {
            String key = (String)keyO;
            if (!key.startsWith("step.")) continue;
            toDelete.add(key);
        }
        for (String key : toDelete) {
            this.props.remove(key);
        }
        this.props.remove(NUMBER_OF_STEPS);
    }

    public void writeTo(File f) throws IOException {
        f.getParentFile().mkdirs();
        try (FileOutputStream fos = new FileOutputStream(f);){
            JavaProperties.storePropertiesSorted((String)"sorted", (Properties)this.props, (OutputStream)fos);
        }
    }

    public class Step {
        int stepNo;

        public Step(int stepNo) {
            this.stepNo = stepNo;
        }

        public String getProp(String subKey) {
            return ProjectProperties.this.props.getProperty(ProjectProperties.stepKey(this.stepNo) + "." + subKey);
        }

        public long getRevision() {
            return PropertiesUtils.getPropertyAsLong(ProjectProperties.this.props, ProjectProperties.REVISION, -20L);
        }

        public String getSourceFileFormatName() {
            return this.getProp(ProjectProperties.SOURCE_FILE_FORMAT_NAME);
        }

        public long getSourceFileLastModified() {
            return PropertiesUtils.getPropertyAsLong(ProjectProperties.this.props, ProjectProperties.SOURCE_LAST_MODIFIED, Long.MAX_VALUE);
        }

        public void setSourceFileLastModified(long utc) {
            this.setProp(ProjectProperties.SOURCE_LAST_MODIFIED, "" + utc);
        }

        public String getSourceFilename() {
            return this.getProp(ProjectProperties.SOURCE_FILENAME);
        }

        public int getStepNumber() {
            return this.stepNo;
        }

        public long getTargetFileLastModified() {
            return PropertiesUtils.getPropertyAsLong(ProjectProperties.this.props, ProjectProperties.TARGET_LAST_MODIFIED, Long.MAX_VALUE);
        }

        public String getTargetFilename() {
            return this.getProp(ProjectProperties.TARGET_FILENAME);
        }

        public void setProp(String subKey, String value) {
            assert (ProjectProperties.this.props != null);
            ProjectProperties.this.props.setProperty(ProjectProperties.stepKey(this.stepNo) + "." + subKey, value);
        }

        public void setRevision(long revision) {
            this.setProp(ProjectProperties.REVISION, "" + revision);
        }

        public void setSourceFileFormatName(String sourceFormatName) {
            this.setProp(ProjectProperties.SOURCE_FILE_FORMAT_NAME, sourceFormatName);
        }

        public void setSourceFilename(String sourceFilename) {
            this.setProp(ProjectProperties.SOURCE_FILENAME, sourceFilename);
        }

        public void setTargetFilename(String TargetFilename) {
            this.setProp(ProjectProperties.TARGET_FILENAME, TargetFilename);
        }

        public String getProcess() {
            return this.getProp(ProjectProperties.PROCESS);
        }

        public void setProcess(String process) {
            this.setProp(ProjectProperties.PROCESS, process);
        }

        public void copyAllSubKeyValuesFrom(Step sourceStep) {
            Iterator<String> it = sourceStep.getKeyAsIterator();
            while (it.hasNext()) {
                String sourceKey = it.next();
                String sourceValue = sourceStep.getProp(sourceKey);
                this.setProp(sourceKey, sourceValue);
            }
        }

        private Iterator<String> getKeyAsIterator() {
            final String keyPrefix = ProjectProperties.stepKey(this.stepNo);
            return Iterators.filter((Iterator)Iterators.transform(ProjectProperties.this.props.keySet().iterator(), (ITransformer)new ITransformer<Object, String>(){

                public String transform(Object in) {
                    return ((String)in).substring(keyPrefix.length());
                }
            }), (IFilter)new IFilter<String>(){

                public boolean matches(String entry) {
                    return entry.startsWith(keyPrefix);
                }
            });
        }
    }
}

