/*
 * Decompiled with CFR 0.152.
 */
package de.xam.dwzmodel.state;

import de.xam.cmodel.fact.VocabularyCModel;
import de.xam.dwzmodel.io.persistence.FstIO;
import de.xam.dwzmodel.io.persistence.NextFiles;
import de.xam.dwzmodel.io.util.DesktopIO;
import de.xam.dwzmodel.io.util.XydraHacks;
import de.xam.dwzmodel.state.CacheManager;
import de.xam.dwzmodel.state.DirStore;
import de.xam.dwzmodel.state.FileVersion;
import de.xam.dwzmodel.state.ProjectProperties;
import de.xam.mybase.model.IoProgressReporter;
import de.xam.mybase.model.api.IMyBase;
import de.xam.p13n.shared.time.TimeProvider;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.xydra.base.XAddress;
import org.xydra.base.change.ChangeType;
import org.xydra.base.change.XAtomicEvent;
import org.xydra.base.change.XCommand;
import org.xydra.base.change.XCommandUtils;
import org.xydra.base.change.XEvent;
import org.xydra.base.change.XFieldEvent;
import org.xydra.base.change.XModelEvent;
import org.xydra.base.change.XObjectEvent;
import org.xydra.base.change.XTransactionEvent;
import org.xydra.base.rmof.XRevWritableModel;
import org.xydra.base.rmof.impl.XExistsReadableModel;
import org.xydra.base.rmof.impl.XExistsRevWritableModel;
import org.xydra.base.rmof.impl.memory.SimpleModel;
import org.xydra.base.value.XLongValue;
import org.xydra.base.value.XValue;
import org.xydra.core.change.EventUtils;
import org.xydra.core.change.XChanges;
import org.xydra.core.change.XFieldEventListener;
import org.xydra.core.change.XModelEventListener;
import org.xydra.core.change.XObjectEventListener;
import org.xydra.core.change.XTransactionEventListener;
import org.xydra.core.model.XChangeLog;
import org.xydra.core.model.XModel;
import org.xydra.core.model.impl.memory.sync.ISyncLogEntry;
import org.xydra.core.model.impl.memory.sync.MemorySyncLogState;
import org.xydra.core.model.impl.memory.sync.XSyncLogState;
import org.xydra.log.api.Logger;
import org.xydra.log.api.LoggerFactory;

public class HistoryManager {
    private static final Logger log = LoggerFactory.getLogger(HistoryManager.class);
    private XSyncLogState autosavedSyncLogState = null;
    private long currentRev;
    private DirStore duringEvents_dirStore;
    private XModel duringEvents_xmodel;
    private final XFieldEventListener fieldEventListener = new XFieldEventListener(){

        public void onChangeEvent(XFieldEvent event) {
            if (event.inTransaction()) {
                return;
            }
            HistoryManager.this.onEvent((XEvent)event);
        }
    };
    private long latestAutosaveWrittenTimestampUTC;
    private final XModelEventListener modelEventListener = new XModelEventListener(){

        public void onChangeEvent(XModelEvent event) {
            if (event.inTransaction()) {
                return;
            }
            HistoryManager.this.onEvent((XEvent)event);
        }
    };
    private final XObjectEventListener objectEventListener = new XObjectEventListener(){

        public void onChangeEvent(XObjectEvent event) {
            if (event.inTransaction()) {
                return;
            }
            HistoryManager.this.onEvent((XEvent)event);
        }
    };
    private final XTransactionEventListener txnEventListener = new XTransactionEventListener(){

        public void onChangeEvent(XTransactionEvent event) {
            HistoryManager.this.onEvent((XEvent)event);
        }
    };
    private final CacheManager cacheManager;
    private boolean autosaveActive = true;

    public static HistoryManager createEmpty(DirStore dirStore, ProjectProperties projectProperties, XAddress modelAddress) throws IOException {
        assert (!dirStore.getAutosavedFile().exists());
        CacheManager cacheManager = CacheManager.create();
        HistoryManager hm = new HistoryManager(cacheManager);
        hm.autosavedSyncLogState = new MemorySyncLogState(modelAddress);
        hm.latestAutosaveWrittenTimestampUTC = 0L;
        hm.currentRev = -30L;
        hm.latestAutosaveWrittenTimestampUTC = -1L;
        return hm;
    }

    private static void deleteSnapshotsInRevRange(DirStore dirStore, long lowRev, long highRev) {
        File[] files = dirStore.getSnapshotFiles();
        if (files != null) {
            for (File f : files) {
                long rev = DirStore.getSnapshotRev(f);
                if (rev < lowRev || rev >= highRev) continue;
                f.delete();
            }
        }
    }

    private static void extendSnapshotFromSynclogState(XRevWritableModel snapshot, XSyncLogState syncLogState, long requestedRev) {
        long lookupRev;
        long historyRev = syncLogState.getCurrentRevisionNumber();
        log.info("Try to add events from [" + lookupRev + "," + requestedRev + "] from history (max: " + historyRev + ")");
        for (lookupRev = snapshot.getRevisionNumber() + 1L; lookupRev <= requestedRev && lookupRev <= historyRev; ++lookupRev) {
            XEvent xe = syncLogState.getEvent(lookupRev);
            if (xe == null) continue;
            EventUtils.applyEvent((XRevWritableModel)snapshot, (XEvent)xe);
        }
    }

    public static boolean hasAutosavedEvents(DirStore dirStore) {
        return dirStore.getAutosavedFile().exists();
    }

    public static boolean hasHistory(DirStore dirStore) {
        File historyFile = dirStore.getHistoryFile();
        File autosavedFile = dirStore.getAutosavedFile();
        return historyFile.exists() || autosavedFile.exists();
    }

    public static HistoryManager writeMyBaseToHistory(DirStore dirStore, ProjectProperties projectProperties, CacheManager cacheManager, IMyBase myBase, IoProgressReporter iop) throws IOException {
        assert (dirStore.isWriteMode());
        assert (!dirStore.getAutosavedFile().exists());
        HistoryManager hm = new HistoryManager(cacheManager);
        XAddress modelAddress = myBase.itemSet().getXModel().getAddress();
        hm.autosavedSyncLogState = new MemorySyncLogState(modelAddress);
        hm.latestAutosaveWrittenTimestampUTC = 0L;
        hm.currentRev = -30L;
        hm.latestAutosaveWrittenTimestampUTC = -1L;
        long currentRev = myBase.itemSet().getXModel().getRevisionNumber();
        projectProperties.setHistoryMaxRevisionTo(currentRev);
        cacheManager.finishCaches(dirStore, myBase, iop);
        HistoryManager.write(dirStore, projectProperties, myBase, cacheManager, -30L);
        return hm;
    }

    public static HistoryManager open(DirStore dirStore, ProjectProperties projectProperties, CacheManager cacheManager, IMyBase myBase, IoProgressReporter iop, boolean startIndexes) throws IOException {
        long historyMaxRev;
        XSyncLogState historyState;
        assert (dirStore.isWriteMode());
        XAddress modelAddress = myBase.getXModel().getAddress();
        HistoryManager hm = new HistoryManager(cacheManager);
        long currentRev = projectProperties.getStoredRevision();
        assert (currentRev != -20L);
        hm.setCurrentRevision(projectProperties, currentRev);
        dirStore.deleteNextFiles();
        File historyFile = dirStore.getHistoryFile();
        try {
            historyState = (XSyncLogState)FstIO.readFromBinaryFst(historyFile, iop);
        }
        catch (Throwable t) {
            log.warn("Failed to read " + historyFile.getAbsolutePath());
            throw t;
        }
        if (historyState == null) {
            historyState = new MemorySyncLogState(modelAddress);
            historyMaxRev = 0L;
            iop.reportProgress("Created new persistent history");
        } else {
            historyMaxRev = historyState.getCurrentRevisionNumber();
            iop.reportProgress("Loaded history with revision " + historyMaxRev);
        }
        File autosavedFile = dirStore.getAutosavedFile();
        hm.autosavedSyncLogState = (XSyncLogState)FstIO.readFromBinaryFst(autosavedFile, iop);
        if (hm.autosavedSyncLogState == null) {
            iop.reportProgress("No auto-saved events found");
            hm.autosavedSyncLogState = new MemorySyncLogState(modelAddress);
        } else {
            iop.reportProgress("Found auto-saved events, up to revision " + hm.autosavedSyncLogState.getCurrentRevisionNumber());
        }
        CacheManager.initCaches(dirStore, myBase, iop);
        XExistsRevWritableModel snapshot = null;
        if (historyMaxRev >= 0L) {
            snapshot = HistoryManager.readSnapshot(dirStore, historyMaxRev, iop);
        }
        if (snapshot == null) {
            snapshot = new SimpleModel(modelAddress, 0L);
            HistoryManager.extendSnapshotFromSynclogState((XRevWritableModel)snapshot, historyState, historyMaxRev);
        } else {
            assert (snapshot.getRevisionNumber() == historyMaxRev);
            cacheManager.tryToLoadPrecomputedCaches(dirStore, myBase, historyMaxRev, iop);
        }
        assert (snapshot.getRevisionNumber() == historyState.getCurrentRevisionNumber());
        XModel model = DesktopIO.convertToModel(snapshot, historyState);
        iop.reportProgress("XModel ready.");
        iop.reportProgress("Replay all events, stand by...");
        boolean contentUpdateEvents = false;
        boolean statementEvents = true;
        boolean propertyEvents = false;
        boolean attributeEvents = true;
        myBase.itemSet().setXModel(model, false, true, false, true);
        projectProperties.setHistoryMaxRevisionTo(historyState.getCurrentRevisionNumber());
        iop.reportProgress("Adding auto-saved events");
        long lookupRev = historyMaxRev + 1L;
        HistoryManager.replayEvents(hm, lookupRev, model, iop);
        projectProperties.setHistoryMaxRevisionTo(historyState.getCurrentRevisionNumber());
        if (startIndexes) {
            cacheManager.finishCaches(dirStore, myBase, iop);
        }
        HistoryManager.write(dirStore, projectProperties, myBase, cacheManager, -30L);
        return hm;
    }

    private static XExistsRevWritableModel readLatestSnapshot(DirStore dirStore, long maxRev, IoProgressReporter iop) throws IOException {
        File[] snapshotFiles = dirStore.getSnapshotFiles();
        if (snapshotFiles != null) {
            File bestFile = null;
            long bestRev = -1L;
            for (File f : snapshotFiles) {
                long fileRev = DirStore.getSnapshotRev(f);
                if (bestFile != null && (maxRev == -30L && fileRev > maxRev || fileRev <= bestRev)) continue;
                bestRev = fileRev;
                bestFile = f;
            }
            if (bestFile != null) {
                log.info("Found best earlier snapshot in rev " + bestRev + " from " + bestFile);
                return (XExistsRevWritableModel)FstIO.readFromBinaryFst(bestFile, iop);
            }
        }
        return null;
    }

    private static XExistsRevWritableModel readSnapshot(DirStore dirStore, long rev, IoProgressReporter iop) throws IOException {
        assert (rev != -30L);
        XExistsRevWritableModel snapshot = null;
        File snapshotFile = dirStore.getSnapshotFile(rev);
        if (snapshotFile != null) {
            log.info("Streaming in snapshot from " + snapshotFile.getAbsolutePath());
            snapshot = (XExistsRevWritableModel)FstIO.readFromBinaryFst(snapshotFile, iop);
            log.info("Done reading in snapshot from " + snapshotFile.getAbsolutePath());
        }
        if (snapshot != null) {
            log.info("Read exact matching snapshot in rev " + rev + " from " + snapshotFile);
        }
        return snapshot;
    }

    private static void replayEvents(HistoryManager hm, long lookupRev, XModel model, IoProgressReporter iop) {
        long lastRev = hm.autosavedSyncLogState.getCurrentRevisionNumber();
        iop.reportProgress("Loaded auto-saved changes for " + (lookupRev == lastRev ? "just one revision: " + lookupRev : "revisions " + lookupRev + " to " + lastRev + ""));
        Iterator autosavedEventsIt = hm.autosavedSyncLogState.getSyncLogEntriesSince(lookupRev);
        while (autosavedEventsIt.hasNext()) {
            ISyncLogEntry se = (ISyncLogEntry)autosavedEventsIt.next();
            HistoryManager.replaySyncLogEntry(se, model);
        }
    }

    private static void replaySyncLogEntry(ISyncLogEntry syncLogEntry, XModel model) {
        long success;
        assert (syncLogEntry != null);
        assert (model != null);
        XEvent event = syncLogEntry.getEvent();
        if (event.getRevisionNumber() <= model.getRevisionNumber()) {
            log.warn("Skipping playback of event " + syncLogEntry + " because model has already rev=" + model.getRevisionNumber());
            return;
        }
        XCommand command = syncLogEntry.getCommand();
        if (command == null) {
            command = XChanges.createReplayCommand((XEvent)event, (boolean)false);
        }
        if (!XCommandUtils.success((long)(success = model.executeCommand(command)))) {
            log.warn("Failed to run " + syncLogEntry + " again");
        } else if (log.isTraceEnabled()) {
            log.trace("Success " + syncLogEntry);
        }
    }

    public static void write(DirStore dirStore, ProjectProperties projectProperties, IMyBase myBase, CacheManager cacheManager, long targetRev) throws IOException {
        HistoryManager.writeHistory(dirStore, myBase, targetRev);
        dirStore.writeProjectProperties(projectProperties);
        File autosavedFile = dirStore.getAutosavedFile();
        if (autosavedFile.exists()) {
            autosavedFile.delete();
        }
        XModel model = myBase.getXModel();
        if (targetRev == -30L) {
            XExistsRevWritableModel snapshot = XydraHacks.getXExistsRevWritableModel_fromXModel(model);
            HistoryManager.writeSnapshot(dirStore, (XExistsReadableModel)snapshot);
            HistoryManager.deleteSnapshotsInRevRange(dirStore, 0L, snapshot.getRevisionNumber());
        } else {
            HistoryManager.deleteSnapshotsInRevRange(dirStore, targetRev, Long.MAX_VALUE);
        }
        cacheManager.writeCaches(dirStore, myBase, targetRev);
    }

    private static void writeHistory(DirStore dirStore, IMyBase myBase, long targetRev) throws IOException {
        XSyncLogState historyState = XydraHacks.getSyncLogState_fromMyBase(myBase);
        if (historyState.getCurrentRevisionNumber() == 0L) {
            return;
        }
        if (targetRev != -30L) {
            MemorySyncLogState smaller = new MemorySyncLogState(historyState.getBaseAddress());
            Iterator it = historyState.getSyncLogEntriesBetween(1L, targetRev + 1L);
            while (it.hasNext()) {
                ISyncLogEntry syncLogEntry = (ISyncLogEntry)it.next();
                smaller.appendSyncLogEntry(syncLogEntry);
            }
            historyState = smaller;
        }
        File historyFile = dirStore.getHistoryFile();
        File nextHistoryFile = NextFiles.getNextFile(historyFile);
        FstIO.writeToBinaryFst(historyState, nextHistoryFile);
        NextFiles.commitNextLargerFile(historyFile);
    }

    private static void writeSnapshot(DirStore dirStore, XExistsReadableModel model) throws IOException {
        long rev = model.getRevisionNumber();
        if (rev == 0L) {
            return;
        }
        File snapshotFile = dirStore.getSnapshotFile(rev);
        if (snapshotFile.exists()) {
            log.warn("Snapshot " + snapshotFile.getAbsolutePath() + " exists. Not overwritten.");
        } else {
            FstIO.writeToBinaryFst(model, snapshotFile);
        }
    }

    private HistoryManager(CacheManager cacheManager) {
        this.cacheManager = cacheManager;
    }

    public void close() {
        this.duringEvents_xmodel.removeListenerForFieldEvents(this.fieldEventListener);
        this.duringEvents_xmodel.removeListenerForObjectEvents(this.objectEventListener);
        this.duringEvents_xmodel.removeListenerForModelEvents(this.modelEventListener);
        this.duringEvents_xmodel.removeListenerForTransactionEvents(this.txnEventListener);
        this.cacheManager.close();
    }

    private long getAutosavedMaxRevision() {
        XEvent xe = this.autosavedSyncLogState.getLastEvent();
        if (xe != null) {
            return xe.getRevisionNumber();
        }
        return -20L;
    }

    public long getCurrentRevision(ProjectProperties projectProperties) {
        assert (projectProperties != null);
        if (this.currentRev == -30L) {
            long autosavedMaxRev = this.getAutosavedMaxRevision();
            if (autosavedMaxRev == -20L) {
                return projectProperties.getHistoryMaxRevision();
            }
            return autosavedMaxRev;
        }
        return this.currentRev;
    }

    public long getLatestAutosaveTimestampUTC() {
        return this.latestAutosaveWrittenTimestampUTC;
    }

    public boolean hasRedoEvents(ProjectProperties projectProperties) {
        return this.currentRev != -30L && this.currentRev < projectProperties.getHistoryMaxRevision();
    }

    private void onEvent(XEvent event) {
        assert (this.autosavedSyncLogState != null);
        assert (event.getRevisionNumber() >= 0L);
        long timestamp = TimeProvider.getCurrentTimeInMillis();
        this.autosavedSyncLogState.appendEvent(event);
        this.persistAutoSavedEvents();
    }

    public void setAutosave(boolean b) {
        this.autosaveActive = b;
    }

    public void persistAutoSavedEvents() {
        if (this.autosaveActive) {
            File autosaveFile = this.duringEvents_dirStore.getAutosavedFile();
            File nextAutosaveFile = NextFiles.getNextFile(autosaveFile);
            try {
                FstIO.writeToBinaryFst(this.autosavedSyncLogState, nextAutosaveFile);
                NextFiles.commitNextLargerFile(autosaveFile);
                this.latestAutosaveWrittenTimestampUTC = autosaveFile.lastModified();
            }
            catch (IOException e) {
                log.warn("Could not auto-save", (Throwable)e);
                this.latestAutosaveWrittenTimestampUTC = -1L;
            }
        }
    }

    private void setCurrentRevision(ProjectProperties projectProperties, long rev) throws IllegalArgumentException {
        projectProperties.setStoredRevisionTo(rev);
        this.currentRev = rev;
    }

    public void startRecordingChangesOn(DirStore dirStore, XModel xmodel, IoProgressReporter iop) {
        iop.reportProgress("Activated auto-saver for all future changes");
        assert (dirStore.isWriteMode());
        assert (dirStore.isLockedOnThisOS());
        xmodel.addListenerForModelEvents(this.modelEventListener);
        xmodel.addListenerForObjectEvents(this.objectEventListener);
        xmodel.addListenerForFieldEvents(this.fieldEventListener);
        xmodel.addListenerForTransactionEvents(this.txnEventListener);
        this.duringEvents_dirStore = dirStore;
        this.duringEvents_xmodel = xmodel;
    }

    public static List<FileVersion> getFileVersions(XChangeLog changeLog, IMyBase myBase, long minRev, long maxRev, long maxGapBetweenVersions, int maxEventsPerVersion) {
        List<FileVersion> rawFileVersions = HistoryManager.toRawFileVersions(changeLog, myBase, minRev, maxRev);
        if (rawFileVersions.isEmpty() || rawFileVersions.size() == 1) {
            return rawFileVersions;
        }
        ArrayList<FileVersion> condensedFileVersions = new ArrayList<FileVersion>();
        long gap = 0L;
        int eventCount = 0;
        FileVersion condensedVersion = rawFileVersions.get(0);
        for (int i = 1; i < rawFileVersions.size(); ++i) {
            FileVersion rawVersion = rawFileVersions.get(i);
            gap = rawVersion.timestampStart - condensedVersion.timestampEnd;
            eventCount = condensedVersion.getEvents().size() + rawVersion.getEvents().size();
            if (gap > maxGapBetweenVersions || eventCount > maxEventsPerVersion) {
                condensedFileVersions.add(condensedVersion);
                condensedVersion = rawVersion;
                continue;
            }
            condensedVersion.mergeIn(rawVersion);
        }
        condensedFileVersions.add(condensedVersion);
        return condensedFileVersions;
    }

    private static List<FileVersion> toRawFileVersions(XChangeLog changeLog, IMyBase myBase, long minRev, long maxRev) {
        ArrayList<FileVersion> rawFileVersions = new ArrayList<FileVersion>();
        ArrayList<Object> events = new ArrayList<XEvent>();
        long sequenceTimeStamp = 0L;
        boolean eventDefinesTimestamp = false;
        boolean sequenceIsTimestamped = false;
        Iterator it = changeLog.getEventsBetween(minRev, maxRev);
        while (it.hasNext()) {
            XEvent event = (XEvent)it.next();
            long eventTimeStamp = HistoryManager.getChangeDate(event);
            eventDefinesTimestamp = eventTimeStamp > 0L;
            boolean bl = sequenceIsTimestamped = sequenceTimeStamp > 0L;
            if (eventDefinesTimestamp && sequenceIsTimestamped) {
                FileVersion fv = new FileVersion(myBase, changeLog, sequenceTimeStamp, event.getActor());
                fv.setEvents(events);
                rawFileVersions.add(fv);
                events = new ArrayList();
                events.add(event);
                sequenceTimeStamp = eventTimeStamp;
                continue;
            }
            if (eventDefinesTimestamp) {
                sequenceTimeStamp = eventTimeStamp;
            }
            events.add(event);
        }
        if (!rawFileVersions.isEmpty()) {
            ((FileVersion)rawFileVersions.get(rawFileVersions.size() - 1)).getEvents().addAll(events);
        }
        return rawFileVersions;
    }

    private static long getChangeDate(XEvent xe) {
        if (xe instanceof XAtomicEvent) {
            return HistoryManager.getChangeDate_Atomic(xe);
        }
        assert (xe instanceof XTransactionEvent);
        return HistoryManager.getChangeDate_Transaction((XTransactionEvent)xe);
    }

    private static long getChangeDate_Transaction(XTransactionEvent xte) {
        Iterator evIt = xte.iterator();
        long lastModified = 0L;
        long creationDate = 0L;
        while (evIt.hasNext()) {
            XAtomicEvent xae = (XAtomicEvent)evIt.next();
            if (!(xae instanceof XFieldEvent)) continue;
            XFieldEvent xafe = (XFieldEvent)xae;
            if ((lastModified = Math.max(lastModified, HistoryManager.getLastModified(xafe))) == 0L) {
                creationDate = Math.max(creationDate, HistoryManager.getCreationDate(xafe));
            }
            if (lastModified <= 0L) continue;
            break;
        }
        return Math.max(lastModified, creationDate);
    }

    private static long getChangeDate_Atomic(XEvent ae) {
        XFieldEvent afe;
        long changeDate = 0L;
        if (ae instanceof XFieldEvent && (changeDate = HistoryManager.getLastModified(afe = (XFieldEvent)ae)) == 0L) {
            changeDate = HistoryManager.getCreationDate(afe);
        }
        return changeDate;
    }

    private static long getCreationDate(XFieldEvent afe) {
        if (afe.getFieldId().equals((Object)VocabularyCModel.ATTRIBUTE_CREATION_DATE)) {
            XValue v = afe.getNewValue();
            if (v == null) {
                assert (afe.getChangeType() == ChangeType.REMOVE);
                return 0L;
            }
            assert (v != null);
            assert (v instanceof XLongValue) : "is " + v;
            XLongValue lv = (XLongValue)v;
            return lv.contents();
        }
        return 0L;
    }

    private static long getLastModified(XFieldEvent afe) {
        if (afe.getFieldId().equals((Object)VocabularyCModel.ATTRIBUTE_LAST_MODIFIED)) {
            XValue v = afe.getNewValue();
            if (v == null) {
                assert (afe.getChangeType() == ChangeType.REMOVE);
                return 0L;
            }
            assert (v != null);
            assert (v instanceof XLongValue) : "is " + v;
            XLongValue lv = (XLongValue)v;
            return lv.contents();
        }
        return 0L;
    }
}

