/*
 * Decompiled with CFR 0.152.
 */
package de.xam.dwzmodel.state;

import de.xam.dwzmodel.io.DwzFileFormats;
import de.xam.dwzmodel.io.persistence.FstIO;
import de.xam.dwzmodel.state.DirStore;
import de.xam.itemset.index.ICanSerialize;
import de.xam.itemset.index.IItemSetManagedIndex;
import de.xam.itemset.index.IndexManager;
import de.xam.itemset.index.IndexState;
import de.xam.mybase.model.IoProgressReporter;
import de.xam.mybase.model.api.IMyBase;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import org.xydra.log.api.Logger;
import org.xydra.log.api.LoggerFactory;

public class CacheManager {
    private static final Logger log = LoggerFactory.getLogger(CacheManager.class);

    public static CacheManager create() {
        return new CacheManager();
    }

    private static String getCacheName(IndexState indexState, long targetRev) {
        String name = "rev-" + targetRev + "." + indexState.getId() + "." + DwzFileFormats.CACHE.getDefaultExtension();
        return name;
    }

    public static void initCaches(DirStore dirStore, IMyBase myBase, IoProgressReporter iop) throws IOException {
        myBase.indexManager().setUpdating(false);
        myBase.indexManager().markAsDirty();
    }

    private CacheManager() {
    }

    public void close() {
    }

    public void finishCaches(DirStore dirStore, IMyBase myBase, IoProgressReporter iop) {
        myBase.indexManager().setUpdating(true);
        myBase.indexManager().reCompute((IndexManager.IIndexProgress)iop);
        myBase.indexManager().assertIndexesAre_computed_updating(Boolean.valueOf(true), Boolean.valueOf(true));
        assert (myBase.infModel().isComputed());
    }

    public void tryToLoadPrecomputedCaches(DirStore dirStore, IMyBase myBase, long loadRev, IoProgressReporter iop) throws IOException {
        for (IndexState indexState : myBase.indexManager().list()) {
            String cacheName = CacheManager.getCacheName(indexState, loadRev);
            File f = dirStore.getShadowFile(cacheName);
            if (!f.exists()) continue;
            try {
                Object o = FstIO.readFromBinaryFst(f, iop);
                if (o != null) {
                    IItemSetManagedIndex index = indexState.getManagedIndex();
                    assert (index instanceof ICanSerialize);
                    assert (o instanceof Serializable);
                    Serializable so = (Serializable)o;
                    ICanSerialize sIndex = (ICanSerialize)index;
                    sIndex.setSerializableState(so);
                    indexState.markAsComputed();
                    myBase.indexManager().setUpdating(index, true);
                    continue;
                }
                log.warn("Loaded null from cache file " + f.getAbsolutePath());
            }
            catch (Throwable t) {
                log.warn("Could not load from cache file " + f.getAbsolutePath(), t);
            }
        }
    }

    public void writeCaches(DirStore dirStore, IMyBase myBase, long targetRev) throws IOException {
        long writeRev = targetRev == -30L ? myBase.getXModel().getRevisionNumber() : targetRev;
        for (IndexState indexState : myBase.indexManager().list()) {
            IItemSetManagedIndex index = indexState.getManagedIndex();
            if (!(index instanceof ICanSerialize)) continue;
            ICanSerialize sIndex = (ICanSerialize)index;
            Serializable o = sIndex.getSerializableState();
            String cacheName = CacheManager.getCacheName(indexState, writeRev);
            File f = dirStore.getShadowFile(cacheName);
            FstIO.writeToBinaryFst(o, f);
        }
    }
}

