/*
 * Decompiled with CFR 0.152.
 */
package de.xam.dwzmodel.io.persistence;

import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.converters.SingleValueConverter;
import de.xam.dwzmodel.io.import_before_kgif.StorageManager_v2_xstream;
import de.xam.mybase.model.IoProgressReporter;
import de.xam.texthtml.text.Unicodes;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import org.xydra.base.id.RefId;
import org.xydra.base.value.impl.memory.MemoryLongValue;
import org.xydra.base.value.impl.memory.MemoryStringValue;
import org.xydra.core.model.XModel;

public class XStreamIO {
    private static XStream getConfiguredXSteam() {
        XStream xstream = new XStream();
        xstream.setMode(1002);
        xstream.alias("xlong", MemoryLongValue.class);
        xstream.alias("xstring", MemoryStringValue.class);
        xstream.alias("xid", RefId.class);
        xstream.registerConverter((SingleValueConverter)new StorageManager_v2_xstream.LongValueConverter());
        xstream.registerConverter((SingleValueConverter)new StorageManager_v2_xstream.StringValueConverter());
        xstream.registerConverter((SingleValueConverter)new StorageManager_v2_xstream.IdConverter());
        return xstream;
    }

    public static XModel readXModelFromXmlXStream(File f, IoProgressReporter iop) throws IOException {
        iop.reportProgress("Streaming data in from " + f.getAbsolutePath());
        FileInputStream fis = new FileInputStream(f);
        InputStreamReader r = new InputStreamReader((InputStream)fis, Unicodes.UTF8);
        XStream xstream = XStreamIO.getConfiguredXSteam();
        XModel xmodel = (XModel)xstream.fromXML((Reader)r);
        return xmodel;
    }

    public static void writeXModelToXmlXStream(XModel xmodel, File f) throws IOException {
        XStream xstream = XStreamIO.getConfiguredXSteam();
        f.getParentFile().mkdirs();
        FileOutputStream fos = new FileOutputStream(f);
        OutputStreamWriter w = new OutputStreamWriter((OutputStream)fos, Unicodes.UTF8);
        xstream.toXML((Object)xmodel, (Writer)w);
        w.close();
        fos.close();
    }
}

