/*
 * Decompiled with CFR 0.152.
 */
package de.xam.dwzmodel.io;

import com.calpano.kgif.io.FileFormat;
import com.calpano.kgif.io.FileFormats;
import com.calpano.kgif.io.rdf.RdfCommon;
import de.xam.files.FilenameUtils;
import java.util.Collection;

public class DwzFileFormats {
    public static final FileFormat AUTOSAVED_CHANGES = new FileFormat("DwzAutosavedChanges", "DWZ Auto-saved changes", "fst", "autosaved-changes.dstore", new String[]{"dstore"}, "application/binary", 1.0, "DWZ internal format for auto-saved changes, see DenkWerkZeug.org. Stores auto-saved changes from event X+1 to currentRevision. This is typicall a small file.");
    public static final FileFormat CACHE = new FileFormat("dwzcache", "DWZ Cache File", "binary", null, new String[]{"dcache"}, "application/binary", 1.0, "Internal cache file format of DenkWerkZeug.com. These files can safely be deleted. They are used to speed up the load process and are re-created as needed.");
    public static final FileFormat DATAFILES = new FileFormat("datafiles", "DataFiles", "many textfiles", null, null, null, 1.0, "Author: dev@xam.de; DenkWerkZeug 1.0.0 format (deprecated)");
    public static final FileFormat DIR_LOCK = new FileFormat("dirlock", "Directory Lock File", null, "dir.lock", new String[]{FilenameUtils.getExtension((String)"dir.lock")}, null, 0.0, "Internal DWZ File.");
    public static final FileFormat FILEFORMAT_DWZ = new FileFormat("dwz", "DenkWerkZeug 1.5.x Format", "Database", null, new String[0], null, 1.0, "See denkwerkzeug.org");
    public static final FileFormat HISTORY = new FileFormat("DwzHistory", "DWZ persistent history", "fst", "stored-changes.dstore", new String[]{"dstore"}, "application/binary", 1.0, "DWZ internal format for file history (including content), see DenkWerkZeug.org. Stores history from event 0 up to an event X.");
    public static final FileFormat ITEMS_XML = new FileFormat("dwz100", "Xydra XML Format", "XML", "items.xydra.xml", new String[]{"xydra.xml"}, "application/xydra+xml", 1.0, "See xydra.org");
    public static final FileFormat NEXT = new FileFormat("dwznext", "DWZ internal file", "binary", null, new String[]{"next"}, "application/binary", 1.0, "Internal file used by DenkWerkzeug.com during transactional writes. These files can safely be deleted.");
    public static final FileFormat PROJECT_PROPERTIES = new FileFormat("dwzproperties", "DWZ Project Properties", "Java Properties format", "project.properties", new String[]{"properties"}, "text/plain", 1.0, "Meta-data for a knowledge file in DenkWerkZeug. Stores the current revision number. Deleting this file is not recommended.");
    public static final FileFormat XSTREAM_XML = new FileFormat("xstream", "XStream XML Format", "XML", "items.xstream.xml", new String[]{"xstream.xml"}, "application/xstream+xml", 1.0, "No documentation");
    private static boolean initialized;

    public static Collection<FileFormat> getKnownFileFormats() {
        return FileFormats.getRegisteredFileFormats();
    }

    public static synchronized void init() {
        if (initialized) {
            return;
        }
        FileFormats.register((FileFormat)XSTREAM_XML);
        FileFormats.register((FileFormat)ITEMS_XML);
        FileFormats.register((FileFormat)DATAFILES);
        FileFormats.register((FileFormat)FILEFORMAT_DWZ);
        FileFormats.register((FileFormat)HISTORY);
        FileFormats.register((FileFormat)AUTOSAVED_CHANGES);
        FileFormats.register((FileFormat)CACHE);
        FileFormats.register((FileFormat)PROJECT_PROPERTIES);
        FileFormats.register((FileFormat)NEXT);
        RdfCommon.init();
        initialized = true;
    }

    static {
        DwzFileFormats.init();
    }
}

