/*
 * Decompiled with CFR 0.152.
 */
package de.xam.dwzmodel.graph2.visual;

import com.google.common.collect.Sets;
import de.xam.dwzmodel.graph2.logical.LogicalNode;
import de.xam.dwzmodel.graph2.visual.VisualEntity;
import de.xam.dwzmodel.graph2.visual.VisualGraph;
import de.xam.dwzmodel.graph2.visual.VisualGraphs;
import de.xam.dwzmodel.graph2.visual.VisualNodeType;
import de.xam.json.JON;
import java.util.HashSet;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import org.xydra.index.CollectionUtils;

public class VisualNode
extends VisualEntity
implements Comparable<VisualNode> {
    private final SortedSet<LogicalNode> logicalNodes;
    private VisualNodeType type = VisualNodeType.normal;

    public VisualNode(VisualGraph visualGraph, LogicalNode logicalNode) {
        super(visualGraph);
        this.logicalNodes = new TreeSet<LogicalNode>();
        this.logicalNodes.add(logicalNode);
    }

    public void mergeIn(VisualNode secondaryNode) {
        this.logicalNodes.addAll(secondaryNode.getLogicalNodes());
    }

    @Override
    public int compareTo(VisualNode o) {
        return this.getPrimaryLogicalNode().compareTo(o.getPrimaryLogicalNode());
    }

    public boolean equals(Object other) {
        if (other instanceof VisualNode) {
            VisualNode o = (VisualNode)other;
            return CollectionUtils.equalSets(this.getLogicalNodes(), o.getLogicalNodes());
        }
        return false;
    }

    @Override
    public JON getJsonAttributes() {
        JON jsonAttributes = JON.create();
        int minDepth = Integer.MAX_VALUE;
        for (LogicalNode n : this.logicalNodes) {
            minDepth = Math.min(minDepth, n.getDepth());
        }
        jsonAttributes.putInt("depth", new Integer[]{minDepth});
        jsonAttributes.putInt("typenumber", new Integer[]{this.type.ordinal()});
        jsonAttributes.putString("xid", new String[]{this.getPrimaryLogicalNode().getItemId().toString()});
        return jsonAttributes;
    }

    @Override
    public Set<String> getCssClasses() {
        HashSet css = Sets.newHashSet(super.getCssClasses());
        if (this.isFrontier()) {
            css.add("frontier");
        }
        return css;
    }

    boolean isFrontier() {
        boolean isFrontier = false;
        for (LogicalNode n : this.logicalNodes) {
            isFrontier |= n.isFrontier();
        }
        return isFrontier;
    }

    public String getLabel() {
        return VisualGraphs.toLabel(this.getVisualGraph(), this.getLogicalNodes());
    }

    public SortedSet<LogicalNode> getLogicalNodes() {
        return this.logicalNodes;
    }

    public LogicalNode getPrimaryLogicalNode() {
        return this.getLogicalNodes().first();
    }

    public int hashCode() {
        int hash = 1;
        for (LogicalNode n : this.getLogicalNodes()) {
            hash *= n.hashCode();
        }
        return hash;
    }

    public String toString() {
        return this.getPrimaryLogicalNode().toString() + "[#" + this.logicalNodes.size() + "]";
    }

    public void setType(VisualNodeType type) {
        this.type = type;
    }
}

