/*
 * Decompiled with CFR 0.152.
 */
package de.xam.dwzmodel.graph2.logical;

import de.xam.dwzmodel.graph2.logical.LogicalComponent;
import de.xam.dwzmodel.graph2.logical.LogicalGraph;
import de.xam.dwzmodel.graph2.logical.LogicalNode;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import org.xydra.index.impl.CountingMap;
import org.xydra.index.impl.MapIndex;
import org.xydra.index.iterator.Iterators;

public class LogicalPartition {
    private final SortedSet<LogicalComponent> components = new TreeSet<LogicalComponent>();
    private final LogicalGraph logicalGraph;
    private final MapIndex<LogicalNode, LogicalComponent> member2component = new MapIndex();

    public LogicalPartition(LogicalGraph logicalGraph) {
        this.logicalGraph = logicalGraph;
    }

    public void addMemberNode(LogicalNode logicalNode) {
        LogicalComponent component = (LogicalComponent)this.member2component.lookup((Object)logicalNode);
        if (component == null) {
            component = new LogicalComponent(this.logicalGraph, logicalNode);
            this.components.add(component);
            this.member2component.index((Object)logicalNode, (Object)component);
        }
    }

    public Iterable<LogicalComponent> getComponents() {
        return Iterators.from(this.components.iterator());
    }

    public void mergeDirectNeighbours() {
        for (LogicalComponent component : this.getComponents()) {
            for (LogicalNode node : component.getNeighbours(1)) {
                assert (!component.getMembers().contains(node));
                LogicalComponent neighbour = (LogicalComponent)this.member2component.lookup((Object)node);
                if (neighbour == null) continue;
                component.mergeIn(neighbour);
                this.components.remove(neighbour);
                for (LogicalNode n : neighbour.getMembers()) {
                    this.member2component.index((Object)n, (Object)component);
                }
            }
        }
    }

    public String toString() {
        StringBuilder b = new StringBuilder();
        for (LogicalComponent c : this.getComponents()) {
            b.append("Component \n");
            for (LogicalNode n : c.getMembers()) {
                b.append("+ " + n + "\n");
            }
            for (LogicalNode n : c.getNeighbours(1)) {
                b.append("- " + n + "\n");
            }
        }
        return b.toString();
    }

    public Set<LogicalNode> getRing(int depth) {
        HashSet<LogicalNode> unifiedRing = new HashSet<LogicalNode>();
        for (LogicalComponent c : this.getComponents()) {
            Set<LogicalNode> componentRing = c.getNeighbours(depth);
            unifiedRing.addAll(componentRing);
        }
        return unifiedRing;
    }

    public LogicalNode getBestConnectingNode() {
        int depth = 1;
        boolean exploreMore = true;
        while (exploreMore) {
            CountingMap counting = new CountingMap();
            for (LogicalComponent component : this.getComponents()) {
                Set<LogicalNode> componentRing = component.getNeighbours(depth);
                for (LogicalNode node : componentRing) {
                    if (component.isMemberUpToDepth(depth - 1, node)) continue;
                    counting.index((Object)node);
                }
            }
            List topNodes = counting.getTop_k_SortedBy(Integer.MAX_VALUE, true);
            for (LogicalNode topNode : topNodes) {
                int count = (Integer)counting.getCount((Object)topNode);
                if (count <= 1) continue;
                return topNode;
            }
            ++depth;
            exploreMore = !counting.isEmpty();
        }
        return null;
    }
}

