/*
 * Decompiled with CFR 0.152.
 */
package de.xam.dwzmodel.graph2;

import com.google.common.collect.HashBiMap;
import de.xam.dwzmodel.graph2.visual.CaptionEntry;
import de.xam.dwzmodel.graph2.visual.VisualGraph;
import de.xam.dwzmodel.graph2.visual.VisualLink;
import de.xam.dwzmodel.graph2.visual.VisualNode;
import de.xam.json.JON;
import de.xam.texthtml.text.EncTool;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;

public class JsonGraphs {
    public static final String JSON_ATT_CSSCLASS = "class";
    public static final String JSON_ATT_DEPTH = "depth";
    public static final String JSON_ATT_LABEL = "label";
    public static final String JSON_ATT_LABELS = "labels";
    private static final String JSON_ATT_SOURCE = "source";
    private static final String JSON_ATT_TARGET = "target";
    public static final String JSON_ATT_TYPE = "type";
    public static final String JSON_ATT_TYPENUMBER = "typenumber";
    public static final String JSON_ATT_XID = "xid";
    private static final String JSON_SECTION_CAPTIONS = "captions";
    private static final String JSON_SECTION_LINKS = "links";
    private static final String JSON_SECTION_NODES = "nodes";

    private static void addJsonAttributesAndCssClasses(JON targetJon, JON sourceJon, Iterable<String> cssClasses) {
        String css;
        targetJon.putAll(sourceJon);
        if (cssClasses != null && cssClasses.iterator().hasNext() && (css = JsonGraphs.toCssString(cssClasses)).length() > 0) {
            targetJon.appendString(JSON_ATT_CSSCLASS, " ", css);
        }
    }

    private static String toCssString(Iterable<String> cssClasses) {
        StringBuilder b = new StringBuilder();
        Iterator<String> it = cssClasses.iterator();
        while (it.hasNext()) {
            String cssClass = it.next();
            String cssClassName = EncTool.escapeCssIdOrClassname((String)cssClass);
            b.append(cssClassName);
            if (!it.hasNext()) continue;
            b.append(" ");
        }
        return b.toString();
    }

    public static JON toJon(VisualGraph visualGraph) {
        JON jon = JON.create();
        JON captions = jon.goTo(JSON_SECTION_CAPTIONS).setTypeAsArray();
        HashBiMap numbered = HashBiMap.create((int)visualGraph.getNodeCount());
        int number = 0;
        for (VisualNode centralNode : visualGraph.getCentralNodes()) {
            numbered.put((Object)centralNode, (Object)number);
            ++number;
        }
        for (VisualNode node : visualGraph.getNodes()) {
            if (visualGraph.getCentralNodes().contains(node)) continue;
            numbered.put((Object)node, (Object)number);
            ++number;
        }
        JON nodes = jon.goTo(JSON_SECTION_NODES).setTypeAsArray();
        for (int i = 0; i < number; ++i) {
            VisualNode visualNode = (VisualNode)numbered.inverse().get((Object)i);
            String label = visualNode.getLabel();
            if (label == null) {
                label = visualNode.toString();
            }
            JON node = nodes.createChildValue().putString(JSON_ATT_LABEL, new String[]{label});
            JsonGraphs.addJsonAttributesAndCssClasses(node, visualNode.getJsonAttributes(), visualNode.getCssClasses());
        }
        JON links = jon.goTo(JSON_SECTION_LINKS).setTypeAsArray();
        for (VisualLink visualLink : visualGraph.getLinks()) {
            assert (visualLink != null);
            VisualNode source = visualLink.getSource();
            Integer startNum = (Integer)numbered.get((Object)source);
            assert (startNum != null) : "No number found for " + source;
            VisualNode target = visualLink.getTarget();
            Integer endNum = (Integer)numbered.get((Object)target);
            assert (endNum != null) : "No number found for " + target;
            JON link = links.createChildValue().putInt(JSON_ATT_SOURCE, new Integer[]{startNum}).putInt(JSON_ATT_TARGET, new Integer[]{endNum});
            JsonGraphs.addJsonAttributesAndCssClasses(link, visualLink.getJsonAttributes(), visualLink.getCssClasses());
        }
        Comparator<Object> comp = new Comparator<Object>(){

            @Override
            public int compare(Object objA, Object objB) {
                JON a = (JON)objA;
                JON b = (JON)objB;
                int i = a.getInt(JsonGraphs.JSON_ATT_SOURCE) - b.getInt(JsonGraphs.JSON_ATT_SOURCE);
                if (i != 0) {
                    return i;
                }
                i = a.getInt(JsonGraphs.JSON_ATT_TARGET) - b.getInt(JsonGraphs.JSON_ATT_TARGET);
                return i;
            }
        };
        Collections.sort(links.getValues(), comp);
        for (CaptionEntry captionEntry : visualGraph.getCaptions()) {
            JON caption = captions.createChildValue();
            caption.putAll(captionEntry.getJON());
        }
        return jon;
    }
}

