/*
 * Decompiled with CFR 0.152.
 */
package de.xam.dwzmodel.graph.visual;

import com.google.common.collect.HashBiMap;
import de.xam.dwzmodel.api.VocabularyContextGraph;
import de.xam.dwzmodel.graph.GraphJob;
import de.xam.dwzmodel.graph.LinkBaseType;
import de.xam.dwzmodel.graph.logical.LogicalGraph;
import de.xam.dwzmodel.graph.logical.LogicalGraphs;
import de.xam.dwzmodel.graph.logical.LogicalLink;
import de.xam.dwzmodel.graph.logical.LogicalNode;
import de.xam.dwzmodel.graph.visual.GraphSimplifier;
import de.xam.dwzmodel.graph.visual.ICaptionEntry;
import de.xam.dwzmodel.graph.visual.IVisualGraph;
import de.xam.dwzmodel.graph.visual.IVisualLink;
import de.xam.dwzmodel.graph.visual.IVisualNode;
import de.xam.dwzmodel.graph.visual.impl.VisualFactory;
import de.xam.dwzmodel.graph.visual.impl.VisualGraph;
import de.xam.itemset.CDS;
import de.xam.itemset.EntityType;
import de.xam.itemset.IEntity;
import de.xam.itemset.IItem;
import de.xam.json.JON;
import de.xam.mybase.model.MyBases;
import de.xam.mybase.model.api.IMyBase;
import de.xam.texthtml.text.EncTool;
import de.xam.vocabulary.Vocabularies;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import org.xydra.base.XId;
import org.xydra.base.value.XValue;
import org.xydra.index.Factory;
import org.xydra.index.IEntrySet;
import org.xydra.index.impl.FastEntrySetFactory;
import org.xydra.index.impl.MapSetIndex;
import org.xydra.index.query.ITriple;
import org.xydra.index.query.TripleProjection;
import org.xydra.log.api.Logger;
import org.xydra.log.api.LoggerFactory;

public class VisualGraphs {
    private static final Logger log = LoggerFactory.getLogger(VisualGraphs.class);
    static Map<XId, Double> relationPreferenceMap = new HashMap<XId, Double>();

    static void addContextAttributes(VisualGraph graph) {
        for (IVisualNode node : graph.getNodes()) {
            VisualGraphs.addContextGraphAttributes(graph.getLogicalGraph().getMyBase(), node);
        }
        for (IVisualLink link : graph.getLinks()) {
            VisualGraphs.addContextGraphAttributes(graph.getLogicalGraph().getMyBase(), link);
        }
    }

    private static void addContextGraphAttributes(IMyBase myBase, IVisualLink link) {
        JON jsonAtts = link.getJsonAttributes();
        XId p = (XId)link.getLogicalLink().asTriple().p();
        jsonAtts.putString("class", new String[]{EncTool.escapeCssIdOrClassname((String)p.toString())});
        Map propMap = MyBases.getPropertiesAsMap((IMyBase)myBase, (XId)p, (boolean)false);
        for (Map.Entry e : propMap.entrySet()) {
            XId x = (XId)e.getKey();
            if (!VocabularyContextGraph._CONTEXT_GRAPH.contains(x)) continue;
            String key = Vocabularies.getLocalname((XId)x);
            jsonAtts.putString(key, new String[]{((XValue)e.getValue()).toString()});
        }
        String label = link.getLogicalLink().getLabel();
        jsonAtts.putString("label", new String[]{label});
        jsonAtts.putString("xid", new String[]{p.toString()});
        jsonAtts.putString("_t", new String[]{link.getLogicalLink().asTriple().s() + "--" + link.getLogicalLink().asTriple().p() + "--" + link.getLogicalLink().asTriple().o()});
    }

    private static void addContextGraphAttributes(IMyBase myBase, IVisualNode visualNode) {
        EntityType entityType;
        JON jsonAttributes = visualNode.getJsonAttributes();
        LogicalNode logicalNode = visualNode.getPrimaryLogicalNode();
        IEntity firstEntity = logicalNode.getBaseEntity();
        if (firstEntity != null) {
            XId nodeId = firstEntity.getId();
            String idStr = nodeId.toString();
            jsonAttributes.putString("xid", new String[]{idStr});
        }
        if ((entityType = EntityType.getType((IEntity)firstEntity)) == EntityType.Item) {
            IItem item = (IItem)firstEntity;
            assert (item != null);
            Iterator typeIt = TripleProjection.o((Iterator)myBase.infModel().getTriples(item.getId(), (XId)CDS.INSTANCE.hasType, null));
            while (typeIt.hasNext()) {
                XId type = (XId)typeIt.next();
                String cssClassName = EncTool.escapeCssIdOrClassname((String)type.toString());
                visualNode.getCssClasses().add(cssClassName);
            }
            Map propMap = MyBases.getAttributesAsMap((IMyBase)myBase, (IItem)item, (boolean)true);
            block8: for (Map.Entry e : propMap.entrySet()) {
                XId p = (XId)e.getKey();
                if (!VocabularyContextGraph._CONTEXT_GRAPH.contains(p)) continue;
                String key = Vocabularies.getLocalname((XId)p);
                XValue value = (XValue)e.getValue();
                if (value == null) continue;
                switch (value.getType()) {
                    case String: {
                        try {
                            Double d = Double.parseDouble(value.toString());
                            jsonAttributes.putNumber(key, new Number[]{d});
                        }
                        catch (NumberFormatException e1) {
                            jsonAttributes.putString(key, new String[]{value.toString()});
                        }
                        continue block8;
                    }
                    case Boolean: {
                        jsonAttributes.putString(key, new String[]{value.toString()});
                        continue block8;
                    }
                    case Integer: 
                    case Long: 
                    case Double: {
                        String s = value.toString();
                        Double d = Double.parseDouble(s);
                        jsonAttributes.putNumber(key, new Number[]{d});
                        continue block8;
                    }
                }
                log.warn("Could not copy value of type " + value.getType() + " of property " + p);
            }
        }
    }

    private static void addJsonAttributesAndCssClasses(JON targetJon, JON sourceJon, Set<String> cssClasses) {
        String css;
        targetJon.putAll(sourceJon);
        if (cssClasses != null && !cssClasses.isEmpty() && (css = VisualGraphs.toCssString(cssClasses)).length() > 0) {
            targetJon.appendString("class", " ", css);
        }
    }

    public static VisualGraph calculateVisualGraph(IMyBase myBase, LogicalGraph logicalGraph, GraphJob job) {
        VisualGraph visualGraph = VisualGraphs.toVisualGraph(myBase, logicalGraph, job);
        GraphSimplifier.simplify(myBase, job, visualGraph);
        return visualGraph;
    }

    public static IVisualGraph createVisualGraph(IMyBase myBase, GraphJob job, List<XId> startItemIds) {
        VisualGraph visualGraph;
        boolean foundNewLinks;
        LogicalGraph logicalGraph = new LogicalGraph(myBase);
        logicalGraph.getCentralNodes().addAll(startItemIds);
        HashSet<XId> frontierIds = new HashSet<XId>();
        frontierIds.addAll(startItemIds);
        HashSet<XId> knownNodeIds = new HashSet<XId>();
        HashSet<XId> nextFrontierIds = new HashSet<XId>();
        int depth = -1;
        do {
            foundNewLinks = false;
            ++depth;
            for (XId frontierNodeId : frontierIds) {
                knownNodeIds.add(frontierNodeId);
                logicalGraph.getOrCreateAndAddNode(frontierNodeId, depth);
                List<LogicalLink> links = LogicalGraphs.explore(myBase, job, logicalGraph, frontierNodeId, depth);
                for (LogicalLink link : links) {
                    assert (link.getStartId().equals((Object)frontierNodeId)) : "link=" + link + " frontier=" + frontierNodeId;
                    XId endNodeId = link.getEndId();
                    if (knownNodeIds.contains(endNodeId)) {
                        foundNewLinks |= logicalGraph.indexLink(link, job.showSelfLinks);
                        continue;
                    }
                    if (depth >= job.maxDepth) continue;
                    nextFrontierIds.add(endNodeId);
                    logicalGraph.getOrCreateAndAddNode(endNodeId, depth + 1);
                    foundNewLinks |= logicalGraph.indexLink(link, job.showSelfLinks);
                    knownNodeIds.add(endNodeId);
                }
            }
            frontierIds = nextFrontierIds;
            nextFrontierIds = new HashSet();
            visualGraph = VisualGraphs.calculateVisualGraph(myBase, logicalGraph, job);
        } while (foundNewLinks && VisualGraphs.isSmallerThanJobAllows(job, visualGraph, depth));
        VisualGraphs.addContextAttributes(visualGraph);
        return visualGraph;
    }

    public static IVisualGraph createVisualGraph(IMyBase myBase, List<XId> startItemIds, int maxDepth, int maxNodes) {
        GraphJob job = new GraphJob();
        if (maxDepth >= 0) {
            job.maxDepth = maxDepth;
        }
        if (maxNodes >= 0) {
            job.maxNodes = maxNodes;
        }
        IVisualGraph visualGraph = VisualGraphs.createVisualGraph(myBase, job, startItemIds);
        return visualGraph;
    }

    public static double getRelationPreference(XId p) {
        Double d = relationPreferenceMap.get(p);
        if (d == null) {
            return 0.6;
        }
        return d;
    }

    public static boolean isSmallerThanJobAllows(GraphJob job, IVisualGraph visualGraph, int depth) {
        if (visualGraph.getNodeCount() >= job.maxNodes) {
            return false;
        }
        return depth < job.maxDepth;
    }

    private static String toCssString(Set<String> cssClasses) {
        StringBuilder b = new StringBuilder();
        Iterator<String> it = cssClasses.iterator();
        while (it.hasNext()) {
            String cssClass = it.next();
            String cssClassName = EncTool.escapeCssIdOrClassname((String)cssClass);
            b.append(cssClassName);
            if (!it.hasNext()) continue;
            b.append(" ");
        }
        return b.toString();
    }

    /*
     * WARNING - void declaration
     */
    public static JON toJon(IVisualGraph visualGraph) {
        void var6_10;
        JON jon = JON.create();
        JON captions = jon.goTo("captions").setTypeAsArray();
        HashBiMap numbered = HashBiMap.create((int)visualGraph.getNodeCount());
        int number = 0;
        for (IVisualNode iVisualNode : visualGraph.getCentralNodes()) {
            numbered.put((Object)iVisualNode, (Object)number);
            ++number;
        }
        for (IVisualNode iVisualNode : visualGraph.getNodes()) {
            if (visualGraph.getCentralNodes().contains(iVisualNode)) continue;
            numbered.put((Object)iVisualNode, (Object)number);
            ++number;
        }
        JON nodes = jon.goTo("nodes").setTypeAsArray();
        boolean bl = false;
        while (var6_10 < number) {
            IVisualNode visualNode = (IVisualNode)numbered.inverse().get((Object)((int)var6_10));
            String label = visualNode.getPrimaryLogicalNode().getLabel();
            if (label == null) {
                label = visualNode.toString();
            }
            JON node = nodes.createChildValue().putString("label", new String[]{label});
            VisualGraphs.addJsonAttributesAndCssClasses(node, visualNode.getJsonAttributes(), visualNode.getCssClasses());
            ++var6_10;
        }
        JON jON = jon.goTo("links").setTypeAsArray();
        for (IVisualLink visualLink : visualGraph.getLinks()) {
            assert (visualLink != null);
            Integer startNum = (Integer)numbered.get((Object)visualLink.getStart());
            assert (startNum != null);
            Integer endNum = (Integer)numbered.get((Object)visualLink.getEnd());
            assert (endNum != null);
            JON link = jON.createChildValue().putInt("source", new Integer[]{startNum}).putInt("target", new Integer[]{endNum});
            VisualGraphs.addJsonAttributesAndCssClasses(link, visualLink.getJsonAttributes(), visualLink.getCssClasses());
        }
        Comparator<Object> comp = new Comparator<Object>(){

            @Override
            public int compare(Object objA, Object objB) {
                JON a = (JON)objA;
                JON b = (JON)objB;
                int i = a.getInt("source") - b.getInt("source");
                if (i != 0) {
                    return i;
                }
                i = a.getInt("target") - b.getInt("target");
                return i;
            }
        };
        Collections.sort(jON.getValues(), comp);
        for (ICaptionEntry le : visualGraph.getCaptions()) {
            JON caption = captions.createChildValue();
            caption.putString("type", new String[]{le.getVisualType().toString().toLowerCase()});
            caption.putString("label", new String[]{le.getLabel()});
            caption.putString("class", new String[]{le.getCssString()});
            caption.putString("xid", new String[]{le.getLinkedId().toString()});
            caption.putInt("typenumber", new Integer[]{le.getTypeNumber()});
        }
        return jon;
    }

    private static LogicalGraph toUnifiedLogicalGraph(IMyBase myBase, LogicalGraph nonUnifiedlogicalGraph, GraphJob job) {
        MapSetIndex entityId2equivalenceSet = new MapSetIndex((Factory)new FastEntrySetFactory());
        for (LogicalNode logicalNode : nonUnifiedlogicalGraph.getNodes()) {
            XId startId = logicalNode.getBaseEntity().getId();
            for (LogicalLink sameLogicalLink : logicalNode.getLinksWithType((XId)CDS.INSTANCE.sameAs)) {
                XId endId = sameLogicalLink.getEndId();
                if (startId.equals((Object)endId)) continue;
                entityId2equivalenceSet.index((Object)startId, (Object)endId);
                entityId2equivalenceSet.index((Object)endId, (Object)startId);
            }
        }
        LogicalGraph unifiedLogicalGraph = new LogicalGraph(myBase);
        for (LogicalNode logicalNode : nonUnifiedlogicalGraph.getNodes()) {
            XId startId = logicalNode.getBaseEntity().getId();
            IEntrySet equivalents = entityId2equivalenceSet.lookup((Object)startId);
            if (equivalents == null || equivalents.isEmpty()) {
                unifiedLogicalGraph.getOrCreateAndAddNode(startId, logicalNode.getDepth());
                continue;
            }
            TreeSet<XId> sorted = new TreeSet<XId>(equivalents.toSet());
            sorted.add(startId);
            if (!((XId)sorted.first()).equals((Object)startId)) continue;
            unifiedLogicalGraph.getOrCreateAndAddNode(sorted, logicalNode.getDepth());
        }
        unifiedLogicalGraph.getCentralNodes().addAll(nonUnifiedlogicalGraph.getCentralNodes());
        return unifiedLogicalGraph;
    }

    private static VisualGraph toVisualGraph(IMyBase myBase, LogicalGraph nonUnifiedlogicalGraph, GraphJob job) {
        LogicalGraph unifiedLogicalGraph = VisualGraphs.toUnifiedLogicalGraph(myBase, nonUnifiedlogicalGraph, job);
        for (LogicalNode unifiedLogicalNode : unifiedLogicalGraph.getNodes()) {
            SortedSet<IEntity> unifiedNodeStartEntities = unifiedLogicalNode.getBaseEntities();
            MapSetIndex unifiedJsonAtts = MapSetIndex.createWithSmallEntrySets();
            for (IEntity unifiedStartEntity : unifiedNodeStartEntities) {
                LogicalNode nonUnifiedlogicalNode = nonUnifiedlogicalGraph.getNode(unifiedStartEntity.getId());
                for (XId targetId : nonUnifiedlogicalNode.getTargetIds()) {
                    for (LogicalLink logicalLink : nonUnifiedlogicalNode.getLinks(targetId)) {
                        unifiedLogicalNode.indexLink(unifiedLogicalGraph, logicalLink);
                    }
                }
                for (Map.Entry entry : nonUnifiedlogicalNode.getJsonAtts().getKeyValueEntrySet()) {
                    unifiedJsonAtts.index(entry.getKey(), entry.getValue());
                }
                for (String key : unifiedJsonAtts.keySet()) {
                    IEntrySet entry = unifiedJsonAtts.lookup((Object)key);
                    Set set = entry.toSet();
                    if (set.size() != 1) continue;
                    JON value = (JON)set.iterator().next();
                    unifiedLogicalNode.getJsonAtts().putJON(key, new JON[]{value});
                }
            }
        }
        VisualGraph visualGraph = new VisualGraph(unifiedLogicalGraph);
        for (LogicalNode unifiedLogicalNode : unifiedLogicalGraph.getNodes()) {
        }
        for (LogicalNode unifiedLogicalNode : unifiedLogicalGraph.getNodes()) {
            for (XId nonUnifiedTargetId : unifiedLogicalNode.getTargetIds()) {
                Object set = null;
                HashSet<XId> equivalentTargets = new HashSet<XId>();
                equivalentTargets.add(nonUnifiedTargetId);
                if (set != null) {
                    equivalentTargets.addAll(set.toSet());
                }
                for (XId targetId : equivalentTargets) {
                    if (log.isTraceEnabled()) {
                        log.trace("  SELECT " + unifiedLogicalNode.getBaseEntity() + "->" + targetId);
                    }
                    LogicalLink bestLink = null;
                    double bestPreference = 0.0;
                    Set<LogicalLink> links = unifiedLogicalNode.getLinks(targetId);
                    for (LogicalLink logicalLink : links) {
                        boolean betterPref;
                        ITriple<XId, XId, XId> logicalTriple;
                        if (log.isTraceEnabled()) {
                            log.trace("INSPECT " + logicalLink);
                        }
                        if (((XId)(logicalTriple = logicalLink.asTriple()).p()).equals(CDS.INSTANCE.sameAs)) {
                            if (!log.isDebugEnabled()) continue;
                            log.debug("Skipping already interpreted link (sameAs) " + logicalLink);
                            continue;
                        }
                        if (MyBases.containsSubTypeTriple((IMyBase)myBase, logicalTriple, unifiedLogicalNode.getTripleIndex())) {
                            if (!log.isDebugEnabled()) continue;
                            log.debug("Skipping redundant link " + logicalLink);
                            continue;
                        }
                        if (((XId)logicalTriple.s()).equals(logicalTriple.o())) {
                            if (!log.isInfoEnabled()) continue;
                            log.info("Skipping self-link " + logicalLink);
                            continue;
                        }
                        double pref = VisualGraphs.getRelationPreference((XId)logicalTriple.p());
                        boolean betterType = bestLink != null && bestLink.getLinkBaseType() == LinkBaseType.InferredTriple && logicalLink.getLinkBaseType() != LinkBaseType.InferredTriple;
                        boolean bl = betterPref = pref > bestPreference;
                        if (!betterType && !betterPref) continue;
                        bestLink = logicalLink;
                        bestPreference = pref;
                    }
                    if (bestLink == null) continue;
                    if (log.isTraceEnabled()) {
                        log.trace("  >> BEST " + bestLink);
                    }
                    IVisualNode source = visualGraph.getVisualByLogicalNode(bestLink.getStart());
                    IVisualNode target = visualGraph.getVisualByLogicalNode(bestLink.getEnd());
                    if (source == null || target == null) continue;
                    assert (source != null);
                    assert (target != null);
                    IVisualLink visualLink = VisualFactory.createVisualLink(visualGraph, bestLink, source, target, bestLink.getJsonAtts());
                    visualGraph.addLink(visualLink);
                }
            }
        }
        for (XId logicalCentralNodeId : nonUnifiedlogicalGraph.getCentralNodes()) {
            LogicalNode logicalCentralNode = nonUnifiedlogicalGraph.getNode(logicalCentralNodeId);
            IVisualNode visualNode = visualGraph.getVisualByLogicalNode(logicalCentralNode);
            if (visualNode == null) continue;
            visualGraph.getCentralNodes().add(visualNode);
        }
        return visualGraph;
    }

    static {
        relationPreferenceMap.put((XId)CDS.INSTANCE.hasType, 0.5);
        relationPreferenceMap.put((XId)CDS.INSTANCE.hasInstance, 0.49);
        relationPreferenceMap.put((XId)CDS.INSTANCE.hasSubType, 0.48);
        relationPreferenceMap.put((XId)CDS.INSTANCE.hasSuperType, 0.47);
        relationPreferenceMap.put((XId)CDS.INSTANCE.hasPart, 0.46);
        relationPreferenceMap.put((XId)CDS.INSTANCE.isPartOf, 0.45);
        relationPreferenceMap.put((XId)CDS.INSTANCE.hasTag, 0.44);
        relationPreferenceMap.put((XId)CDS.INSTANCE.hasTagMember, 0.43);
        relationPreferenceMap.put((XId)CDS.INSTANCE.hasAnnotation, 0.42);
        relationPreferenceMap.put((XId)CDS.INSTANCE.hasAnnotationMember, 0.41);
        relationPreferenceMap.put((XId)CDS.INSTANCE.hasDetail, 0.4);
        relationPreferenceMap.put((XId)CDS.INSTANCE.hasContext, 0.39);
        relationPreferenceMap.put((XId)CDS.INSTANCE.hasBefore, 0.38);
        relationPreferenceMap.put((XId)CDS.INSTANCE.hasAfter, 0.37);
        relationPreferenceMap.put((XId)CDS.INSTANCE.hasTarget, 0.36);
        relationPreferenceMap.put((XId)CDS.INSTANCE.hasSource, 0.35);
        relationPreferenceMap.put((XId)CDS.INSTANCE.hasManualLinkTarget, 0.34);
        relationPreferenceMap.put((XId)CDS.INSTANCE.hasManualLinkSource, 0.33);
        relationPreferenceMap.put((XId)CDS.INSTANCE.hasAutoLinkTarget, 0.32);
        relationPreferenceMap.put((XId)CDS.INSTANCE.hasAutoLinkSource, 0.31);
        relationPreferenceMap.put((XId)CDS.INSTANCE.hasAlias, 0.5);
        relationPreferenceMap.put((XId)CDS.INSTANCE.hasInverse, 0.5);
        relationPreferenceMap.put((XId)CDS.INSTANCE.hasSimilar, 0.5);
        relationPreferenceMap.put((XId)CDS.INSTANCE.isAliasOf, 0.5);
        relationPreferenceMap.put((XId)CDS.INSTANCE.replacedBy, 0.5);
        relationPreferenceMap.put((XId)CDS.INSTANCE.replaces, 0.5);
        relationPreferenceMap.put((XId)CDS.INSTANCE.sameAs, 0.1);
        relationPreferenceMap.put((XId)CDS.INSTANCE.hasRelated, 0.05);
    }
}

