/*
 * Decompiled with CFR 0.152.
 */
package org.xydra.server.rest.log;

import java.util.logging.Handler;
import javax.servlet.http.HttpServletResponse;
import org.xydra.log.api.Logger;
import org.xydra.log.api.LoggerFactory;
import org.xydra.restless.Restless;
import org.xydra.restless.RestlessParameter;
import org.xydra.server.rest.XydraRestServer;

public class LogTestResource {
    static Logger log = LoggerFactory.getLogger(LogTestResource.class);

    public static void restless(Restless restless, String prefix) {
        restless.addGet(prefix + "/logtest", LogTestResource.class, "init", new RestlessParameter[0]);
    }

    public void init(HttpServletResponse res) {
        LogTestResource.log();
        String result = "result: ";
        java.util.logging.Logger julLog = java.util.logging.Logger.getLogger("dummy");
        for (Handler handler : julLog.getHandlers()) {
            result = result + " HANDLER " + handler.getClass().getName();
        }
        java.util.logging.Logger parent = julLog.getParent();
        for (int depth = 0; parent != null && depth < 10; ++depth) {
            for (Handler handler : parent.getHandlers()) {
                result = result + " PARENT-HANDLER " + handler.getClass().getName();
            }
            parent = julLog.getParent();
        }
        XydraRestServer.textResponse(res, 200, result);
    }

    public static void log() {
        log.trace("this is trace");
        log.debug("this is debug");
        log.info("this is info");
        log.warn("this is warn");
        log.error("this is error");
        System.out.println("this is sysout");
        System.err.println("this is syserr");
        System.err.println("Log is traceEnabled? " + log.isTraceEnabled());
        System.err.println("Log is debugEnabled? " + log.isDebugEnabled());
        System.err.println("Log is infoEnabled? " + log.isInfoEnabled());
        System.err.println("Log is warnEnabled? " + log.isWarnEnabled());
        System.err.println("Log is errorEnabled? " + log.isErrorEnabled());
    }

    public static void main(String[] args) {
        LogTestResource.log();
    }
}

