/*
 * Decompiled with CFR 0.152.
 */
package org.xydra.server.rest;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.xydra.log.api.Logger;
import org.xydra.log.api.LoggerFactory;
import org.xydra.restless.Restless;
import org.xydra.restless.RestlessExceptionHandler;
import org.xydra.restless.RestlessParameter;
import org.xydra.restless.utils.Delay;
import org.xydra.server.XydraServerApp;
import org.xydra.server.rest.XAccessExceptionHandler;
import org.xydra.server.rest.XydraStoreResource;
import org.xydra.server.rest.log.LogTestResource;
import org.xydra.store.InternalStoreException;
import org.xydra.store.XydraStore;

public class XydraRestServer {
    private static final Logger log = LoggerFactory.getLogger(XydraRestServer.class);
    public static final String INIT_PARAM_XYDRASTORE = "org.xydra.store";
    public static final String INIT_PARAM_SERVER_APP = "org.xydra.server.app";
    public static final String INIT_PARAM_DELAY = "org.xydra.server.util.delay";
    public static final String SERVLET_CONTEXT_ATTRIBUTE_XYDRASTORE = "org.xydra.store";
    public static final String SERVLET_CONTEXT_ATTRIBUTE_XYDRASERVERAPP = "org.xydra.server.app";
    public static final String SERVLET_CONTEXT_ATTRIBUTE_XYDRA_PERSISTENCE = "org.xydra.persistence";

    public static XydraStore getStore(Restless restless) {
        XydraStore store = XydraRestServer.getXydraStoreInternal(restless);
        if (store == null) {
            throw new InternalStoreException("XydraRestServer not initialized - store not found in servlet context");
        }
        return store;
    }

    private static XydraStore getXydraStoreInternal(Restless restless) {
        return (XydraStore)restless.getServletContext().getAttribute("org.xydra.store");
    }

    public static void setXydraStoreInServletContext(Restless restless, XydraStore store) {
        restless.getServletContext().setAttribute("org.xydra.store", (Object)store);
    }

    public static void setXydraServerAppInServletContext(Restless restless, XydraServerApp serverApp) {
        restless.getServletContext().setAttribute("org.xydra.server.app", (Object)serverApp);
    }

    public static XydraServerApp getXydraServerApp(Restless restless) {
        return (XydraServerApp)restless.getServletContext().getAttribute("org.xydra.server.app");
    }

    public static void restless(Restless restless, String prefix) {
        log.info("Booting XydraRestServer");
        XydraRestServer.xydraV1(restless, prefix);
    }

    private static void xydraV1(Restless restless, String prefix) {
        XydraRestServer.initializeServer(restless);
        restless.addExceptionHandler((RestlessExceptionHandler)new XAccessExceptionHandler());
        String storePrefix = prefix + "/store/v1";
        XydraStoreResource.restless(restless, storePrefix);
        restless.addMethod(prefix + "/ping", "GET", XydraRestServer.class, "ping", false, new RestlessParameter[0]);
        LogTestResource.restless(restless, prefix);
    }

    public static synchronized void initializeServer(Restless restless) throws RuntimeException {
        if (XydraRestServer.getXydraStoreInternal(restless) != null) {
            return;
        }
        String storeClassName = restless.getInitParameter("org.xydra.store");
        if (storeClassName == null) {
            throw new RuntimeException("no xydra store backend configured in web.xml. Set param 'org.xydra.store' to the classname of a XydraStore impl.");
        }
        try {
            Class<?> storeClass = Class.forName(storeClassName);
            Constructor<?> cons = storeClass.getConstructor(new Class[0]);
            if (!XydraStore.class.isAssignableFrom(storeClass)) {
                throw new RuntimeException(storeClass.getClass() + " is not a XydraStore");
            }
            XydraStore storeInstance = (XydraStore)cons.newInstance(new Object[0]);
            XydraRestServer.setXydraStoreInServletContext(restless, storeInstance);
            log.info("XydraStore instance stored in servletContext at key 'org.xydra.store'");
        }
        catch (InvocationTargetException e) {
            log.error("Could no start XydraStore: '" + storeClassName + "'", (Throwable)e);
        }
        catch (InstantiationException e) {
            log.error("Could no start XydraStore: '" + storeClassName + "'", (Throwable)e);
        }
        catch (IllegalAccessException e) {
            log.error("Could no start XydraStore due to IllegalAccessException", (Throwable)e);
        }
        catch (NoSuchMethodException e) {
            log.error("Could no start XydraStore: '" + storeClassName + "' seems to be a broken implementation", (Throwable)e);
        }
        catch (ClassNotFoundException e) {
            log.error("XydraStore is malconfigured: '" + storeClassName + "'", (Throwable)e);
        }
        String serverAppClassName = restless.getInitParameter("org.xydra.server.app");
        if (serverAppClassName != null) {
            try {
                Class<?> storeClass = Class.forName(serverAppClassName);
                Constructor<?> cons = storeClass.getConstructor(new Class[0]);
                if (!XydraServerApp.class.isAssignableFrom(storeClass)) {
                    throw new RuntimeException(storeClass.getClass() + " is not a XydraServerApp");
                }
                XydraServerApp serverAppInstance = (XydraServerApp)cons.newInstance(new Object[0]);
                XydraRestServer.setXydraServerAppInServletContext(restless, serverAppInstance);
                log.info("XydraServerApp instance stored in servletContext at key 'org.xydra.server.app'");
            }
            catch (InvocationTargetException e) {
                log.error("Could no start XydraServerApp: '" + serverAppClassName + "'", (Throwable)e);
            }
            catch (InstantiationException e) {
                log.error("Could no start XydraServerApp: '" + serverAppClassName + "'", (Throwable)e);
            }
            catch (IllegalAccessException e) {
                log.error("Could no start XydraServerApp due to IllegalAccessException", (Throwable)e);
            }
            catch (NoSuchMethodException e) {
                log.error("Could no start XydraServerApp: '" + serverAppClassName + "' seems to be a broken implementation", (Throwable)e);
            }
            catch (ClassNotFoundException e) {
                log.error("XydraServerApp is malconfigured: '" + serverAppClassName + "'", (Throwable)e);
            }
        } else {
            log.debug("no XydraServerApp configured in web.xml. Set <org.xydra.server.app> to the classname of a XydraStore impl.");
        }
        String simulateDelay = restless.getInitParameter(INIT_PARAM_DELAY);
        if (simulateDelay == null || simulateDelay.equals(new String("false"))) {
            Delay.setAjaxDelayMs((int)0);
        } else {
            int msDelay = Integer.parseInt(simulateDelay);
            Delay.setAjaxDelayMs((int)msDelay);
        }
    }

    public static void ping(HttpServletResponse res) throws IOException {
        res.setStatus(200);
        res.setContentType("text/plain");
        res.setCharacterEncoding("utf-8");
        OutputStreamWriter w = new OutputStreamWriter((OutputStream)res.getOutputStream(), "utf-8");
        w.write("Running. Server time = " + System.currentTimeMillis());
        ((Writer)w).flush();
        ((Writer)w).close();
    }

    public static void textResponse(HttpServletResponse res, int statusCode, String xml) {
        XydraRestServer.response(res, "text/plain; charset=UTF-8", statusCode, xml);
    }

    public static void response(HttpServletResponse res, String contentType, int statusCode, String xml) {
        res.setContentType(contentType);
        res.setStatus(statusCode);
        try {
            new OutputStreamWriter((OutputStream)res.getOutputStream(), "utf-8").write(xml);
        }
        catch (IOException ioe) {
            throw new RuntimeException("IOException while sending response", ioe);
        }
    }

    public static String readPostData(HttpServletRequest req) {
        try {
            int read;
            BufferedReader in = req.getReader();
            char[] buffer = new char[65536];
            StringBuilder out = new StringBuilder();
            do {
                if ((read = ((Reader)in).read(buffer, 0, buffer.length)) <= 0) continue;
                out.append(buffer, 0, read);
            } while (read >= 0);
            return out.toString();
        }
        catch (IOException ioe) {
            throw new RuntimeException("IOException while reading POSTed data", ioe);
        }
    }
}

