/*
 * Decompiled with CFR 0.152.
 */
package com.calpano.common.client.view.forms.validation.impl;

import com.calpano.common.client.view.forms.IHtml5TextInput;
import com.calpano.common.client.view.forms.StaticFormManager;
import com.calpano.common.client.view.forms.Tooltip;
import com.calpano.common.client.view.forms.validation.InvalidationEvent;
import com.calpano.common.client.view.forms.validation.InvalidationHandler;
import com.calpano.common.client.view.forms.validation.ValidationEvent;
import com.calpano.common.client.view.forms.validation.ValidationHandler;
import com.calpano.common.client.view.resources.CommonResourceBundle;
import com.calpano.common.shared.validation.ValidationMessage;
import com.google.gwt.event.logical.shared.ValueChangeEvent;
import com.google.gwt.event.logical.shared.ValueChangeHandler;
import com.google.gwt.safehtml.shared.SafeHtmlUtils;
import com.google.gwt.user.client.Event;
import com.google.gwt.user.client.ui.Widget;
import com.google.web.bindery.event.shared.HandlerRegistration;
import org.xydra.log.api.Logger;
import org.xydra.log.api.LoggerFactory;

public class ShowValidationMessageHelper
implements ValidationHandler,
InvalidationHandler {
    private static final Logger log = LoggerFactory.getLogger(ShowValidationMessageHelper.class);
    private final IHtml5TextInput source;
    private Tooltip tooltip;
    private HandlerRegistration reg;

    public ShowValidationMessageHelper(IHtml5TextInput source) {
        this.source = source;
        CommonResourceBundle.INSTANCE.css().ensureInjected();
    }

    public int getEventsToSink() {
        return 0;
    }

    private boolean hasTooltip() {
        return this.tooltip != null;
    }

    private void hideValidationTooltip() {
        if (this.tooltip != null) {
            this.tooltip.hideTooltip();
            this.tooltip = null;
        }
    }

    private void showValidationTooltip() {
        ValidationMessage vmsg = this.source.computeValidation();
        String msg = vmsg.message;
        if (!this.hasTooltip()) {
            String fullMsg = StaticFormManager.getStringTransformer().transform(msg);
            this.tooltip = new Tooltip().setHtml(SafeHtmlUtils.fromSafeConstant((String)fullMsg)).setPosition(Tooltip.TooltipPosition.BELOW_LEFT).attachTo((Widget)this.source.getTextBoxBase());
            this.tooltip.addStyleName(CommonResourceBundle.INSTANCE.css().validationTooltip());
            this.tooltip.showTooltipDelayed(30);
        }
    }

    private void hideBoth() {
        this.hideValidationTooltip();
        this.removeCssClassForWarning();
    }

    private void showBoth() {
        this.addCssClassForWarning();
        this.showValidationTooltip();
    }

    private void removeCssClassForWarning() {
        CommonResourceBundle.INSTANCE.css().ensureInjected();
        this.source.getTextBoxBase().removeStyleName(CommonResourceBundle.INSTANCE.css().invalid());
    }

    private void addCssClassForWarning() {
        CommonResourceBundle.INSTANCE.css().ensureInjected();
        this.source.getTextBoxBase().addStyleName(CommonResourceBundle.INSTANCE.css().invalid());
    }

    public void onBrowserEvent(Event event) {
    }

    @Override
    public void onInvalid(InvalidationEvent event) {
        log.debug("'" + this.source.getRawText() + "' = invalid");
        this.updateValidationWarnings();
    }

    @Override
    public void onValid(ValidationEvent event) {
        log.debug("'" + this.source.getRawText() + "' = valid");
        this.updateValidationWarnings();
    }

    public void deactivateValidationWarnings() {
        if (this.reg != null) {
            this.reg.removeHandler();
            this.reg = null;
        }
        this.hideBoth();
    }

    public void activateValidationWarnings() {
        log.trace("activated validation warnings");
        this.updateValidationWarnings();
        this.reg = this.source.getTextBoxBase().addValueChangeHandler((ValueChangeHandler)new ValueChangeHandler<String>(){

            public void onValueChange(ValueChangeEvent<String> event) {
                ShowValidationMessageHelper.this.updateValidationWarnings();
            }
        });
    }

    private void updateValidationWarnings() {
        ValidationMessage vmsg = this.source.computeValidation();
        if (vmsg.level.isValid()) {
            this.hideBoth();
        } else {
            this.showBoth();
        }
    }

    public void reset() {
        this.deactivateValidationWarnings();
    }

    public void onBeforeRemoveFromParent() {
        this.hideValidationTooltip();
    }
}

