/*
 * Decompiled with CFR 0.152.
 */
package com.calpano.common.client.view.forms.activation;

import com.calpano.common.client.ClientApp;
import com.calpano.common.client.view.forms.activation.ActivationEvent;
import com.calpano.common.client.view.forms.activation.ActivationHandler;
import com.calpano.common.client.view.forms.activation.DeactivationEvent;
import com.calpano.common.client.view.forms.activation.DeactivationHandler;
import com.calpano.common.client.view.forms.activation.HasActivationHandlers;
import com.calpano.common.client.view.forms.activation.HasDeactivationHandlers;
import com.calpano.common.client.view.forms.placeholder.impl.H5Placeholder;
import com.calpano.common.client.view.forms.utils.FocusUtils;
import com.google.gwt.event.logical.shared.ValueChangeEvent;
import com.google.gwt.event.logical.shared.ValueChangeHandler;
import com.google.gwt.user.client.DOM;
import com.google.gwt.user.client.Event;
import com.google.gwt.user.client.ui.TextBoxBase;
import com.google.web.bindery.event.shared.HandlerRegistration;
import org.xydra.log.api.Logger;
import org.xydra.log.api.LoggerFactory;

public class H5Activation<T extends TextBoxBase>
extends H5Placeholder<T>
implements HasActivationHandlers,
HasDeactivationHandlers,
ValueChangeHandler<String> {
    private static final Logger log = LoggerFactory.getLogger(H5Activation.class);
    private static final int ACTIVATION_DEACTIVATION_EVENTS = 4993;
    private State lastFired = null;

    public H5Activation(T base, boolean simulatePlaceholder) {
        super(base, simulatePlaceholder);
        this.getTextBoxBase().addValueChangeHandler((ValueChangeHandler)this);
    }

    @Override
    public int getEventsToSink() {
        return super.getEventsToSink() | 0x1381;
    }

    public void onValueChange(ValueChangeEvent<String> event) {
        this.fireActivated(this.getTextBoxBase(), null);
    }

    @Override
    public void onBrowserEvent(Event event) {
        if (log.isTraceEnabled()) {
            log.trace("H5Activ event " + event.getType());
        }
        super.onBrowserEvent(event);
        int eventType = DOM.eventGetType((Event)event);
        switch (eventType) {
            case 1: 
            case 2: 
            case 524288: {
                this.fireActivated(this.getTextBoxBase(), event);
                break;
            }
            case 4096: {
                this.fireDeactivated(this.getTextBoxBase(), event);
            }
        }
    }

    @Override
    public void onLoad() {
        super.onLoad();
    }

    @Override
    protected void reset() {
        super.reset();
        FocusUtils.setFocus(this.getTextBoxBase(), false);
        this.fireDeactivated(this.getTextBoxBase(), null);
        this.lastFired = null;
    }

    @Override
    public HandlerRegistration addActivationHandler(ActivationHandler handler) {
        return ClientApp.getEventBus().addHandlerToSource(ActivationEvent.TYPE, this.getTextBoxBase(), (Object)handler);
    }

    @Override
    public HandlerRegistration addDeactivationHandler(DeactivationHandler handler) {
        return ClientApp.getEventBus().addHandlerToSource(DeactivationEvent.TYPE, this.getTextBoxBase(), (Object)handler);
    }

    protected void fireActivated(Object source, Event cause) {
        if (this.lastFired == State.Activated) {
            return;
        }
        if (log.isTraceEnabled()) {
            log.trace("ACTIVATED " + source);
        }
        ClientApp.getEventBus().fireEventFromSource((com.google.web.bindery.event.shared.Event)new ActivationEvent(source, cause), source);
        this.lastFired = State.Activated;
    }

    protected void fireDeactivated(Object source, Event cause) {
        if (this.lastFired != State.Activated) {
            return;
        }
        if (log.isTraceEnabled()) {
            log.trace("DEACTIVATED " + source);
        }
        ClientApp.getEventBus().fireEventFromSource((com.google.web.bindery.event.shared.Event)new DeactivationEvent(source, cause), (Object)this);
        this.lastFired = State.Deactivated;
    }

    public static enum State {
        Activated,
        Deactivated;

    }
}

