/*
 * Decompiled with CFR 0.152.
 */
package com.calpano.common.client.view.forms;

import com.calpano.common.client.view.forms.Html5DomUtil;
import com.google.gwt.core.client.Scheduler;
import com.google.gwt.user.client.ui.FocusWidget;
import com.google.gwt.user.client.ui.Widget;
import org.xydra.log.api.Logger;
import org.xydra.log.api.LoggerFactory;

public class AutofocusManager {
    private static final Logger log = LoggerFactory.getLogger(AutofocusManager.class);
    private static FocusWidget autoFocusWidget;
    private static final String FOCUS_NONE = "focus-none";

    public static void setAutofocusWidget(FocusWidget focusWidget) {
        if (autoFocusWidget != null) {
            throw new IllegalStateException("Existing autofocus widget of type '" + autoFocusWidget.getClass().getName() + "' found. Only one can have autofocus.");
        }
        autoFocusWidget = focusWidget;
        Html5DomUtil.setPropertyBoolean((Widget)autoFocusWidget, "autofocus", true);
    }

    public static FocusWidget getAutofocusWidget() {
        return autoFocusWidget;
    }

    public static boolean isAutofocus(FocusWidget focusWidget) {
        return focusWidget == autoFocusWidget;
    }

    public static void removeAutofocusWidget() {
        autoFocusWidget = null;
    }

    public static void simulateAutofocus() {
        Scheduler.get().scheduleDeferred(new Scheduler.ScheduledCommand(){

            public void execute() {
                AutofocusManager.simulateAutofocusNow();
            }
        });
    }

    public static void simulateAutofocusNow() {
        if (autoFocusWidget == null) {
            AutofocusManager.setFocusToNone();
        } else {
            log.info("Autofocus on " + autoFocusWidget);
            autoFocusWidget.setFocus(true);
        }
    }

    public static void setFocusToNone() {
        log.info("Setting focus to none");
    }

    public void setAutofocus(FocusWidget focusWidget, String attributeValue) {
        if (attributeValue.equals("autofocus") || attributeValue.equals("")) {
            AutofocusManager.setAutofocusWidget(focusWidget);
        }
    }

    public static void setAutofocusWidget(FocusWidget focusWidget, boolean autofocus) {
        if (autofocus) {
            AutofocusManager.setAutofocusWidget(focusWidget);
        } else if (AutofocusManager.isAutofocus(focusWidget)) {
            AutofocusManager.removeAutofocusWidget();
        }
    }
}

