/*
 * Decompiled with CFR 0.152.
 */
package com.calpano.common.client.storage;

import com.google.gwt.storage.client.Storage;
import org.xydra.annotations.Setting;
import org.xydra.log.api.Logger;
import org.xydra.log.api.LoggerFactory;

public abstract class GenericStorage<T> {
    @Setting(value="Compile time flag to test absence")
    public static final boolean ENABLED = true;
    private static final Logger log = LoggerFactory.getLogger(GenericStorage.class);
    private static Storage storage = GenericStorage.getLocalStorageIfSupported();

    public static void clearAllLocalStorage() {
        Storage storage = GenericStorage.getLocalStorageIfSupported();
        if (storage != null) {
            storage.clear();
            log.info("Local storage cleared");
        }
    }

    public static boolean isLocalStorageSupported() {
        return storage != null;
    }

    public static Storage getLocalStorageIfSupported() {
        log.debug("Probing for localStorage support...");
        try {
            Storage storage = Storage.getLocalStorageIfSupported();
            log.debug("Probing for localStorage support " + (storage == null ? "negative" : "positive"));
            return storage;
        }
        catch (Throwable t) {
            log.warn("Got exception when trying to detect localStorage", t);
            log.debug("Probing for localStorage support negative");
            return null;
        }
    }

    public void store(String key, T object) {
        if (storage == null) {
            log.info("LocalStorage is not supported by Client.");
        } else {
            String data = this.serialize(object);
            try {
                storage.removeItem(key);
                storage.setItem(key, data);
            }
            catch (Exception e) {
                log.warn("Exception in localStorage. Serialized attribute object<T> may be too large, length was " + data.length());
                log.warn(e.toString());
            }
        }
    }

    public T get(String key) {
        if (storage == null) {
            log.info("LocalStorage is not supported by client.");
            return null;
        }
        String data = storage.getItem(key);
        if (data == null) {
            log.info("Key " + key + " not found in localStorage.");
            return null;
        }
        T object = this.deserialize(data);
        return object;
    }

    public void clear() {
        if (storage != null) {
            storage.clear();
        }
    }

    public void removeItem(String key) {
        if (storage != null) {
            storage.removeItem(key);
        }
    }

    protected abstract String serialize(T var1);

    protected abstract T deserialize(String var1);
}

