/*
 * Decompiled with CFR 0.152.
 */
package com.calpano.common.client.data;

import com.calpano.common.client.data.DataManager;
import com.calpano.common.shared.data.DataEvent;
import com.calpano.common.shared.data.DataEventCondition;
import com.google.web.bindery.event.shared.Event;
import com.google.web.bindery.event.shared.EventBus;
import com.google.web.bindery.event.shared.HandlerRegistration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.xydra.base.id.UUID;
import org.xydra.log.api.Logger;
import org.xydra.log.api.LoggerFactory;

class DataEventWatcher
implements DataEvent.DataEventHandler {
    private static final Logger log = LoggerFactory.getLogger(DataEventWatcher.class);
    private final DataManager.AllEventsOccuredCallback callback;
    private final ArrayList<DataEventCondition> conditions;
    private final String debugID = UUID.uuid((int)4);
    private final Map<Event.Type<DataEvent.DataEventHandler<?>>, List<DataEventCondition>> eventTypeAwaitedConditionsMap;
    private final Map<Event.Type<DataEvent.DataEventHandler<?>>, HandlerRegistration> eventTypeHandlerRegistrationMap;

    public static synchronized void watch(EventBus eventBus, DataManager.AllEventsOccuredCallback callback, DataEventCondition ... eventConditions) {
        DataEventWatcher dew = new DataEventWatcher(callback, eventConditions);
        dew.startWatching(eventBus);
    }

    private DataEventWatcher(DataManager.AllEventsOccuredCallback callback, DataEventCondition ... eventConditions) {
        this.conditions = new ArrayList<DataEventCondition>(Arrays.asList(eventConditions));
        this.eventTypeAwaitedConditionsMap = new HashMap();
        this.eventTypeHandlerRegistrationMap = new HashMap();
        this.callback = callback;
    }

    private synchronized boolean allEventsOccured() {
        return this.eventTypeAwaitedConditionsMap.isEmpty();
    }

    public synchronized void onData(DataEvent event) {
        log.debug(this.debugID + " onData " + event);
        List<DataEventCondition> eventConditionsForType = this.eventTypeAwaitedConditionsMap.get(event.getAssociatedType());
        if (eventConditionsForType == null) {
            log.debug(this.debugID + " eventConditionsForType is null, this watcher does not care about the event type anymore.");
            return;
        }
        log.debug(this.debugID + " eventConditionsForType " + eventConditionsForType);
        Iterator<DataEventCondition> it = eventConditionsForType.iterator();
        while (it.hasNext()) {
            DataEventCondition condition = it.next();
            if (!condition.matches(event)) continue;
            log.debug(this.debugID + " removing matching condition " + condition);
            it.remove();
        }
        if (eventConditionsForType.isEmpty()) {
            log.debug(this.debugID + " eventConditionsForType is empty now.");
            this.eventTypeAwaitedConditionsMap.remove(event.getAssociatedType());
            HandlerRegistration reg = this.eventTypeHandlerRegistrationMap.remove(event.getAssociatedType());
            reg.removeHandler();
        }
        if (this.allEventsOccured()) {
            log.debug(this.debugID + " eventTypeAwaitedConditionsMap is empty now. (all conditions met)");
            this.callback.onAllEventsOccured();
        }
    }

    private void startWatching(EventBus eventBus) {
        for (DataEventCondition eventCondition : this.conditions) {
            Event.Type type = eventCondition.getAssociatedType();
            if (!this.eventTypeAwaitedConditionsMap.containsKey(type)) {
                this.eventTypeAwaitedConditionsMap.put(type, new ArrayList());
            }
            this.eventTypeAwaitedConditionsMap.get(type).add(eventCondition);
            if (this.eventTypeHandlerRegistrationMap.containsKey(type)) continue;
            this.eventTypeHandlerRegistrationMap.put(type, eventBus.addHandler(eventCondition.getAssociatedType(), (Object)this));
        }
    }

    public synchronized void unwatch() {
        Iterator<Event.Type<DataEvent.DataEventHandler<?>>> it = this.eventTypeHandlerRegistrationMap.keySet().iterator();
        while (it.hasNext()) {
            Event.Type<DataEvent.DataEventHandler<?>> type = it.next();
            HandlerRegistration reg = this.eventTypeHandlerRegistrationMap.get(type);
            reg.removeHandler();
            it.remove();
        }
        this.eventTypeHandlerRegistrationMap.clear();
        this.eventTypeAwaitedConditionsMap.clear();
    }
}

