/*
 * Decompiled with CFR 0.152.
 */
package com.calpano.common.client.crashreport;

import com.calpano.common.client.ClientApp;
import com.calpano.common.client.crashreport.ClientExceptionHandler;
import com.calpano.common.client.util.ClientUrl;
import com.google.gwt.http.client.Request;
import com.google.gwt.http.client.RequestBuilder;
import com.google.gwt.http.client.RequestCallback;
import com.google.gwt.http.client.RequestException;
import com.google.gwt.http.client.Response;
import com.google.gwt.user.client.Window;
import de.xam.p13n.shared.time.TimeProvider;
import org.xydra.env.IEnvironment;
import org.xydra.log.api.Logger;
import org.xydra.log.api.LoggerFactory;

public class ClientErrorHandlingUtils {
    private static final Logger log = LoggerFactory.getLogger(ClientErrorHandlingUtils.class);

    public static boolean handleError(IEnvironment env, final String msg, final String jsUrl, final String line, String consoleLogs) {
        long timestamp = TimeProvider.getCurrentTimeInMillis();
        log.info("Sending error report ...");
        ClientUrl cu = ClientUrl.fromCurrentLocation();
        cu.setPath("/clientError/" + timestamp);
        ClientUrl q = ClientUrl.fromCurrentLocation();
        q.setQueryString("");
        q.setHash("");
        if (msg != null) {
            q.addQueryParamAndEncodeValue("msg", msg);
        }
        if (jsUrl != null) {
            q.addQueryParamAndEncodeValue("jsUrl", jsUrl);
        }
        if (line != null) {
            q.addQueryParamAndEncodeValue("line", line);
        }
        String docUrl = Window.Location.getHref();
        q.addQueryParamAndEncodeValue("docUrl", docUrl);
        q.addQueryParamAndEncodeValue("consoleLogs", consoleLogs);
        RequestBuilder rb = new RequestBuilder(RequestBuilder.POST, cu.toString());
        rb.setHeader("Content-Type", "application/x-www-form-urlencoded");
        rb.setTimeoutMillis(60000);
        rb.setRequestData(q.getQueryString());
        rb.setCallback(new RequestCallback(){

            public void onResponseReceived(Request request, Response response) {
                log.info("Client-side error logged on server");
            }

            public void onError(Request request, Throwable exception) {
                log.warn("Failed to log client-side error on server. Retrying in another way...");
                ClientErrorHandlingUtils.handleErrorRobust(msg, jsUrl, line);
            }
        });
        try {
            rb.send();
        }
        catch (RequestException e) {
            log.warn("Failed to log client-side error on server. Retrying in another way...", (Throwable)e);
            ClientErrorHandlingUtils.handleErrorRobust(msg, jsUrl, line);
        }
        log.info("Rebooting...");
        ClientApp.rebootOnError(env);
        return true;
    }

    public boolean handleError(IEnvironment env, String msg, String jsUrl, String line) {
        String consoleLogs = ClientExceptionHandler.rememberLogListener.getLogs();
        return ClientErrorHandlingUtils.handleError(env, msg, jsUrl, line, consoleLogs);
    }

    public static native boolean handleErrorRobustNative(String var0, String var1, String var2);

    public static boolean handleErrorRobust(String msg, String jsUrl, String line) {
        String shortMsg = msg.substring(0, Math.min(msg.length(), 500)) + "...(truncated)";
        ClientErrorHandlingUtils.handleErrorRobustNative(shortMsg, jsUrl, line);
        return true;
    }
}

