/*
 * Decompiled with CFR 0.152.
 */
package com.calpano.common.client;

import com.calpano.common.client.AppState;
import com.calpano.common.client.ConfParamsCalpanoCommonClient;
import com.calpano.common.client.storage.GenericStorage;
import com.calpano.common.client.util.GwtCookieUtils;
import com.google.gwt.event.logical.shared.CloseEvent;
import com.google.gwt.event.logical.shared.CloseHandler;
import com.google.gwt.user.client.Cookies;
import com.google.gwt.user.client.Window;
import com.google.web.bindery.event.shared.EventBus;
import de.xam.p13n.shared.time.TimeProvider;
import org.xydra.env.Env;
import org.xydra.env.IEnvironment;
import org.xydra.log.api.Logger;
import org.xydra.log.api.LoggerFactory;

public class ClientApp
implements AppState.AppStateListener,
Window.ClosingHandler,
CloseHandler<Window> {
    private static final Logger log = LoggerFactory.getLogger(ClientApp.class);
    private static ClientApp INSTANCE;
    private final IEnvironment env;
    private boolean isConfigSet = false;
    private static final long MILLIS_PER_MINUTE = 60000L;

    public ClientApp(IEnvironment env) {
        this.env = env;
    }

    public static ClientApp get() {
        if (INSTANCE == null) {
            INSTANCE = new ClientApp(Env.get());
        }
        return INSTANCE;
    }

    public static EventBus getEventBus() {
        return (EventBus)ClientApp.get().env().conf().resolve(EventBus.class);
    }

    private IEnvironment env() {
        return this.env;
    }

    public static void reboot() {
        log.info("Refresh");
        Window.Location.reload();
    }

    public static void rebootOnError(IEnvironment env) {
        String rebootCookie = Cookies.getCookie((String)"reboot");
        if (rebootCookie != null) {
            long lastReboot = Long.parseLong(rebootCookie);
            long ago = TimeProvider.getCurrentTimeInMillis() - lastReboot;
            if (ago < 60000L) {
                log.info("App crashed again, dont reboot");
                return;
            }
        }
        GwtCookieUtils.setCookie("reboot", "" + TimeProvider.getCurrentTimeInMillis(), 60L);
        AppState.setStageSilently(AppState.Stage.Bluescreen);
        log.info("Clearing local storage");
        GenericStorage.clearAllLocalStorage();
        ClientApp.reboot();
    }

    @Override
    public void onAppStateChange() {
        this.setConfigurationOnce();
    }

    private void setConfigurationOnce() {
        if (this.isConfigSet) {
            return;
        }
        new ConfParamsCalpanoCommonClient().configureDefaults(this.env.conf());
        this.isConfigSet = true;
    }

    public void onClose(CloseEvent<Window> event) {
    }

    public void onWindowClosing(Window.ClosingEvent event) {
    }
}

