/*
 * Decompiled with CFR 0.152.
 */
package de.xam.tokenpipe.impl;

import de.xam.tokenpipe.IHasUpperTokenSink;
import de.xam.tokenpipe.IToken;
import de.xam.tokenpipe.ITokenPipe;
import de.xam.tokenpipe.ITokenSink;
import de.xam.tokenpipe.ITokenStream;
import de.xam.tokenpipe.ParseException;
import de.xam.tokenpipe.impl.AbstractTokenStream;
import de.xam.tokenpipe.impl.TokenPipeSandbox;
import java.util.Arrays;
import org.xydra.annotations.Setting;
import org.xydra.conf.annotations.RequireConf;
import org.xydra.env.Env;
import org.xydra.index.Factory;
import org.xydra.index.IEntrySet;
import org.xydra.index.IMapSetIndex;
import org.xydra.index.impl.SerializableMapSetIndex;
import org.xydra.index.impl.SmallEntrySetFactory;
import org.xydra.log.api.Logger;
import org.xydra.log.api.LoggerFactory;

@RequireConf(value={"parser-tokenSandbox"})
public final class TokenPipeDriver
extends AbstractTokenStream
implements ITokenStream,
ITokenSink,
IHasUpperTokenSink {
    @Setting(value="token pipe sandbox mode")
    private static final boolean DEBUG = Env.get().conf().getBoolean("parser-tokenSandbox");
    private static final Logger log = LoggerFactory.getLogger(TokenPipeDriver.class);
    private IToken lastProcessedToken;
    private ITokenPipe pipe;
    private final IMapSetIndex<String, String> pipe2processedTokenTypes = new SerializableMapSetIndex((Factory)new SmallEntrySetFactory());
    private final int position;
    private TokenPipeSandbox sandbox = null;
    private ITokenStream stream;
    private long totalTimeSpent = 0L;
    private ITokenSink upperTokenSink;
    private Object parseContext;

    public static void sendTokenToPipe(ITokenStream stream, IToken token, ITokenPipe pipe) {
        pipe.onToken(stream, token);
        if (token.isContent()) {
            int c;
            pipe.onBeforeContentToken(stream, token);
            for (int i = 0; i < token.length(); i += Character.charCount(c)) {
                c = token.getChars().codePointAt(i);
                pipe.onContentCodepoint(stream, c, i, token);
            }
            pipe.onAfterContentToken(stream, token);
        }
    }

    public TokenPipeDriver(ITokenPipe tokenPipe, int position) {
        assert (tokenPipe != null);
        this.position = position;
        if (DEBUG) {
            this.sandbox = new TokenPipeSandbox(tokenPipe, this, position);
            this.pipe = this.sandbox;
            this.stream = this.sandbox;
        } else {
            this.pipe = tokenPipe;
            this.stream = this;
        }
    }

    @Override
    public String[] consumedTokenTypes() {
        return this.pipe.consumedTokenTypes();
    }

    @Override
    public void debug(String msg) {
        if (this.sandbox != null) {
            this.sandbox.debug(msg);
        }
    }

    public void dumpHistory() {
        this.dumpStats();
        if (this.sandbox != null) {
            this.sandbox.dumpHistory();
        }
    }

    public void dumpStats() {
        long total = this.totalTimeSpent / 1000000L;
        System.out.println("Total time spent in layer [" + this.position + "] = " + "" + total + " ms" + " '" + this.getLabel() + "' ");
    }

    public static final void assertTokenType(ITokenPipe pipe, String tokenType) {
        assert (Arrays.asList(pipe.producedTokenTypes()).contains(tokenType)) : "TokenType '" + tokenType + "' produced by [" + pipe.getLabel() + "] but not listed in meta-data";
    }

    @Override
    public void fireToken(IToken token) {
        TokenPipeDriver.assertTokenType(this.pipe, token.getType());
        super.fireToken(token);
        if (this.lastProcessedToken != token) {
            token.setSource(this.lastProcessedToken);
        }
        if (this.sandbox != null) {
            this.sandbox.recordToken(token, "fire");
        }
        try {
            this.upperTokenSink.onToken(token);
        }
        catch (Error | Exception e) {
            this.upperTokenSink.onException(e);
            throw e;
        }
    }

    @Override
    public String getLabel() {
        return this.pipe.getLabel();
    }

    @Override
    public ITokenSink getUpperTokenSink() {
        return this.upperTokenSink;
    }

    @Override
    public void onAfterDocument() {
        try {
            this.upperTokenSink.onAfterDocument();
        }
        catch (Error | Exception e) {
            this.upperTokenSink.onException(e);
            throw e;
        }
        this.pipe.onAfterDocument();
    }

    @Override
    public void onBeforeDocument() {
        super.onBeforeDocument();
        this.pipe.onBeforeDocument();
        try {
            this.upperTokenSink.onBeforeDocument();
        }
        catch (Error | Exception e) {
            this.upperTokenSink.onException(e);
            throw e;
        }
    }

    @Override
    public void onException(Throwable e) {
        this.pipe.onException(e);
        this.upperTokenSink.onException(e);
    }

    @Override
    public void onToken(IToken token) throws ParseException {
        if (this.processes(this.pipe, token)) {
            this.lastProcessedToken = token;
            try {
                long start = System.nanoTime();
                TokenPipeDriver.sendTokenToPipe(this.stream, token, this.pipe);
                long stop = System.nanoTime();
                long delta = stop - start;
                this.totalTimeSpent += delta;
            }
            catch (Exception e) {
                this.upperTokenSink.onException(e);
                throw e;
            }
        } else {
            if (this.sandbox != null) {
                this.sandbox.ignoreAndPassThrough(token);
            }
            this.upperTokenSink.onToken(token);
        }
    }

    private boolean processes(ITokenPipe pipe, IToken token) {
        IEntrySet set = this.pipe2processedTokenTypes.lookup((Object)pipe.getLabel());
        if (set == null) {
            for (String processedTokenType : pipe.consumedTokenTypes()) {
                this.pipe2processedTokenTypes.index((Object)pipe.getLabel(), (Object)processedTokenType);
            }
            set = this.pipe2processedTokenTypes.lookup((Object)pipe.getLabel());
            assert (set != null);
        }
        return set.contains((Object)token.getType());
    }

    @Override
    public String[] producedTokenTypes() {
        return this.pipe.producedTokenTypes();
    }

    @Override
    public void setUpperTokenSink(ITokenSink upperTokenSink) {
        this.upperTokenSink = upperTokenSink;
    }

    public String toString() {
        return "TokenPipeDriver on " + this.pipe.getLabel();
    }

    @Override
    public Object getParseContext() {
        return this.parseContext;
    }

    @Override
    public void setParseContext(Object parseContext) {
        this.parseContext = parseContext;
        if (this.sandbox != null) {
            this.sandbox.setParseContext(parseContext);
        }
    }
}

