/*
 * Decompiled with CFR 0.152.
 */
package de.xam.tokenpipe.impl;

import de.xam.tokenpipe.IToken;
import de.xam.tokenpipe.ITokenStream;
import de.xam.tokenpipe.ParseException;
import java.util.Stack;

public abstract class AbstractTokenStream
implements ITokenStream {
    private Stack<IToken> startTokenStack;

    @Override
    public abstract void debug(String var1);

    @Override
    public void fireToken(IToken token) {
        switch (token.getKind()) {
            case Start: {
                this.startTokenStack.push(token);
                break;
            }
            case Content: {
                break;
            }
            case End: {
                if (token.isEnd()) {
                    IToken startToken = this.getMatchingStartToken(token);
                    assert (startToken.isStart());
                    token.setStartToken(startToken);
                }
                this.startTokenStack.pop();
                break;
            }
        }
    }

    public abstract String getLabel();

    private IToken getMatchingStartToken(IToken token) {
        assert (token.isEnd());
        if (this.startTokenStack.isEmpty()) {
            throw new ParseException("[" + this.getLabel() + "] " + "Fires " + (Object)((Object)token.getKind()) + "-token '" + token.getType() + "' but no start token recorded." + "\nEnd  = " + token.toString(200, false));
        }
        IToken startToken = this.startTokenStack.peek();
        assert (startToken.isStart());
        if (!startToken.getType().equals(token.getType())) {
            throw new ParseException("Have END-'" + token.getType() + "', look for START-'" + token.getType() + "' but found START-'" + startToken.getType() + "' was last opened." + "\nLast Start= " + startToken.toString(200, false) + "\nHave End  = " + token.toString(200, false));
        }
        return startToken;
    }

    @Override
    public Stack<IToken> getStartTokenStack() {
        return this.startTokenStack;
    }

    public void onBeforeDocument() {
        this.startTokenStack = new Stack();
    }
}

