/*
 * Decompiled with CFR 0.152.
 */
package de.xam.tokenpipe;

import de.xam.tokenpipe.IHasReader;
import de.xam.tokenpipe.ITokenPipe;
import de.xam.tokenpipe.ITokenSink;
import de.xam.tokenpipe.ITokenSource;
import de.xam.tokenpipe.impl.LayerParserSource;
import de.xam.tokenpipe.impl.TokenPipeDriver;
import de.xam.tokenpipe.impl.TokenPipeSandbox;
import de.xam.tokenpipe.sink.DebugTokenSink;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.xydra.log.api.Logger;
import org.xydra.log.api.LoggerFactory;

public class TokenPipeStack {
    private static final Logger log = LoggerFactory.getLogger(TokenPipeStack.class);
    private List<TokenPipeDriver> drivers;
    private ITokenSink finalSink;
    private ITokenPipe[] givenPipes;
    private LayerParserSource source;

    public void stack(ITokenSink sink, ITokenPipe ... tokenPipes) {
        this.finalSink = sink;
        this.givenPipes = tokenPipes;
        this.configure(sink, tokenPipes);
    }

    public static void parseBisec(TokenPipeStack stack, IHasReader hasReader) throws IOException {
        for (int i = 0; i < stack.givenPipes.length; ++i) {
            log.warn("000000000 Parsing with first " + i + " pipes");
            stack.finalSink = new DebugTokenSink();
            ITokenPipe[] somePipes = Arrays.copyOf(stack.givenPipes, i);
            stack.configure(stack.finalSink, somePipes);
            Reader reader = hasReader.getReader();
            stack.parse(reader, "parseBisec");
            reader.close();
        }
    }

    private void configure(ITokenSink sink, ITokenPipe ... tokenPipes) {
        this.source = new LayerParserSource();
        this.drivers = new ArrayList<TokenPipeDriver>();
        log.debug("configuring");
        if (tokenPipes != null) {
            for (ITokenPipe pipe : tokenPipes) {
                log.debug("PIPE = " + pipe.getLabel() + "    ");
                TokenPipeDriver driver = new TokenPipeDriver(pipe, this.drivers.size());
                this.drivers.add(driver);
            }
        }
        if (this.drivers.isEmpty()) {
            this.source.setUpperTokenSink(sink);
        } else {
            this.source.setUpperTokenSink(this.drivers.get(0));
            for (int i = 1; i < this.drivers.size(); ++i) {
                TokenPipeDriver lower = this.drivers.get(i - 1);
                TokenPipeDriver current = this.drivers.get(i);
                lower.setUpperTokenSink(current);
            }
            TokenPipeDriver last = this.drivers.get(this.drivers.size() - 1);
            last.setUpperTokenSink(sink);
        }
    }

    public void parse(Reader r, Object parseContext) throws IOException {
        this.source.parse(r, parseContext);
    }

    public ITokenSource getSource() {
        return this.source;
    }

    public void dump() {
        for (TokenPipeDriver driver : this.drivers) {
            List<String> consumed = Arrays.asList(driver.consumedTokenTypes());
            List<String> produced = Arrays.asList(driver.producedTokenTypes());
            ArrayList<String> eaten = new ArrayList<String>();
            eaten.addAll(consumed);
            eaten.removeAll(produced);
            ArrayList<String> invented = new ArrayList<String>();
            invented.addAll(produced);
            invented.removeAll(consumed);
            ArrayList<String> passThrough = new ArrayList<String>();
            passThrough.addAll(consumed);
            passThrough.retainAll(produced);
            System.out.println(eaten + " --" + driver.getLabel() + "--> " + invented + " pass-through: " + passThrough);
        }
    }

    public void dumpConfig(File f) throws IOException {
        String html = "";
        html = html + "<h2>Pipeline</h2>";
        html = html + "<ol>";
        for (TokenPipeDriver driver : this.drivers) {
            File logFile = TokenPipeSandbox.getLogFile(driver);
            html = html + "<li><a href='" + logFile.toURI() + "'>" + driver.getLabel() + "</a></li>";
        }
        html = html + "</ol>";
        FileUtils.writeStringToFile((File)f, (String)html);
    }

    public void dumpHistory() {
        for (TokenPipeDriver d : this.drivers) {
            log.info("__________ " + d.getLabel());
            d.dumpHistory();
        }
    }

    public void dumpStats() {
        for (TokenPipeDriver d : this.drivers) {
            d.dumpStats();
        }
    }
}

