/*
 * Decompiled with CFR 0.152.
 */
package de.xam.memspace;

import de.xam.memspace.IObjectProfileNode;

abstract class ObjectProfileFilters {
    public static IObjectProfileNode.INodeFilter newParentSizeFractionFilter(double threshold) {
        return new ParentSizeFractionFilter(threshold);
    }

    public static IObjectProfileNode.INodeFilter newRankFilter(int rank) {
        return new RankFilter(rank);
    }

    public static IObjectProfileNode.INodeFilter newSizeFilter(int threshold) {
        return new SizeFilter(threshold);
    }

    static IObjectProfileNode.INodeFilter newSizeFractionFilter(double threshold) {
        return new SizeFractionFilter(threshold);
    }

    private ObjectProfileFilters() {
    }

    private static final class SizeFractionFilter
    implements IObjectProfileNode.INodeFilter {
        private final double threshold;

        SizeFractionFilter(double threshold) {
            this.threshold = threshold;
        }

        @Override
        public boolean accept(IObjectProfileNode node) {
            return (double)node.size() >= this.threshold * (double)node.root().size();
        }
    }

    private static final class SizeFilter
    implements IObjectProfileNode.INodeFilter {
        private final int threshold;

        SizeFilter(int threshold) {
            this.threshold = threshold;
        }

        @Override
        public boolean accept(IObjectProfileNode node) {
            return node.size() >= this.threshold;
        }
    }

    private static final class RankFilter
    implements IObjectProfileNode.INodeFilter {
        private final int threshold;

        RankFilter(int threshold) {
            this.threshold = threshold;
        }

        @Override
        public boolean accept(IObjectProfileNode node) {
            IObjectProfileNode parent = node.parent();
            if (parent == null) {
                return true;
            }
            IObjectProfileNode[] siblings = parent.children();
            int rLimit = Math.min(siblings.length, this.threshold);
            for (int r = 0; r < rLimit; ++r) {
                if (siblings[r] != node) continue;
                return true;
            }
            return false;
        }
    }

    private static final class ParentSizeFractionFilter
    implements IObjectProfileNode.INodeFilter {
        private final double threshold;

        ParentSizeFractionFilter(double threshold) {
            this.threshold = threshold;
        }

        @Override
        public boolean accept(IObjectProfileNode node) {
            IObjectProfileNode parent = node.parent();
            if (parent == null) {
                return true;
            }
            return (double)node.size() >= this.threshold * (double)parent.size();
        }
    }
}

