/*
 * Decompiled with CFR 0.152.
 */
package de.xam.memspace;

import de.xam.memspace.IObjectProfileNode;
import de.xam.memspace.ObjectProfileVisitors;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.LinkedList;

abstract class AbstractProfileNode
implements IObjectProfileNode,
Comparable<Object> {
    static final IObjectProfileNode[] EMPTY_OBJECTPROFILENODE_ARRAY = new IObjectProfileNode[0];
    private final IObjectProfileNode parent;
    private transient IObjectProfileNode[] path;
    int size;

    AbstractProfileNode(IObjectProfileNode parent) {
        this.parent = parent;
    }

    @Override
    public final int compareTo(Object obj) {
        return ((AbstractProfileNode)obj).size - this.size;
    }

    @Override
    public final String dump() throws IOException {
        StringWriter sw = new StringWriter();
        PrintWriter out = new PrintWriter(sw);
        IObjectProfileNode.INodeVisitor visitor = ObjectProfileVisitors.newDefaultNodePrinter(out, null, null, false);
        this.traverse(null, visitor);
        out.flush();
        return sw.toString();
    }

    @Override
    public final IObjectProfileNode parent() {
        return this.parent;
    }

    @Override
    public final IObjectProfileNode[] path() {
        IObjectProfileNode[] path = this.path;
        if (path != null) {
            return path;
        }
        LinkedList<AbstractProfileNode> _path = new LinkedList<AbstractProfileNode>();
        for (IObjectProfileNode node = this; node != null; node = node.parent()) {
            _path.addFirst((AbstractProfileNode)node);
        }
        path = new IObjectProfileNode[_path.size()];
        _path.toArray(path);
        this.path = path;
        return path;
    }

    @Override
    public final int pathlength() {
        IObjectProfileNode[] path = this.path;
        if (path != null) {
            return path.length;
        }
        int result = 0;
        for (IObjectProfileNode node = this; node != null; node = node.parent()) {
            ++result;
        }
        return result;
    }

    @Override
    public final IObjectProfileNode root() {
        IObjectProfileNode node = this;
        for (IObjectProfileNode parent = this.parent(); parent != null; parent = parent.parent()) {
            node = parent;
        }
        return node;
    }

    @Override
    public final int size() {
        return this.size;
    }

    public String toString() {
        return super.toString() + ": name = " + this.name() + ", size = " + this.size();
    }
}

