/*
 * Decompiled with CFR 0.152.
 */
package com.google.caliper.worker;

import com.google.caliper.bridge.WorkerSpec;
import com.google.caliper.worker.AggregateAllocationsRecorder;
import com.google.caliper.worker.AllAllocationsRecorder;
import com.google.caliper.worker.AllocationRecorder;
import com.google.caliper.worker.Worker;
import com.google.caliper.worker.WorkerEventLog;
import com.google.caliper.worker.WorkerOptions;
import com.google.common.base.Charsets;
import com.google.common.base.Ticker;
import com.google.common.collect.ImmutableMap;
import com.google.common.net.InetAddresses;
import com.google.inject.AbstractModule;
import com.google.inject.Key;
import com.google.inject.Provides;
import com.google.inject.Singleton;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.net.Socket;
import java.util.Map;
import java.util.Random;

final class WorkerModule
extends AbstractModule {
    private final Class<? extends Worker> workerClass;
    private final int port;
    private final ImmutableMap<String, String> workerOptions;

    WorkerModule(WorkerSpec workerSpec) {
        try {
            this.workerClass = Class.forName(workerSpec.workerClassName).asSubclass(Worker.class);
        }
        catch (ClassNotFoundException e) {
            throw new AssertionError((Object)"classes referenced in the runner are always present");
        }
        this.port = workerSpec.port;
        this.workerOptions = workerSpec.workerOptions;
    }

    protected void configure() {
        this.bind(Worker.class).to(this.workerClass);
        this.bind(Ticker.class).toInstance((Object)Ticker.systemTicker());
        this.bind(WorkerEventLog.class);
        if (Boolean.valueOf((String)this.workerOptions.get((Object)"trackAllocations")).booleanValue()) {
            this.bind(AllocationRecorder.class).to(AllAllocationsRecorder.class);
        } else {
            this.bind(AllocationRecorder.class).to(AggregateAllocationsRecorder.class);
        }
        this.bind(Random.class);
        this.bind((Key)new Key<Map<String, String>>(WorkerOptions.class){}).toInstance(this.workerOptions);
    }

    @Provides
    @Singleton
    BufferedWriter provideSocketWriter(Socket socket) throws IOException {
        return new BufferedWriter(new OutputStreamWriter(socket.getOutputStream(), Charsets.UTF_8));
    }

    @Provides
    @Singleton
    BufferedReader provideSocketReader(Socket socket) throws IOException {
        return new BufferedReader(new InputStreamReader(socket.getInputStream(), Charsets.UTF_8));
    }

    @Provides
    @Singleton
    Socket provideSocket() throws IOException {
        final Socket socket = new Socket(InetAddresses.forString((String)"127.0.0.1"), this.port);
        socket.setTcpNoDelay(true);
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                try {
                    socket.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        });
        return socket;
    }
}

