/*
 * Decompiled with CFR 0.152.
 */
package com.google.caliper.runner;

import com.google.caliper.bridge.LogMessage;
import com.google.caliper.bridge.ShouldContinueMessage;
import com.google.caliper.bridge.StopMeasurementLogMessage;
import com.google.caliper.model.Trial;
import com.google.caliper.options.CaliperOptions;
import com.google.caliper.runner.Instrument;
import com.google.caliper.runner.StreamService;
import com.google.caliper.runner.TrialFactory;
import com.google.caliper.runner.TrialFailureException;
import com.google.caliper.runner.TrialScoped;
import com.google.caliper.runner.VmDataCollectingVisitor;
import com.google.caliper.util.ShortDuration;
import com.google.common.base.Stopwatch;
import com.google.common.util.concurrent.Service;
import com.google.gson.Gson;
import com.google.inject.Inject;
import java.io.IOException;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import java.util.logging.Logger;
import org.joda.time.Duration;

@TrialScoped
class TrialRunLoop
implements Callable<Trial> {
    private static final Logger logger = Logger.getLogger(TrialRunLoop.class.getName());
    private static final Duration WORKER_CLEANUP_DURATION = Duration.standardSeconds((long)2L);
    private final CaliperOptions options;
    private final StreamService streamService;
    private final Gson gson;
    private final TrialFactory trialFactory;
    private final VmDataCollectingVisitor dataCollectingVisitor = new VmDataCollectingVisitor();
    private final Stopwatch trialStopwatch = Stopwatch.createUnstarted();
    private final Instrument.MeasurementCollectingVisitor measurementCollectingVisitor;

    @Inject
    TrialRunLoop(Instrument.MeasurementCollectingVisitor measurementCollectingVisitor, CaliperOptions options, TrialFactory trialFactory, Gson gson, StreamService streamService) {
        this.options = options;
        this.trialFactory = trialFactory;
        this.gson = gson;
        this.streamService = streamService;
        this.measurementCollectingVisitor = measurementCollectingVisitor;
    }

    @Override
    public Trial call() throws TrialFailureException, IOException {
        if (this.streamService.state() != Service.State.NEW) {
            throw new IllegalStateException("You can only invoke the run loop once");
        }
        this.streamService.startAsync().awaitRunning();
        try {
            long timeLimitNanos = this.getTrialTimeLimitTrialNanos();
            boolean doneCollecting = false;
            boolean done = false;
            block10: while (!done) {
                StreamService.StreamItem item = this.streamService.readItem(timeLimitNanos - this.trialStopwatch.elapsed(TimeUnit.NANOSECONDS), TimeUnit.NANOSECONDS);
                switch (item.kind()) {
                    case DATA: {
                        LogMessage logMessage = item.content();
                        logMessage.accept(this.measurementCollectingVisitor);
                        logMessage.accept(this.dataCollectingVisitor);
                        if (!doneCollecting && this.measurementCollectingVisitor.isDoneCollecting()) {
                            doneCollecting = true;
                            long cleanupTimeNanos = TimeUnit.MILLISECONDS.toNanos(WORKER_CLEANUP_DURATION.getMillis());
                            timeLimitNanos = this.trialStopwatch.elapsed(TimeUnit.NANOSECONDS) + cleanupTimeNanos;
                        }
                        if (!(logMessage instanceof StopMeasurementLogMessage)) continue block10;
                        this.streamService.writeLine(this.gson.toJson((Object)new ShouldContinueMessage(!doneCollecting)));
                        if (!doneCollecting) continue block10;
                        this.streamService.closeWriter();
                        continue block10;
                    }
                    case EOF: {
                        if (!doneCollecting) {
                            throw new TrialFailureException("The worker exited without producing data. It has likely crashed. Run with --verbose to see any worker output.");
                        }
                        done = true;
                        continue block10;
                    }
                    case TIMEOUT: {
                        if (doneCollecting) {
                            logger.warning("Worker failed to exit cleanly within the alloted time.");
                            done = true;
                            continue block10;
                        }
                        throw new TrialFailureException(String.format("Trial exceeded the total allowable runtime (%s). The limit may be adjusted using the --time-limit flag.", this.options.timeLimit()));
                    }
                }
                throw new AssertionError((Object)("Impossible item: " + item));
            }
            Trial trial = this.trialFactory.newTrial(this.dataCollectingVisitor, this.measurementCollectingVisitor);
            return trial;
        }
        catch (InterruptedException e) {
            throw new AssertionError();
        }
        finally {
            this.trialStopwatch.reset();
            this.streamService.stopAsync();
        }
    }

    private long getTrialTimeLimitTrialNanos() {
        ShortDuration timeLimit = this.options.timeLimit();
        if (ShortDuration.zero().equals(timeLimit)) {
            return Long.MAX_VALUE;
        }
        return timeLimit.to(TimeUnit.NANOSECONDS);
    }
}

