/*
 * Decompiled with CFR 0.152.
 */
package com.google.caliper.runner;

import com.google.caliper.api.ResultProcessor;
import com.google.caliper.config.CaliperConfig;
import com.google.caliper.config.InstrumentConfig;
import com.google.caliper.model.Host;
import com.google.caliper.model.Run;
import com.google.caliper.options.CaliperOptions;
import com.google.caliper.runner.BenchmarkClass;
import com.google.caliper.runner.BenchmarkParameters;
import com.google.caliper.runner.CaliperRun;
import com.google.caliper.runner.EnvironmentGetter;
import com.google.caliper.runner.ExperimentSelector;
import com.google.caliper.runner.ExperimentingCaliperRun;
import com.google.caliper.runner.FullCartesianExperimentSelector;
import com.google.caliper.runner.Instrument;
import com.google.caliper.runner.InstrumentName;
import com.google.caliper.runner.InstrumentOptions;
import com.google.caliper.runner.InvalidBenchmarkException;
import com.google.caliper.runner.InvalidInstrumentException;
import com.google.caliper.runner.LocalPort;
import com.google.caliper.runner.NanoTimeGranularity;
import com.google.caliper.runner.NanoTimeGranularityTester;
import com.google.caliper.runner.RunnerModule;
import com.google.caliper.runner.ServerSocketService;
import com.google.caliper.runner.TrialModule;
import com.google.caliper.util.InvalidCommandException;
import com.google.caliper.util.ShortDuration;
import com.google.caliper.util.Util;
import com.google.common.base.Function;
import com.google.common.collect.HashMultiset;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSetMultimap;
import com.google.common.collect.ImmutableSortedSet;
import com.google.common.collect.Multiset;
import com.google.common.collect.Multisets;
import com.google.common.collect.Ordering;
import com.google.common.collect.TreeMultiset;
import com.google.common.util.concurrent.Service;
import com.google.inject.AbstractModule;
import com.google.inject.Binder;
import com.google.inject.Injector;
import com.google.inject.Module;
import com.google.inject.Provides;
import com.google.inject.ProvisionException;
import com.google.inject.Singleton;
import com.google.inject.multibindings.Multibinder;
import java.lang.reflect.Method;
import java.util.Comparator;
import java.util.UUID;
import org.joda.time.Instant;

final class ExperimentingRunnerModule
extends AbstractModule {
    ExperimentingRunnerModule() {
    }

    protected void configure() {
        this.install((Module)new TrialModule());
        this.install((Module)new RunnerModule());
        this.bind(CaliperRun.class).to(ExperimentingCaliperRun.class);
        this.bind(ExperimentSelector.class).to(FullCartesianExperimentSelector.class);
        Multibinder.newSetBinder((Binder)this.binder(), Service.class).addBinding().to(ServerSocketService.class);
    }

    @LocalPort
    @Provides
    int providePortNumber(ServerSocketService serverSocketService) {
        return serverSocketService.getPort();
    }

    @Provides
    ImmutableSet<ResultProcessor> provideResultProcessors(CaliperConfig config, Injector injector) {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        for (Class processorClass : config.getConfiguredResultProcessors()) {
            builder.add(injector.getInstance(processorClass));
        }
        return builder.build();
    }

    @Provides
    UUID provideUuid() {
        return UUID.randomUUID();
    }

    @Provides
    @BenchmarkParameters
    ImmutableSetMultimap<String, String> provideBenchmarkParameters(BenchmarkClass benchmarkClass, CaliperOptions options) throws InvalidBenchmarkException {
        return benchmarkClass.userParameters().fillInDefaultsFor(options.userParameters());
    }

    @Provides
    @Singleton
    Host provideHost(EnvironmentGetter environmentGetter) {
        return environmentGetter.getHost();
    }

    @Provides
    @Singleton
    Run provideRun(UUID id, CaliperOptions options, Instant startTime) {
        return new Run.Builder(id).label(options.runName()).startTime(startTime).build();
    }

    @Provides
    ImmutableSet<Instrument> provideInstruments(Injector injector, CaliperOptions options, CaliperConfig config) throws InvalidCommandException {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        ImmutableSet<String> configuredInstruments = config.getConfiguredInstruments();
        for (final String instrumentName : options.instrumentNames()) {
            if (!configuredInstruments.contains((Object)instrumentName)) {
                throw new InvalidCommandException("%s is not a configured instrument (%s). use --print-config to see the configured instruments.", instrumentName, configuredInstruments);
            }
            final InstrumentConfig instrumentConfig = config.getInstrumentConfig(instrumentName);
            Injector instrumentInjector = injector.createChildInjector(new Module[]{new AbstractModule(){

                protected void configure() {
                    this.bind(InstrumentConfig.class).toInstance((Object)instrumentConfig);
                }

                @Provides
                @InstrumentOptions
                ImmutableMap<String, String> provideInstrumentOptions(InstrumentConfig config) {
                    return config.options();
                }

                @Provides
                @InstrumentName
                String provideInstrumentName() {
                    return instrumentName;
                }
            }});
            String className = instrumentConfig.className();
            try {
                builder.add(instrumentInjector.getInstance(Util.lenientClassForName(className).asSubclass(Instrument.class)));
            }
            catch (ClassNotFoundException e) {
                throw new InvalidCommandException("Cannot find instrument class '%s'", className);
            }
            catch (ProvisionException e) {
                throw new InvalidInstrumentException("Could not create the instrument %s", className);
            }
        }
        return builder.build();
    }

    @Provides
    @Singleton
    @NanoTimeGranularity
    ShortDuration provideNanoTimeGranularity(NanoTimeGranularityTester tester) {
        return tester.testNanoTimeGranularity();
    }

    @Provides
    ImmutableSet<Instrument.Instrumentation> provideInstrumentations(CaliperOptions options, BenchmarkClass benchmarkClass, ImmutableSet<Instrument> instruments) throws InvalidBenchmarkException {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        ImmutableSet<String> benchmarkMethodNames = options.benchmarkMethodNames();
        for (Instrument instrument : instruments) {
            for (Method method : ExperimentingRunnerModule.findAllBenchmarkMethods(benchmarkClass.benchmarkClass(), instrument)) {
                if (!benchmarkMethodNames.isEmpty() && !benchmarkMethodNames.contains((Object)method.getName())) continue;
                builder.add((Object)instrument.createInstrumentation(method));
            }
        }
        return builder.build();
    }

    private static ImmutableSortedSet<Method> findAllBenchmarkMethods(Class<?> benchmarkClass, Instrument instrument) throws InvalidBenchmarkException {
        ImmutableSortedSet.Builder result = ImmutableSortedSet.orderedBy((Comparator)Ordering.natural().onResultOf((Function)new Function<Method, String>(){

            public String apply(Method method) {
                return method.getName();
            }
        }));
        TreeMultiset benchmarkMethodNames = TreeMultiset.create();
        for (Method method : benchmarkClass.getDeclaredMethods()) {
            if (!instrument.isBenchmarkMethod(method)) continue;
            method.setAccessible(true);
            result.add((Object)method);
            benchmarkMethodNames.add((Object)method.getName());
        }
        Multisets.removeOccurrences((Multiset)benchmarkMethodNames, (Multiset)HashMultiset.create((Iterable)benchmarkMethodNames.elementSet()));
        if (!benchmarkMethodNames.isEmpty()) {
            throw new InvalidBenchmarkException("Overloads are disallowed for benchmark methods, found overloads of %s in benchmark %s", benchmarkMethodNames.elementSet(), benchmarkClass);
        }
        return result.build();
    }
}

