/*
 * Decompiled with CFR 0.152.
 */
package com.google.caliper.runner;

import com.google.caliper.Param;
import com.google.caliper.bridge.WorkerSpec;
import com.google.caliper.runner.Experiment;
import com.google.caliper.runner.Running;
import com.google.caliper.util.Parser;
import com.google.caliper.util.Parsers;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSortedMap;
import com.google.inject.AbstractModule;
import com.google.inject.MembersInjector;
import com.google.inject.TypeLiteral;
import com.google.inject.matcher.AbstractMatcher;
import com.google.inject.matcher.Matcher;
import com.google.inject.spi.TypeEncounter;
import com.google.inject.spi.TypeListener;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.text.ParseException;

public final class ExperimentModule
extends AbstractModule {
    private final Class<?> benchmarkClass;
    private final ImmutableSortedMap<String, String> parameters;
    private final Method benchmarkMethod;

    private ExperimentModule(Class<?> benchmarkClass, Method benchmarkMethod, ImmutableSortedMap<String, String> parameters) {
        this.benchmarkClass = (Class)Preconditions.checkNotNull(benchmarkClass);
        this.parameters = (ImmutableSortedMap)Preconditions.checkNotNull(parameters);
        this.benchmarkMethod = benchmarkMethod;
    }

    public static ExperimentModule forExperiment(Experiment experiment) {
        Method benchmarkMethod = experiment.instrumentation().benchmarkMethod();
        return new ExperimentModule(benchmarkMethod.getDeclaringClass(), benchmarkMethod, experiment.userParameters());
    }

    public static ExperimentModule forWorkerSpec(WorkerSpec spec) throws ClassNotFoundException {
        Class<?> benchmarkClass = Class.forName(spec.benchmarkSpec.className());
        Method benchmarkMethod = ExperimentModule.findBenchmarkMethod(benchmarkClass, spec.benchmarkSpec.methodName(), spec.methodParameterClassNames);
        benchmarkMethod.setAccessible(true);
        return new ExperimentModule(benchmarkClass, benchmarkMethod, spec.benchmarkSpec.parameters());
    }

    protected void configure() {
        this.binder().requireExplicitBindings();
        this.bind(this.benchmarkClass);
        this.bind(Object.class).annotatedWith(Running.Benchmark.class).to(this.benchmarkClass);
        this.bindConstant().annotatedWith(Running.BenchmarkMethod.class).to(this.benchmarkMethod.getName());
        this.bind(Method.class).annotatedWith(Running.BenchmarkMethod.class).toInstance((Object)this.benchmarkMethod);
        this.bindListener((Matcher)new BenchmarkTypeMatcher(), new BenchmarkParameterInjector());
    }

    private static Method findBenchmarkMethod(Class<?> benchmark, String methodName, ImmutableList<String> methodParameterClassNames) {
        Method found = null;
        for (Method method : benchmark.getDeclaredMethods()) {
            if (!method.getName().equals(methodName) || !methodParameterClassNames.equals(ExperimentModule.toClassNames(method.getParameterTypes()))) continue;
            if (found == null) {
                found = method;
                continue;
            }
            throw new AssertionError((Object)String.format("Found two methods named %s with the same list of parameters: %s", methodName, methodParameterClassNames));
        }
        if (found == null) {
            throw new AssertionError((Object)String.format("Could not find method %s in class %s with these parameters %s", methodName, benchmark, methodParameterClassNames));
        }
        return found;
    }

    private static ImmutableList<String> toClassNames(Class<?>[] classes) {
        ImmutableList.Builder classNames = ImmutableList.builder();
        for (Class<?> parameterType : classes) {
            classNames.add((Object)parameterType.getName());
        }
        return classNames.build();
    }

    private final class BenchmarkParameterInjector
    implements TypeListener {
        private BenchmarkParameterInjector() {
        }

        public <I> void hear(TypeLiteral<I> type, TypeEncounter<I> encounter) {
            for (final Field field : type.getRawType().getDeclaredFields()) {
                if (!field.isAnnotationPresent(Param.class)) continue;
                encounter.register(new MembersInjector<I>(){

                    public void injectMembers(I instance) {
                        try {
                            field.setAccessible(true);
                            Parser<?> parser = Parsers.conventionalParser(field.getType());
                            field.set(instance, parser.parse((CharSequence)ExperimentModule.this.parameters.get((Object)field.getName())));
                        }
                        catch (NoSuchMethodException e) {
                            throw new RuntimeException(e);
                        }
                        catch (ParseException e) {
                            throw new RuntimeException(e);
                        }
                        catch (IllegalArgumentException e) {
                            throw new AssertionError((Object)"types have been checked");
                        }
                        catch (IllegalAccessException e) {
                            throw new AssertionError((Object)"already set access");
                        }
                    }
                });
            }
        }
    }

    private final class BenchmarkTypeMatcher
    extends AbstractMatcher<TypeLiteral<?>> {
        private BenchmarkTypeMatcher() {
        }

        public boolean matches(TypeLiteral<?> t) {
            return t.getType().equals(ExperimentModule.this.benchmarkClass);
        }
    }
}

