/*
 * Decompiled with CFR 0.152.
 */
package com.google.caliper.runner;

import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableSet;
import java.io.File;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLClassLoader;

final class EffectiveClassPath {
    private EffectiveClassPath() {
    }

    static String getClassPathForClassLoader(ClassLoader classLoader) {
        return Joiner.on((String)System.getProperty("path.separator")).join(EffectiveClassPath.getClassPathFiles(classLoader));
    }

    private static ImmutableSet<File> getClassPathFiles(ClassLoader classLoader) {
        ImmutableSet.Builder files = ImmutableSet.builder();
        ClassLoader parent = classLoader.getParent();
        if (parent != null) {
            files.addAll(EffectiveClassPath.getClassPathFiles(parent));
        }
        if (classLoader instanceof URLClassLoader) {
            URLClassLoader urlClassLoader = (URLClassLoader)classLoader;
            for (URL url : urlClassLoader.getURLs()) {
                try {
                    files.add((Object)new File(url.toURI()));
                }
                catch (URISyntaxException e) {
                }
                catch (IllegalArgumentException e) {
                    // empty catch block
                }
            }
        }
        return files.build();
    }
}

