/*
 * Decompiled with CFR 0.152.
 */
package com.google.caliper.model;

import com.google.caliper.model.ExcludeFromJson;
import com.google.caliper.model.PersistentHashing;
import com.google.caliper.model.StringMapFunnel;
import com.google.common.base.Objects;
import com.google.common.collect.ImmutableSortedMap;
import com.google.common.collect.Maps;
import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import java.util.Map;
import java.util.SortedMap;
import javax.persistence.Access;
import javax.persistence.AccessType;
import javax.persistence.Cacheable;
import javax.persistence.ElementCollection;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.NamedQuery;
import javax.persistence.PrePersist;
import javax.persistence.PreUpdate;
import javax.persistence.QueryHint;
import org.hibernate.annotations.Immutable;
import org.hibernate.annotations.Index;
import org.hibernate.annotations.Sort;
import org.hibernate.annotations.SortType;

@Entity
@Access(value=AccessType.FIELD)
@Immutable
@Cacheable
@NamedQuery(name="listVmSpecsForHash", query="SELECT v FROM VmSpec v WHERE hash = :hash", hints={@QueryHint(name="org.hibernate.cacheable", value="true"), @QueryHint(name="org.hibernate.readOnly", value="true")})
public final class VmSpec {
    static final VmSpec DEFAULT = new VmSpec();
    @Id
    @GeneratedValue
    @ExcludeFromJson
    private int id;
    @ElementCollection
    @Sort(type=SortType.NATURAL)
    private SortedMap<String, String> properties;
    @ElementCollection
    @Sort(type=SortType.NATURAL)
    private SortedMap<String, String> options;
    @ExcludeFromJson
    @Index(name="hash_index")
    private int hash;

    private VmSpec() {
        this.properties = Maps.newTreeMap();
        this.options = Maps.newTreeMap();
    }

    private VmSpec(Builder builder) {
        this.properties = Maps.newTreeMap((SortedMap)builder.properties);
        this.options = Maps.newTreeMap((SortedMap)builder.options);
    }

    public ImmutableSortedMap<String, String> options() {
        return ImmutableSortedMap.copyOf(this.options);
    }

    public ImmutableSortedMap<String, String> properties() {
        return ImmutableSortedMap.copyOf(this.properties);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof VmSpec) {
            VmSpec that = (VmSpec)obj;
            return this.properties.equals(that.properties) && this.options.equals(that.options);
        }
        return false;
    }

    @PrePersist
    @PreUpdate
    private void initHash() {
        if (this.hash == 0) {
            this.hash = PersistentHashing.getPersistentHashFunction().hashObject((Object)this, (Funnel)VmSpecFunnel.INSTANCE).asInt();
        }
    }

    public int hashCode() {
        this.initHash();
        return this.hash;
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).add("properties", this.properties).add("options", this.options).toString();
    }

    public static final class Builder {
        private final SortedMap<String, String> properties = Maps.newTreeMap();
        private final SortedMap<String, String> options = Maps.newTreeMap();

        public Builder addOption(String optionName, String value) {
            this.options.put(optionName, value);
            return this;
        }

        public Builder addAllOptions(Map<String, String> options) {
            this.options.putAll(options);
            return this;
        }

        public Builder addProperty(String property, String value) {
            this.properties.put(property, value);
            return this;
        }

        public Builder addAllProperties(Map<String, String> properties) {
            this.properties.putAll(properties);
            return this;
        }

        public VmSpec build() {
            return new VmSpec(this);
        }
    }

    static enum VmSpecFunnel implements Funnel<VmSpec>
    {
        INSTANCE;


        public void funnel(VmSpec from, PrimitiveSink into) {
            StringMapFunnel.INSTANCE.funnel(from.properties, into);
            StringMapFunnel.INSTANCE.funnel(from.options, into);
        }
    }
}

