/*
 * Decompiled with CFR 0.152.
 */
package com.calpano.common.server.services.crashreport;

import com.calpano.common.server.services.crashreport.ISendErrorMailService;
import com.calpano.common.shared.mail.Mail;
import com.calpano.common.shared.services.ICrashReportUserDb;
import com.calpano.common.shared.util.CollectionUtils;
import com.sonicmetrics.core.shared.ISonicDB;
import com.sonicmetrics.core.shared.ISonicEvent;
import com.sonicmetrics.core.shared.impl.memory.SonicEvent;
import de.xam.p13n.shared.time.TimeProvider;
import de.xam.texthtml.text.HumanReadableText;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.xydra.conf.IConfig;
import org.xydra.env.Env;
import org.xydra.log.api.Logger;
import org.xydra.log.api.LoggerFactory;
import org.xydra.restless.IRestlessContext;
import org.xydra.restless.Restless;
import org.xydra.restless.RestlessParameter;
import org.xydra.restless.utils.HostUtils;
import org.xydra.restless.utils.ServletUtils;
import org.xydra.restless.utils.SharedHtmlUtils;
import org.xydra.store.XydraRuntime;

public class ClientErrorResource {
    private static final Logger log = LoggerFactory.getLogger(ClientErrorResource.class);
    private static final String ErrorClient_category = "error";
    private static final String ErrorClient_action = "client";

    public static void restless(Restless restless, String prefix) {
        restless.addGet("/clientError/{timestamp}/", ClientErrorResource.class, "get", new RestlessParameter[]{new RestlessParameter("timestamp"), new RestlessParameter("shortMsg"), new RestlessParameter("line", null), new RestlessParameter("jsUrl", null), new RestlessParameter("docUrl", null)});
        restless.addMethod("/clientError/{timestamp}/", "POST", ClientErrorResource.class, "handleClientError", false, new RestlessParameter[]{new RestlessParameter("timestamp"), new RestlessParameter("msg"), new RestlessParameter("line", null), new RestlessParameter("jsUrl", null), new RestlessParameter("docUrl", null), new RestlessParameter("consoleLogs", null)});
    }

    public static void get(IRestlessContext context, String timestamp, String msg, String line, String jsurl, String docurl) {
        log.info("Receiving robust client-side JS error " + timestamp + " " + msg);
        TreeMap<String, String> map = new TreeMap<String, String>();
        ClientErrorResource.addToMapAndGetHash(map, timestamp, msg, line, jsurl, docurl);
        ClientErrorResource.addRequestInfoToMap(map, context.getRequest());
        map.put("restless.requestId", context.getRequestIdentifier());
        ClientErrorResource.addServerInfoToMap(map);
        ClientErrorResource.putMapInDatalogger(map);
        ClientErrorResource.mailMapToAdmins(map, "JS error robust #");
    }

    public static void handleClientError(IRestlessContext context, String timestamp, String msg, String line, String jsurl, String docurl, String consoleLogs) throws IOException {
        log.info("Receiving client-side JS error report " + timestamp + " " + msg);
        TreeMap<String, String> map = new TreeMap<String, String>();
        String hash = ClientErrorResource.addToMapAndGetHash(map, timestamp, msg, line, jsurl, docurl);
        ClientErrorResource.addRequestInfoToMap(map, context.getRequest());
        ClientErrorResource.addServerInfoToMap(map);
        map.put("console.logs", consoleLogs);
        ClientErrorResource.putMapInDatalogger(map);
        ClientErrorResource.mailMapToAdmins(map, "JS error #");
        HttpServletResponse res = context.getResponse();
        ServletUtils.headers((HttpServletResponse)res, (int)200, (long)-1L, (String)"text/plain");
        PrintWriter w = res.getWriter();
        w.print("Logged error " + hash);
        w.close();
    }

    private static void mailMapToAdmins(Map<String, String> map, String subjectPrefix) {
        String hash = map.get("i-error.hash");
        ISendErrorMailService mailService = (ISendErrorMailService)Env.get().conf().resolve(ISendErrorMailService.class);
        if (mailService != null) {
            Mail mail = mailService.createMailToAdmins("ClientError", subjectPrefix + hash);
            StringBuffer buf = new StringBuffer();
            for (Map.Entry<String, String> entry : map.entrySet()) {
                String s = entry.getValue();
                if (s == null) continue;
                s = s.replaceAll("\n", "<br/>\n");
                entry.setValue(s);
            }
            buf.append(SharedHtmlUtils.toDefinitionList(map));
            mail.messageTextHtml = buf.toString();
            mailService.sendMail(mail, true, false);
        }
    }

    private static void putMapInDatalogger(Map<String, String> map) {
        IConfig conf = Env.get().conf();
        ISonicDB sonicDB = (ISonicDB)conf.tryToResolve(ISonicDB.class);
        if (sonicDB == null) {
            if (!conf.getBoolean("runLocal")) {
                throw new RuntimeException("Config problem - have no sonic DB");
            }
            return;
        }
        ISonicEvent se = (ISonicEvent)((SonicEvent.SeBuilder)((SonicEvent.SeBuilder)((SonicEvent.SeBuilder)((SonicEvent.SeBuilder)SonicEvent.create((long)TimeProvider.getCurrentTimeInMillis()).category(ErrorClient_category)).action(ErrorClient_action)).subject("gwt")).source("ClientErrorResource")).withParams(map).build();
        sonicDB.receiveEvent(se);
    }

    private static void addServerInfoToMap(Map<String, String> map) {
    }

    private static String addToMapAndGetHash(Map<String, String> map, String timestamp, String msg, String line, String jsUrl, String docUrl) {
        map.put("error.timestamp", timestamp);
        map.put("error.msg", msg);
        map.put("error.line", line);
        map.put("error.jsurl", jsUrl);
        map.put("error.docurl", docUrl);
        map.put("_error.docurl", docUrl);
        String msgStart = msg.substring(0, Math.min(200, msg.length()));
        int hash = msgStart.hashCode();
        if (line != null) {
            hash += line.hashCode();
        }
        if (jsUrl != null) {
            hash += jsUrl.hashCode();
        }
        if (docUrl != null) {
            hash += docUrl.hashCode();
        }
        map.put("i-error.hash", "" + hash);
        map.put("i-type", "jsgwterror");
        return "" + hash;
    }

    private static void addRequestInfoToMap(Map<String, String> map, HttpServletRequest req) {
        map.put("request.remoteHost", req.getRemoteHost());
        map.put("request.authenticatedUser", req.getRemoteUser());
        Map headerMap = ServletUtils.getHeadersAsMap((HttpServletRequest)req);
        map.remove("Cookie");
        map.putAll(CollectionUtils.prefixKeys_listMap((String)"header.", (Map)headerMap));
        map.put("_header.User-Agent", CollectionUtils.toString((List)((List)headerMap.get("User-Agent"))));
        map.put("header.X-Zoo", req.getHeader("X-Zoo"));
        map.put("header.X-AppEngine-Country", req.getHeader("X-AppEngine-Country"));
        Map cookieMap = ServletUtils.getCookiesAsMap((HttpServletRequest)req);
        map.putAll(CollectionUtils.prefixKeys((String)"cookie.", (Map)cookieMap));
        map.put("request-uri", ServletUtils.getPageUri((HttpServletRequest)req));
        map.putAll(CollectionUtils.prefixKeys((String)"request-param.", (Map)ServletUtils.getRequestparametersAsMap((HttpServletRequest)req)));
        ICrashReportUserDb crashReportUserDb = (ICrashReportUserDb)Env.get().conf().resolve(ICrashReportUserDb.class);
        if (crashReportUserDb != null) {
            crashReportUserDb.addInformationAboutUserFromCookie(cookieMap, map);
        }
    }

    public static Map<String, String> createDataMap(String requestIdentifier, HttpServletRequest req) {
        HashMap<String, String> dataMap = new HashMap<String, String>();
        dataMap.put("timestamp", "" + TimeProvider.getCurrentTimeInMillis());
        dataMap.put("timestamp.nice", "" + HumanReadableText.fullDate((long)TimeProvider.getCurrentTimeInMillis()));
        dataMap.put("time", "" + new Date());
        ClientErrorResource.addServerInfoToMap(dataMap);
        dataMap.put("localHostname", HostUtils.getLocalHostname());
        dataMap.put("requestId", requestIdentifier);
        dataMap.put("instanceId", XydraRuntime.getInstanceId());
        dataMap.put("xydraRuntime.lastInit", "" + XydraRuntime.getLastTimeInitialisedAt() + " = " + HumanReadableText.fullDateTimeIso((long)XydraRuntime.getLastTimeInitialisedAt()));
        dataMap.putAll(CollectionUtils.prefixKeys((String)"xydraRuntimeConfig", (Map)XydraRuntime.getConfigMap()));
        if (req != null) {
            ClientErrorResource.addRequestInfoToMap(dataMap, req);
        }
        return dataMap;
    }
}

