/*
 * Decompiled with CFR 0.152.
 */
package com.calpano.common.server.rest;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.xydra.conf.annotations.RequireConf;
import org.xydra.env.Env;
import org.xydra.log.api.Logger;
import org.xydra.log.api.LoggerFactory;
import org.xydra.restless.IRestlessContext;
import org.xydra.restless.utils.ServletUtils;

@RequireConf(value={"runLocal", "staticPathPrefixes"})
public class Error404Resource {
    private static final Logger log = LoggerFactory.getLogger(Error404Resource.class);

    public static void error404(IRestlessContext context) throws IOException {
        HttpServletRequest req = context.getRequest();
        if (Env.get().conf().getBoolean("runLocal")) {
            for (String staticPrefix : Env.get().conf().getStringSet("staticPathPrefixes")) {
                if (req.getPathInfo() == null || !req.getPathInfo().startsWith(staticPrefix)) continue;
                context.getRestless().delegateToDefaultServlet(req, context.getResponse());
                return;
            }
        }
        Set staticPaths = Env.get().conf().getStringSet("staticPathPrefixes");
        log.trace("static paths are = " + staticPaths);
        String uri = req.getRequestURI();
        log.warn("Serving 404 for '" + uri + "'");
        ServletUtils.headers((HttpServletResponse)context.getResponse(), (int)404, (long)0L, (String)"text/html");
        PrintWriter w = context.getResponse().getWriter();
        ((Writer)w).write("Page not found: " + uri);
        ((Writer)w).flush();
        ((Writer)w).close();
    }
}

