/*
 * Decompiled with CFR 0.152.
 */
package com.calpano.common.server.appcache;

import com.calpano.common.server.appcache.EnLocalePropertyProvider;
import com.googlecode.mgwt.linker.linker.ManifestWriter;
import com.googlecode.mgwt.linker.linker.XMLPermutationProvider;
import com.googlecode.mgwt.linker.linker.XMLPermutationProviderException;
import com.googlecode.mgwt.linker.server.BindingProperty;
import com.googlecode.mgwt.linker.server.propertyprovider.MgwtOsPropertyProvider;
import com.googlecode.mgwt.linker.server.propertyprovider.PropertyProvider;
import com.googlecode.mgwt.linker.server.propertyprovider.PropertyProviderException;
import com.googlecode.mgwt.linker.server.propertyprovider.UserAgentPropertyProvider;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.xydra.log.api.Logger;
import org.xydra.log.api.LoggerFactory;

public class Html5ManifestServlet
extends HttpServlet {
    private static final long serialVersionUID = 3480215265307651028L;
    private static final Logger log = LoggerFactory.getLogger(Html5ManifestServlet.class);
    private final XMLPermutationProvider permutationProvider;
    private final Map<String, PropertyProvider> propertyProviders = new HashMap<String, PropertyProvider>();

    public Html5ManifestServlet() {
        this.permutationProvider = new XMLPermutationProvider();
        this.addPropertyProvider((PropertyProvider)new EnLocalePropertyProvider());
        this.addPropertyProvider((PropertyProvider)new UserAgentPropertyProvider());
    }

    protected void addPropertyProvider(PropertyProvider propertyProvider) {
        this.propertyProviders.put(propertyProvider.getPropertyName(), propertyProvider);
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        Set<BindingProperty> computedBindings;
        String moduleName = this.getModuleName(req);
        String baseUrl = this.getBaseUrl(req);
        String strongName = this.getPermutationStrongName(baseUrl, moduleName, computedBindings = this.calculateBindinPropertiesForClient(req));
        if (strongName != null) {
            String manifest = this.readManifest(baseUrl + moduleName + "/" + strongName + ".manifest");
            this.serveStringManifest(req, resp, manifest);
            return;
        }
        boolean isIPhoneWithoutCookie = this.isIphoneWithoutCookie(computedBindings);
        boolean isIPadWithoutCookie = this.isIpadWithoutCookie(computedBindings);
        if (isIPhoneWithoutCookie || isIPadWithoutCookie) {
            HashSet<BindingProperty> nonRetinaMatch = new HashSet<BindingProperty>();
            HashSet<BindingProperty> retinaMatch = new HashSet<BindingProperty>();
            if (isIPhoneWithoutCookie) {
                computedBindings.remove(MgwtOsPropertyProvider.iPhone_undefined);
                nonRetinaMatch.add(MgwtOsPropertyProvider.iPhone);
                retinaMatch.add(MgwtOsPropertyProvider.retina);
            }
            if (isIPadWithoutCookie) {
                computedBindings.remove(MgwtOsPropertyProvider.iPad_undefined);
                nonRetinaMatch.add(MgwtOsPropertyProvider.iPad);
                retinaMatch.add(MgwtOsPropertyProvider.iPad_retina);
            }
            nonRetinaMatch.addAll(computedBindings);
            retinaMatch.addAll(computedBindings);
            String moduleNameNonRetina = this.getPermutationStrongName(baseUrl, moduleName, nonRetinaMatch);
            String moduleNameRetina = this.getPermutationStrongName(baseUrl, moduleName, retinaMatch);
            if (moduleNameNonRetina != null && moduleNameRetina != null) {
                Set<String> filesForPermutation = this.getFilesForPermutation(baseUrl, moduleName, moduleNameNonRetina);
                filesForPermutation.addAll(this.getFilesForPermutation(baseUrl, moduleName, moduleNameRetina));
                ManifestWriter manifestWriter = new ManifestWriter();
                String writeManifest = manifestWriter.writeManifest(new HashSet(), filesForPermutation);
                this.serveStringManifest(req, resp, writeManifest);
                return;
            }
        }
        throw new ServletException("unkown device");
    }

    protected String getBaseUrl(HttpServletRequest req) {
        String base = req.getServletPath();
        return base.substring(0, base.lastIndexOf("/") + 1);
    }

    public boolean isIphoneWithoutCookie(Set<BindingProperty> bps) {
        for (BindingProperty bp : bps) {
            if (!"mgwt.os".equals(bp.getName()) || !"iphone_undefined".equals(bp.getValue())) continue;
            return true;
        }
        return false;
    }

    public boolean isIpadWithoutCookie(Set<BindingProperty> bps) {
        for (BindingProperty bp : bps) {
            if (!"mgwt.os".equals(bp.getName()) || !"ipad_undefined".equals(bp.getValue())) continue;
            return true;
        }
        return false;
    }

    public Set<String> getFilesForPermutation(String baseUrl, String moduleName, String permutation) throws ServletException {
        String fileName = baseUrl + moduleName + "/" + permutation + ".perm.xml";
        XMLPermutationProvider xmlPermutationProvider = new XMLPermutationProvider();
        try {
            File file = new File(this.getServletContext().getRealPath(fileName));
            FileInputStream inputStream = new FileInputStream(file);
            return xmlPermutationProvider.getPermutationFiles((InputStream)inputStream);
        }
        catch (XMLPermutationProviderException e) {
            this.log("can not read permutation file");
            throw new ServletException("can not read permutation file", (Throwable)e);
        }
        catch (FileNotFoundException e) {
            this.log("can not read permutation file");
            throw new ServletException("can not read permutation file", (Throwable)e);
        }
    }

    public String readManifest(String filePath) throws ServletException {
        File manifestFile = new File(this.getServletContext().getRealPath(filePath));
        StringWriter manifestWriter = new StringWriter();
        BufferedReader br = null;
        try {
            br = new BufferedReader(new FileReader(manifestFile));
            String line = null;
            while ((line = br.readLine()) != null) {
                manifestWriter.append(line + "\n");
            }
            String string = manifestWriter.toString();
            return string;
        }
        catch (FileNotFoundException e) {
            this.log("could not find manifest file", e);
            throw new ServletException("can not find manifest file", (Throwable)e);
        }
        catch (IOException e) {
            this.log("error while reading manifest file", e);
            throw new ServletException("error while reading manifest file", (Throwable)e);
        }
        finally {
            if (br != null) {
                try {
                    br.close();
                }
                catch (IOException e) {}
            }
        }
    }

    public Set<BindingProperty> calculateBindinPropertiesForClient(HttpServletRequest req) throws ServletException {
        try {
            HashSet<BindingProperty> computedBindings = new HashSet<BindingProperty>();
            Set<Map.Entry<String, PropertyProvider>> set = this.propertyProviders.entrySet();
            for (Map.Entry<String, PropertyProvider> entry : set) {
                String varValue = entry.getValue().getPropertyValue(req);
                BindingProperty bindingProperty = new BindingProperty(entry.getKey(), varValue);
                computedBindings.add(bindingProperty);
            }
            return computedBindings;
        }
        catch (PropertyProviderException e) {
            this.log("cam not calculate properties for client", e);
            throw new ServletException("can not calculate properties for client", (Throwable)e);
        }
    }

    public void serveStringManifest(HttpServletRequest req, HttpServletResponse resp, String manifest) throws ServletException {
        resp.setHeader("Cache-Control", "no-cache");
        resp.setHeader("Pragma", "no-cache");
        resp.setDateHeader("Expires", new Date().getTime());
        resp.setContentType("text/cache-manifest");
        try {
            int bytesRead;
            ByteArrayInputStream is = new ByteArrayInputStream(manifest.getBytes("UTF-8"));
            ServletOutputStream os = resp.getOutputStream();
            byte[] buffer = new byte[1024];
            while ((bytesRead = is.read(buffer)) != -1) {
                os.write(buffer, 0, bytesRead);
            }
            return;
        }
        catch (UnsupportedEncodingException e) {
            this.log("can not write manifest to output stream", e);
            throw new ServletException("can not write manifest to output stream", (Throwable)e);
        }
        catch (IOException e) {
            this.log("can not write manifest to output stream", e);
            throw new ServletException("can not write manifest to output stream", (Throwable)e);
        }
    }

    public String getPermutationStrongName(String baseUrl, String moduleName, Set<BindingProperty> computedBindings) throws ServletException {
        if (moduleName == null) {
            throw new IllegalArgumentException("moduleName can not be null");
        }
        if (computedBindings == null) {
            throw new IllegalArgumentException("computedBindings can not be null");
        }
        String realPath = this.getServletContext().getRealPath(baseUrl + moduleName + "/" + "manifest.map");
        try {
            FileInputStream fileInputStream = new FileInputStream(realPath);
            Map map = this.permutationProvider.getBindingProperties((InputStream)fileInputStream);
            for (Map.Entry entry : map.entrySet()) {
                List list = (List)entry.getValue();
                if (!list.containsAll(computedBindings) || list.size() != computedBindings.size()) continue;
                return (String)entry.getKey();
            }
            log.warn("Found no matching GWT permutation, fall-back to look for locale only");
            String desiredLocale = "";
            for (BindingProperty bindingProperty : computedBindings) {
                if (!bindingProperty.getName().equals("locale")) continue;
                desiredLocale = bindingProperty.getValue();
            }
            for (Map.Entry entry : map.entrySet()) {
                List value = (List)entry.getValue();
                for (BindingProperty bp : value) {
                    if (!bp.getName().equals("locale") || !bp.getValue().equalsIgnoreCase(desiredLocale)) continue;
                    return (String)entry.getKey();
                }
            }
            return null;
        }
        catch (FileNotFoundException e) {
            this.log("can not find file: '" + realPath + "'", e);
            throw new ServletException("can not find permutation file", (Throwable)e);
        }
        catch (XMLPermutationProviderException e) {
            this.log("can not read xml file", e);
            throw new ServletException("can not read permutation information", (Throwable)e);
        }
    }

    public String getModuleName(HttpServletRequest req) throws ServletException {
        if (req == null) {
            throw new IllegalArgumentException("reqeust can not be null");
        }
        Pattern pattern = Pattern.compile("/([a-zA-Z0-9]+)\\.manifest$");
        Matcher matcher = pattern.matcher(req.getServletPath());
        if (!matcher.find()) {
            this.log("can not calculate module base from url: '" + req.getServletPath() + "'");
            throw new ServletException("can not calculate module base from url: '" + req.getServletPath() + "'");
        }
        String module = matcher.group(1);
        return module;
    }
}

