/*
 * Decompiled with CFR 0.152.
 */
package com.calpano.common.server;

import com.calpano.common.server.services.bilog.IBiLogger;
import com.calpano.common.server.services.bilog.SonicMetricsBiLogger;
import de.xam.p13n.shared.MiniLocale;
import de.xam.p13n.shared.Personalisation;
import de.xam.p13n.shared.time.TimeProvider;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Set;
import org.joda.time.DateTimeZone;
import org.xydra.base.XId;
import org.xydra.conf.IConfig;
import org.xydra.conf.IConfigProvider;
import org.xydra.conf.IResolver;
import org.xydra.conf.annotations.ConfDoc;
import org.xydra.conf.annotations.ConfType;
import org.xydra.conf.annotations.RequireConf;

public class ConfParamsCalpanoCommonServer
implements IConfigProvider {
    @ConfDoc(value="The default modelId for the user model")
    @ConfType(value=XId.class)
    public static final String MODEL_ID_USER = "modelIdUser";
    @ConfType(value=boolean.class)
    public static final String ServerSideLogging = "log-serverSideLogging";
    @ConfDoc(value="Google Analytics UA code to log warn/error events")
    @ConfType(value=String.class)
    public static final String ServerSideLogging_GoogleAnalytics_UACode = "log-serverSideLogging_GoogleAnalytics_UACode";
    @ConfType(value=String.class)
    @ConfDoc(value="Domain name for Google Analytics for which to log server-side errors/warnings")
    public static final String ServerSideLogging_GoogleAnalytics_DomainName = "log-serverSideLogging_GoogleAnalytics_DomainName";
    @ConfDoc(value="When to redirect if an error occurs, time in milliseconds")
    @ConfType(value=long.class)
    public static final String error_redirectMs = "error_redirectMs";
    @ConfDoc(value="ga tracker id for backend stats")
    @ConfType(value=String.class)
    public static final String ga_backend_uacode = "ga_backend_uacode";
    @ConfDoc(value="ga tracker for user behaviour in the BiLogger that gets exported to CXO")
    @ConfType(value=String.class)
    public static final String ga_userstats_uacode = "ga_userstats_uacode";
    @ConfType(value=boolean.class)
    @ConfDoc(value="If true, we run in production and skip a number of slow internal checks, but do run more security things.")
    public static final String IN_PRODUCTION = "inProduction";
    @ConfDoc(value="TODO @@ document")
    public static final String INSTANCE_CACHE = "instanceCache";
    @ConfType(value=Personalisation.class)
    @ConfDoc(value="TODO @@ document")
    public static final String P13N = "p13n";
    @ConfDoc(value="TODO @@ document")
    public static final String p13nMessagePrefixedUsedOnlyOnServer = "p13nMessagePrefixedUsedOnlyOnServer";
    @ConfType(value=String.class)
    @ConfDoc(value="TODO @@ document")
    public static final String pageMessagePackage = "pageMessagePackage";
    @ConfType(value=boolean.class)
    @ConfDoc(value="TODO @@ document")
    public static final String RUN_LOCAL = "runLocal";
    @ConfType(value=String[].class)
    @ConfDoc(value="TODO @@ document")
    public static final String staticPathPrefixes = "staticPathPrefixes";
    @ConfDoc(value="Should match the GWT module names as defined in pom.xml")
    @ConfType(value=String[].class)
    public static final String gwtModuleNames = "gwtModuleNames";

    private static final Personalisation createDefaultP13n() {
        DateTimeZone berlin = DateTimeZone.forID((String)"Europe/Berlin");
        long offsetMillis = berlin.getOffset(TimeProvider.getCurrentTimeInMillis());
        int offsetHours = (int)(offsetMillis / 3600000L);
        return new Personalisation(MiniLocale.De_DE, offsetHours);
    }

    public void configure(IConfig conf) {
        this.configureDefaults(conf);
        conf.setDefault(P13N, (Object)ConfParamsCalpanoCommonServer.createDefaultP13n(), true);
        conf.setDefault(IN_PRODUCTION, (Object)true, true);
        conf.setInstance(IBiLogger.class, (Object)new SonicMetricsBiLogger());
        conf.setResolver(IBiLogger.class, (IResolver)new IResolver<IBiLogger>(){

            public boolean canResolve() {
                return true;
            }

            public IBiLogger resolve() {
                return new SonicMetricsBiLogger();
            }
        });
    }

    public void configureDefaults(IConfig conf) {
        conf.setDefault("app.version", (Object)"2012-02-12", true);
        conf.setDefault("ga.domain_name", (Object)"pimapp.calpano.com", true);
        conf.setDefault(ServerSideLogging, (Object)false, true);
        conf.setDefault(ServerSideLogging_GoogleAnalytics_UACode, (Object)"UA-11495339-13", true);
        conf.setDefault(ServerSideLogging_GoogleAnalytics_DomainName, (Object)"testing.calpano.com", true);
    }

    @RequireConf(value={"inProduction"})
    public void configureExplicit(IConfig conf) {
        conf.set(IN_PRODUCTION, (Object)false);
        conf.set(error_redirectMs, (Object)2000L);
        conf.setBoolean(RUN_LOCAL, true);
        conf.setDefault(error_redirectMs, (Object)(conf.getBoolean(IN_PRODUCTION) ? 3000L : 60000L), true);
        conf.set("ga_serversideapp_uacode", (Object)"123");
        conf.set("serversidefavr_app_calpano_com", (Object)"example.com");
        conf.setStrings(gwtModuleNames, new String[]{"browserapp", "gwt"});
        conf.set(ga_backend_uacode, (Object)"UA-11495339-9");
        conf.set(ga_userstats_uacode, (Object)"UA-11495339-17");
        ArrayList<String> staticPathPrefixes = new ArrayList<String>();
        staticPathPrefixes.addAll(Arrays.asList("/s/"));
        Set gwtModuleNames = conf.getStringSet(gwtModuleNames);
        for (String s : gwtModuleNames) {
            staticPathPrefixes.add("/" + s + "/");
        }
        conf.setStrings(staticPathPrefixes, staticPathPrefixes.toArray(new String[0]));
    }
}

