/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.yars.util.thread;

import java.util.Iterator;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import org.semanticweb.yars.nx.Node;
import org.semanticweb.yars.nx.parser.Callback;
import org.semanticweb.yars.util.thread.ConsumerThread;
import org.semanticweb.yars.util.thread.ProducerThread;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConsumerProducerThread
extends Thread {
    public static final Node[] EOM = new Node[0];
    public static final int DEFAULT_BUFFER = 500;
    private ConsumerThread _ct;
    private ProducerThread _pt;
    private Exception _e;

    public ConsumerProducerThread(Iterator<Node[]> in, Callback out) {
        this(in, out, 500);
    }

    public ConsumerProducerThread(Iterator<Node[]> in, Callback out, int buffer) {
        this(in, out, new ArrayBlockingQueue<Node[]>(buffer));
    }

    public ConsumerProducerThread(Iterator<Node[]> in, Callback out, BlockingQueue<Node[]> q) {
        this._ct = new ConsumerThread(out, q);
        this._pt = new ProducerThread(in, q);
    }

    @Override
    public void run() {
        try {
            this.runUnthreaded();
        }
        catch (Exception e) {
            this._e = e;
        }
    }

    public void setTicks(int ticks) {
        this._ct.setTicks(ticks);
        this._pt.setTicks(ticks);
    }

    public boolean successful() {
        return this._e == null;
    }

    public Exception getException() {
        return this._e;
    }

    public void runUnthreaded() throws InterruptedException {
        this._pt.start();
        this._ct.start();
        this._pt.join();
        this._ct.join();
        if (!this._ct.successful()) {
            throw this._ct.getException();
        }
    }
}

