/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.yars.util;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.NoSuchElementException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PeekingIterator<T>
implements Iterator<T> {
    T _peek;
    T _next;
    Iterator<T> _it;
    Status _stat;

    public PeekingIterator(Iterable<T> iterable) {
        this(iterable.iterator());
    }

    public PeekingIterator(Iterator<T> it) {
        this._it = it;
        this._stat = Status.VIRGINAL;
        this._next = null;
    }

    @Override
    public boolean hasNext() {
        switch (this._stat) {
            case VIRGINAL: {
                return this._it.hasNext();
            }
        }
        return this._stat != Status.FINISHED;
    }

    @Override
    public T next() {
        switch (this._stat) {
            case VIRGINAL: {
                if (this._it.hasNext()) {
                    this._stat = Status.RUNNING;
                    T sav = this._it.next();
                    if (this._it.hasNext()) {
                        this._peek = this._it.next();
                        if (!this._it.hasNext()) {
                            this._stat = Status.ITERATOR_FINISHED;
                            this._next = null;
                        } else {
                            this._next = this._it.next();
                        }
                    } else {
                        this._stat = Status.FINISHED;
                    }
                    return sav;
                }
                this._stat = Status.FINISHED;
            }
            case FINISHED: {
                throw new NoSuchElementException();
            }
            case ITERATOR_FINISHED: {
                this._stat = Status.FINISHED;
                return this._peek;
            }
        }
        T sav = this._peek;
        if (!this._it.hasNext()) {
            this._stat = Status.ITERATOR_FINISHED;
            this._peek = this._next;
            this._next = null;
        } else {
            this._peek = this._next;
            this._next = this._it.next();
        }
        return sav;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    public T peek() {
        switch (this._stat) {
            case VIRGINAL: {
                if (!this._it.hasNext()) {
                    this._stat = Status.FINISHED;
                    return null;
                }
                this._peek = this._it.next();
                if (!this._it.hasNext()) {
                    this._stat = Status.ITERATOR_FINISHED;
                    this._next = null;
                } else {
                    this._stat = Status.RUNNING;
                    this._next = this._it.next();
                }
                return this._peek;
            }
            case FINISHED: {
                return null;
            }
        }
        return this._peek;
    }

    public static void main(String[] args) {
        LinkedList<Integer> l = new LinkedList<Integer>();
        l.add(1);
        l.add(2);
        PeekingIterator it = new PeekingIterator(l.iterator());
        System.out.println(it.peek());
        System.out.println(it.hasNext());
        System.out.println(it.peek());
        System.out.println(it.hasNext());
        System.out.println(it.next());
        System.out.println(it.hasNext());
        System.out.println(it.peek());
        System.out.println(it.hasNext());
        System.out.println(it.peek());
        System.out.println(it.hasNext());
        System.out.println(it.next());
        System.out.println(it.hasNext());
        System.out.println(it.peek());
        System.out.println(it.hasNext());
        System.out.println(it.peek());
        System.out.println(it.hasNext());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum Status {
        VIRGINAL,
        RUNNING,
        ITERATOR_FINISHED,
        FINISHED;

    }
}

