/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.yars.util;

import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.logging.Logger;
import org.semanticweb.yars.nx.Node;
import org.semanticweb.yars.nx.Nodes;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CheckLengthIterator
implements Iterator<Node[]> {
    Iterator<Node[]> _in;
    Node[] _next = null;
    IncorrectLengthException _ile = null;
    short _nxlen = 0;
    long _skip = 0L;
    static transient Logger _log = Logger.getLogger(CheckLengthIterator.class.getName());

    public CheckLengthIterator(Iterator<Node[]> iter, short nxlen) {
        this._in = iter;
        this._nxlen = nxlen;
        this.loadNext();
    }

    private void loadNext() {
        this._next = null;
        while (this._in.hasNext() && this._next == null) {
            Node[] next = this._in.next();
            if (next.length != this._nxlen) {
                this._ile = new IncorrectLengthException(next);
                _log.warning(this._ile.getMessage());
                ++this._skip;
                continue;
            }
            this._next = next;
        }
    }

    public long skipped() {
        return this._skip;
    }

    @Override
    public boolean hasNext() {
        return this._next != null;
    }

    public IncorrectLengthException getException() {
        return this._ile;
    }

    public boolean isOkay() {
        return this._ile == null;
    }

    @Override
    public Node[] next() {
        if (this._next == null) {
            throw new NoSuchElementException();
        }
        Node[] next = this._next;
        this.loadNext();
        return next;
    }

    @Override
    public void remove() {
        this._in.remove();
    }

    public static class IncorrectLengthException
    extends Exception {
        private static final long serialVersionUID = 1L;
        private Node[] _a;

        public IncorrectLengthException(String msg) {
            super(msg);
        }

        public IncorrectLengthException(Node[] a) {
            super(IncorrectLengthException.createMessage(a));
            this._a = a;
        }

        public Node[] getProblem() {
            return this._a;
        }

        static String createMessage(Node[] a) {
            StringBuffer buf = new StringBuffer();
            buf.append("Not correct length!");
            buf.append(" " + Nodes.toN3(a) + " ");
            return buf.toString();
        }
    }
}

