/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.yars.stats;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import org.semanticweb.yars.nx.Node;
import org.semanticweb.yars.nx.Resource;
import org.semanticweb.yars.nx.filter.NodeFilter;
import org.semanticweb.yars.nx.namespace.RDF;
import org.semanticweb.yars.nx.parser.NxParser;
import org.semanticweb.yars.nx.parser.ParseException;
import org.semanticweb.yars.stats.CountStmtAnalyser;
import org.semanticweb.yars.stats.DistributionAnalyser;
import org.semanticweb.yars.stats.InputAnalyser;
import org.semanticweb.yars.stats.NodeTransformer;
import org.semanticweb.yars.stats.output.ToVoid;

public class VoiD {
    private static final DecimalFormat twoDigit = new DecimalFormat("###,###,###.##");
    private static final Runtime runtime = Runtime.getRuntime();
    private static final NumberFormat FMT = NumberFormat.getInstance();
    InputAnalyser input;
    private String _dataID;

    public VoiD() {
        FMT.setMaximumFractionDigits(2);
        FMT.setMinimumFractionDigits(2);
    }

    public static long getFreeMem() {
        return runtime.maxMemory() - runtime.totalMemory();
    }

    public static void logMem(String msg) {
        long mem = runtime.maxMemory() - runtime.totalMemory();
        float KBytes = (float)mem / 1024.0f;
        float MBytes = KBytes / 1024.0f;
        float GBytes = MBytes / 1024.0f;
        if (GBytes >= 1.0f) {
            System.err.println("[MEMLOG] (" + msg + ") FreeMemory: " + FMT.format(GBytes) + " GB");
        } else if (MBytes >= 1.0f) {
            System.err.println("[MEMLOG] (" + msg + ") FreeMemory: " + FMT.format(MBytes) + " MB");
        } else {
            System.err.println("[MEMLOG] (" + msg + ") FreeMemory: " + FMT.format(KBytes) + " KB");
        }
    }

    public void analyseVoid(InputStream in, String dataSetId, OutputStream out) throws IOException, ParseException {
        DistributionAnalyser<String> logger;
        this.input = new InputAnalyser(new NxParser(in));
        this._dataID = dataSetId;
        int[] subject = new int[]{0};
        int[] predicate = new int[]{1};
        int[] object = new int[]{2};
        CountStmtAnalyser stmt = new CountStmtAnalyser(this.input);
        int[] classes = new int[]{1, 2};
        NodeFilter[] classFilter = new NodeFilter[]{new NodeFilter.EqualsFilter(RDF.TYPE.toString()), new NodeFilter.ClassFilter(Resource.class)};
        NodeTransformer<Node> classesTrans = new NodeTransformer<Node>(){

            public Node[] processNode(Node[] n) {
                Node[] res = new Node[]{n[1]};
                return res;
            }
        };
        DistributionAnalyser<Node> distClasses = new DistributionAnalyser<Node>(stmt, classFilter, classes, classesTrans);
        NodeTransformer<String> loggerTrans = new NodeTransformer<String>(){
            private int counter;
            String[] res = new String[]{"-"};

            public String[] processNode(Node[] n) {
                ++this.counter;
                if (this.counter % 10000 == 0) {
                    VoiD.logMem("lines " + twoDigit.format(this.counter));
                }
                return this.res;
            }
        };
        DistributionAnalyser<String> run = logger = new DistributionAnalyser<String>(distClasses, loggerTrans);
        while (run.hasNext()) {
            run.next();
        }
        String statements = ToVoid.getStmtString(stmt.getStmt());
        String classDist = ToVoid.getClassDist(distClasses.getStatsMap());
        String datasetContent = ToVoid.getDataSetHeader(this._dataID, statements + classDist);
        String rdf = ToVoid.getRDF(datasetContent);
        out.write(rdf.getBytes());
        out.close();
    }
}

